/******************************************************************************
*                                             COPYRIGHT (c) MOTOROLA 2003   
* FILE NAME: atd.c     REVISION 1.0                                        
*                                                                           
* PURPOSE: ATD Source File
*                                                                           
*******************************************************************************
*                                                                           
*                                                                           
* DESCRIPTION: ATD Source File             
*                                                                           
* NOTE: 
*                                                                           
* AUTHOR: Eduardo Montanez    LOCATION: OHT     LAST EDIT DATE: 11/19/03  
*                                                                           
* UPDATE HISTORY                                                            
* REV      	AUTHOR      DATE       	DESCRIPTION OF CHANGE                    
* ---      	------      ---------   ---------------------                    
* 1.0      	r9aabe    	11/19/03	- Original coding 
*                                                                           
******************************************************************************/

#include "atd.h"

/* Local function prototypes */

void atd_init (void);
void atd0_vector(void);

//***********************************************************************************
//
// Analog to Digital Converter Module Initialization routine
//
//***********************************************************************************

void atd_init (void)
{
	ATDCTL2_ADPU = 1; 	// Enable ATD module
	ATDCTL2_AFFC = 1;   // Fast Flag Clear per conversion complete
  ATDCTL2_ASCIE = 1;  // Sequence Complete Interrupt Enable
	ATDCTL3_S1C = 0;		// Set to 16 conversion per sequence
	ATDCTL3_S2C = 0;
	ATDCTL3_S4C = 0;
	ATDCTL3_S8C = 0;
	ATDCTL3_FIFO = 0;		// No fifo
	ATDCTL3_FRZ = 0;		// No freeze, continue conversion
	ATDCTL4_SRES8 = 1;	// 0 = 10 , 1 = 8 bit ATD resolution
	ATDCTL4_SMP = 0;		// 2 A/D clock periods for sample time
	ATDCTL4_PRS = 0;		// ATD clock = 1/2 busclk = 2MHz
	ATDCTL5_DJM = 0;		// Left justified data in results register
	ATDCTL5_DSGN = 0;		// Unsigned data representation in result register
	ATDCTL5_SCAN = 1;		// Continuous conversion sequences
	ATDCTL5_MULT = 0;		// Sample only one channel
	ATDCTL5_CA = 0;		  // Sets ATD Ch.0 as input channel
	ATDCTL5_CB = 0;
	ATDCTL5_CC = 0;
}

//***********************************************************************************
//
// Analog to Digital Converter Module Interrupt Service Routine
//
//***********************************************************************************

interrupt 22 void atd0_vector(void)
{
	PWMDTY0 = ATDDR0H;		// Variable Ch.0 duty cycle
									      // ATD[0] result register sweeps duty cycle
}	