/*********************************************************************/
/* Project Name: TPM.mcp                                             */
/* Source fle name: TPM.c                                            */
/*********************************************************************/
/* Copyright (C) 2007 Freescale Semiconductor, Inc.                  */
/* All Rights Reserved                                               */
/*********************************************************************/
/*********************************************************************/
/* Hands on training for QE128 MCU's                                 */
/* Module: TPWM using timer output compare functionality             */
/* The firmware was developed and tested on CodeWarrior 6.0 version  */
/*                                                                   */
/* Description: The timer is configured to count up to 0xFFFF        */
/* when an overflow is ocurred PTE0 toggles.                         */
/*********************************************************************/
/*                                                                   */
/* Date: 12/03/2007                                                  */
/* Ulises Corrales Salgado                                           */
/* Application Engineer                                              */
/* RTAC Americas                                                     */
/*********************************************************************/                                                                      

#include <hidef.h> /* for EnableInterrupts macro */
#include "derivative.h" /* include peripheral declarations */

/*********************************************************************/
/*  Function declarations                                            */
/*********************************************************************/

void MCU_Init(void) {
  
 SOPT1 = 0x23;          /* Watchdog disable. Stop Mode Enable. Background Pin enable. RESET pin enable */  
 SCGC1 = 0x80;          /* Bus Clock to the TPM3 module is enabled */
 SCGC2 = 0x00;          /* Disable Bus clock to unused peripherals */
}

void GPIO_Init(void) { 
  
 PTEDD = 0x01;          /* Configure PTE as outputs */
 PTED = 0x00;           /* Put 0's in PTE port */
}

void TPWM_configuration (void) {
 TPM3MOD = 0xFFFF;      /* The counter counts up to 0xFFFF */
 TPM3C3V = 0x0000;      /* The channel interrupt will happen when counter matches */
 TPM3C3SC = 0x54;       /* Channel interrupt enabled and configured as toggle output on compare */
 TPM3SC = 0x0F;         /* TPM clock source is: Bus rate clock divided by 128 */
}

/*********************************************************************/
/*  Main Function                                                    */
/*********************************************************************/

void main(void) {

  MCU_Init();       /* Function that initializes the MCU */
  GPIO_Init();      /* Function that initializes the Ports of the MCU */
  TPWM_configuration();  /* Function that initializes the TPM module */
  
  
  EnableInterrupts; /* enable interrupts */
  
  for(;;) {

  } /* loop forever */
  /* please make sure that you never leave this function */
}                                    


void interrupt VectorNumber_Vtpm3ch3 TPM_ISR(void) {

  TPM3C3SC_CH3F;                /* Clears timer flag */
  TPM3C3SC_CH3F = 0;
  
  PTED_PTED0 = ~PTED_PTED0;     /* Toggle PTE0 */
}