/*********************************************************************/
/* Project Name: KBI.mcp                                             */
/* Source fle name: KBI.c                                            */
/*********************************************************************/
/* Copyright (C) 2007 Freescale Semiconductor, Inc.                  */
/* All Rights Reserved                                               */
/*********************************************************************/
/*********************************************************************/
/* Hands on training for QE128 MCU's                                 */
/* Module: KBI                                                       */
/* The firmware was developed and tested on CodeWarrior 6.0 version  */
/*                                                                   */
/* Description: The KBI module is configured to detect falling edge  */
/* when a push button is pressed (PTD4 to PTD7) PTE0 toggles         */                                                           
/*********************************************************************/
/*                                                                   */
/* Date: 12/03/2007                                                  */
/* Ulises Corrales Salgado                                           */
/* Application Engineer                                              */
/* RTAC Americas                                                     */
/*********************************************************************/                                                                      


#include <hidef.h> /* for EnableInterrupts macro */
#include "derivative.h" /* include peripheral declarations */


/*********************************************************************/
/*  Function declarations                                            */
/*********************************************************************/

void MCU_Init(void) {
  
 SOPT1 = 0x23;          /* Watchdog disable. Stop Mode Enable. Background Pin enable. RESET pin enable */  
 SCGC1 = 0x00;          /* Disable Bus clock to peripherals */
 SCGC2 = 0x10;          /* Bus Clock to the KBI module is enabled */
}

void GPIO_Init(void) { 
  
 PTEDD = 0x01;          /* Configure PTE0 pin as output */
 PTED = 0x00;           /* Put 0's in PTE port */
}


void KBI_configuration(void) {
 
 KBI2SC = 0x06;         /* KBI interrupt request enabled. Detects edges only */
 KBI2PE = 0xF0;         /* PTD4, PTD5, PTD6 and PTD7 enabled as Keyboard interrupts */
 KBI2ES = 0x00;         /* Pins detects falling edge */
}


/*********************************************************************/
/*  Main Function                                                    */
/*********************************************************************/

void main(void) {

  MCU_Init();       /* Function that initializes the MCU */
  GPIO_Init();      /* Function that initializes the Ports of the MCU */
  KBI_configuration();       /* Function that initializes the KBI module */

  EnableInterrupts; /* enable interrupts */
  
   
  for(;;) {

  } /* loop forever */
  /* please make sure that you never leave this function */
}

void interrupt VectorNumber_Vkeyboard KBI_ISR(void) {

KBI2SC_KBACK = 1;   /* Clear the KBI interrupt flag */

PTED_PTED0 ^= 1;    /* Toggles PTE0 */
}