/*********************************************************************/
/* Project Name: ADC.mcp                                             */
/* Source fle name: ADC.c                                            */
/*********************************************************************/
/* Copyright (C) 2007 Freescale Semiconductor, Inc.                  */
/* All Rights Reserved                                               */
/*********************************************************************/
/*********************************************************************/
/* Hands on training for QE128 MCU's                                 */
/* Module: ADC                                                       */
/* The firmware was developed and tested on CodeWarrior 6.0 version  */
/*                                                                   */
/* Description: The ADC module is configured in continuous conversion*/
/* mode, every obtained value is display in port E (8-LEDs)          */
/*********************************************************************/
/*                                                                   */
/* Date: 12/03/2007                                                  */
/* Ulises Corrales Salgado                                           */
/* Application Engineer                                              */
/* RTAC Americas                                                     */
/*********************************************************************/                                                                      

#include <hidef.h> /* for EnableInterrupts macro */
#include "derivative.h" /* include peripheral declarations */

/*********************************************************************/
/*  Function declarations                                            */
/*********************************************************************/

void MCU_Init(void) {
  
 SOPT1 = 0x23;          /* Watchdog disable. Stop Mode Enable. Background Pin enable. RESET pin enable */  
 SCGC1 = 0x10;          /* Bus Clock to the ADC module is enable */
 SCGC2 = 0x00;          /* Disable Bus clock to unused peripherals */
}

void GPIO_Init(void) { 
  
 PTEDD = 0xFF;          /* Configure port E as outputs */
 PTED = 0x00;           /* Put 0's in port E (this will turn the LEDs off) */
}

void ADC_configuration (void) {
  
  ADCSC1 = 0x20;        /* Interrupt disable. Continuous conversion mode and channel 0 active */
  ADCSC2 = 0x00;        /* Software trigger selected */
  ADCCFG = 0x30;        /* Input clock/2. Long Sample time configuration. 8-bit conversion */
  APCTL1 = 0x00;        /* ADC0 pin disable, this pin is working as GPIO */
}

/*********************************************************************/
/*  Main Function                                                    */
/*********************************************************************/

void main(void) {

  MCU_Init();       /* Function that initializes the MCU */
  GPIO_Init();      /* Function that initializes the Ports of the MCU */
  ADC_configuration();  /* Function that initializes the ADC module */
  
             
  EnableInterrupts; /* enable interrupts */
  ADCSC1_AIEN = 1;       /* Enable ADC interrupt */
  APCTL1_ADPC0 = 1;      /* Select the channel for ADC input (the pin stop working as GPIO) */
   
  for(;;) {
 
  } /* loop forever */
  /* please make sure that you never leave this function */
}

void interrupt VectorNumber_Vadc ADC_ISR(void) {

 PTED = ADCRL;          /* Move the adquired ADC value to port E */
}
