/**
 * Copyright (c) 2005, Freescale Semiconductor
 * Freescale Willy Note
 *
 * File name   : main.c
 * Project name: MemMapQG8.mcp
 *
 * Author      : Laura Delgado
 * Department  : RTAC Americas
 *
 * Description : This is a descriptive example of many procedures of memory
 *               allocation in CodeWarrior for 8-bit MCUs.
 *
 *               The example will locate different objects in different 
 *               memory segments. For this example, it is necessary to have
 *			      	 the parameter file (project.prm) at hand since its 
 *		       		 contents are referenced further in the code. 
 *
 *               For the proper compilation of this project it is needed to 
 *               disable the "CONST variable replacement for constants" fea-
 *               ture in the Compiler's options menu (Edit/Standard Settings
 *                /Compiler/Options). 
 *		  
 * History    
 * 10/25/2005  : Release (r12370c)
 */
 
#include "derivative.h" /* include peripheral declarations */


		  /* Memory Sections are referenced and then used  */

#pragma DATA_SEG MY_DATA	       // reference MY_DATA section (MY_DATA is a 
                                 // section created for this example, 
                                 // as well as MY_RAM segment, where MY_DATA 
                                 // is placed)

#pragma DATA_SEG _DATA_ZEROPAGE	 // Change data allocation into the ZeroPage
unsigned char VarZeroSeg;		     // Locate VarZeroSeg in the ZRAM segment. 
 								                 // In the MC9S08QG8 mcu this segment uses 
 					                			 // direct-addressing mode.

int VarNewSeg@"MY_DATA";      	 // Locate VarNewSeg to MY_DATA section


#pragma DATA_SEG DEFAULT		     // Change data allocation back to default
								                 // settings
unsigned char VarDefSeg;		     // Locate VarDefSeg in default RAM

#pragma CONST_SEG MY_CONSTS	   	 // Change constant allocation into MY_CONSTS section  
                                 // (created for this example) that points
                                 //  to the already defined Segment ROM1																 // segment, which is read-only and created

								 
const unsigned char ArrayNewSeg[] = {0xAA, 0xAA, 0xAA, 0xAA, 0xAA};

#pragma CONST_SEG DEFAULT	 	 		 // Change constant allocation back to default
								                 // settings.  
								 								 
							                	 // locate ArrayDefSeg in default ROM							
const int ArrayDefSeg[] = {0xBBBB, 0xBBBB};


#pragma CODE_SEG MY_CODE         // Change code allocation to section MY_CODE
																 // which for this example is located in MY_ROM
                                 
void FunctionNewSec(void);	     // Locate FunctionNewSec in MY_ROM

#pragma CODE_SEG DEFAULT		 // Change code allocation back to default
								 // settings.

/* New segment allocation is finished, default settings are restored for data 
           and code */	 

void main(void) {

   VarZeroSeg = 0x10;            // Use the objects previously initialized      
   VarDefSeg = ArrayNewSeg[3];
   VarNewSeg = ArrayDefSeg[1];
                         
  for(;;) {
  
   FunctionNewSec();             // this function increments VarZeroSeg      

    __RESET_WATCHDOG();          /* feeds the dog */  
  }                              /* loop forever */
}

/**
 * FunctionNewSec: This function is located in the segment ROM2. It 
 *                 initializes a local variable and increments a global one.
 *				 
 * Parameters:      none.
 *
 * Subfunctions:    none.
 *
 * Return:          void
 */

#pragma CODE_SEG MY_CODE

void FunctionNewSec(void){
       
    VarZeroSeg++;

}

#pragma CODE_SEG DEFAULT

