/**
 * Copyright (c) 2005, Freescale Semiconductor
 * Freescale Willy Note
 *
 * File name   : main.c
 * Project name: TPM_IC_GB60.mcp
 *
 * Author : Laura Delgado
 * Department : RTAC Americas
 *
 * Description : This example illustrates the input capture use of the timer 
 *               module. This example makes use of the Device Initialization 
 *               tool for the Timer module set up. 
 *               
 *               For this example, the TPM (Timer/PWM) module is configured
 *               to comply with the following requirements:
 *                     + Timer configured as input compare, on channel 1,  
 *                        When a rising-edge event is captured through
 *                        the channel-specific pin, the most significant byte of 
 *                        the value of the timer at that time is output
 *                        through port F using an interrupt-based approach. 
 *                        Using a 4 MHz system-bus clock, the TPM is prescaled
 *                        to overflow approximately every two seconds 
 *                        (Prescaler = 7).
 *                                                                                   
 *               The initialization of the module is the Device Initialization tool 
 *               automatically generated MCUinit.c code, which was included in this 
 *               project.
 *
 *               This example was explicitly made for the MC9S08GB60 microcontroller 
 *               migrating may need some changes in the code.
 *           
 *               (Refer to AN3136 for more information about Device Initialization)
 *
 *               Channel PTD1/TPM1CH1 might need a pull down resistor.
 * History :   
 * 10/22/2005  : Migration to CW 4.0 (r12370c)
 */

#include <hidef.h> /* for EnableInterrupts macro */
#include "derivative.h" /* include peripheral declarations */
#include "MCUinit.h"

void main(void) {

    MCU_init();

  for(;;) {
  } /* loop forever */
  /* please make sure that you never leave this function */
}
