/**
* Copyright (c) 2005, Freescale Semiconductor
* Freescale Willy Note
*
* File name : main.c
* Project name: Interrupts_GB60.mcp
*
* Author : Laura Delgado
* Department : RTAC Americas
*
* Description : This example illustrates the implementation of interrupts in 
*               CodeWarrior. This example uses copied code from the Device 
*               Initialization tool automatically generated code for the Timer. 
*               module set up. The Timer module will trigger the interrupt 
*               routines to be used in this example: 
*               
*               For this example, the TPM (Timer/PWM) module is configured
*               to comply with the following requirements:
*                       + Timer configured as output compare, to toggle the 
*                           output (PTD0/TPM1CH0) when counter reaches compare value 
*                           0X0FFF.
*                           
*                       + Timer period of 262 ms (bus clock selected as
*                           clock source, prescale value of 32, modulo counter 
*                           at 0x7FFF)
*                           
*                       + The selected channel output pin is PTD0/TPMCH0 and
*                           has no pull resistor.
*                       
*                       + Both, overflow and channel interrupts are enabled 
*                           to toggle a LED when their corresponding ISR 
*                           is serviced.
*                       
*                       +  PTB6 and PTB7 are initialized as outputs to control
*                            the LEDs                         
*                                                       
*               The initialization of the module is the Device Initialization tool 
*               automatically generated MCUinit.c code, which was not included in this 
*               project. 
*
*               This example was explicitly made for the MC9S08GB60 microcontroller 
*               migrating may need some changes in the code.
*           
*               (Refer to AN3136 for more information about Device Initialization)
* History :   
* 10/08/2005  : Release (r12370c)
*/



#include <hidef.h> /* for EnableInterrupts macro */
#include "derivative.h" /* include peripheral declarations */

void MCUinit(void);

unsigned char VarA;
unsigned char VarB;


void main(void) {

  MCUinit();

  for(;;) {

				/* wait to receive timer interrupts*/

  } 
}

void MCUinit(void)
{
  /* ### MC9S08GB60 "Cpu" init code ... */
  /*  PE initialization code after reset */
  /*  System clock initialization */
  SOPT = 0x53;                                      
  SPMSC1 = 0x1C;                                      
  SPMSC2 = 0x00;                                      
  ICGC1 = 0x44;                                      
  ICGC2 = 0x00;                                      
  /* Common initialization of the write once registers */

  /* Common initialization of the CPU registers */
  PTDPE &= (unsigned char)~0x01;                              
  PTASE = 0x00;                                      
  PTBSE = 0x00;                                      
  PTCSE = 0x00;                                      
  PTDSE = 0x00;                                      
  PTESE = 0x00;                                      
  PTFSE = 0x00;                                      
  PTGSE = 0x00;                                      
  /* ### Init_TPM init code */
  TPM1MOD = 0x7FFF;                                      
  TPM1C0V = 0x0FFF;                                      
  TPM1C0SC = 0x54;                                      

  TPM1SC = 0x4D;                                      
  /* ### Init_GPIO init code */
  PTFPE &= (unsigned char)~0x03;                              
  PTFDD |= (unsigned char)0x03;                               
  /* ### Init_COP init code */
  SRS = 0xFF;                                      

  /* ### */
  EnableInterrupts; /* enable interrupts */
} /*MCU_init*/


void interrupt 5 Vtpm1ch0_isr (void){

    TPM1C0SC_CH0F = 0;  /* ACK channel interrupt */
                        /* Reading flag, then write a zero to the bit. */ 
    
    VarA++;
    
    PTFD_PTFD0 = ~PTFD_PTFD0; 

}

void interrupt 8 Vtpm1ovf_isr (void){

    TPM1SC_TOF = 0;    /* ACK timer overflow interrupt */
                       /* Reading flag, then write a zero to the bit. */ 
    
    VarB++;
    
    PTFD_PTFD1 = ~PTFD_PTFD1;

}