/**
* Copyright (c) 2005, Freescale Semiconductor
* Freescale Willy Note
*
* File name : main.c
* Project name: ICG.mcp
*
* Author : Sergio Garca de Alba Garcin
*          Gonzalo Delgado Huitron
* Department : RTAC Americas
*
* Description : This example illustrates the use of the ICG module for the 
*               MC9S08GB60 microcontroller. It is assumed that for the external 
*               oscillator a 32 MHz crystal is being used. This project was 
*               made with the Device Initialization tool which sets the 
*               module, according to the user's needs. For this example, 
*               the ICG module is configured 
*               to comply with the following requirements:
*               + COP is disabled 
*
*                            
* (Refer to AN3136 for more information about Device Initialization)
*
* History :   
* 10/08/2005  : Release (rgd04c)
*/

#include <hidef.h> /* for EnableInterrupts macro */
#include "derivative.h" /* include peripheral declarations */
#include "MCUinit.h"

/* Uncomment the desired mode */

//#define FEE	   /* LED will blink every 1 seconds (using 32kHz XTAL) */
//#define FEI	   /* LED will blink every 2 seconds */   
#define SCM	   /* LED will blink every .4 seconds */
//#define FBE		   /* LED will blink every 4 seconds (using 32kHz XTAL) */

void ICGsetup(void);

void main(void) {
	MCU_init();
  EnableInterrupts; /* enable interrupts */
  ICGsetup();
  
  TPM1SC=0x0E;		/* bus clock selected as TPM clock source, prescaler set to divide by 64 */
  TPM1C0SC=0x14;    /* configuration for Togle output on compare (pin PTD0) */
  							
  #ifdef FBE	    
  TPM1SC=0x08;		/* in FBE mode, set prescaler to divide by 1 */
  #endif
  
 
  for(;;) {

  } /* loop forever */

}


void ICGsetup (void) {

#ifdef FBE
   ICGC2=0x70;
   ICGC1=0x30;
  while(ICGS1_ERCS==0);	 /* pause execution until the external reference clock is stable */
#endif

#ifdef FEE 
  ICGC2=0x00;
  ICGC1=0x38;
  while(ICGS1_LOCK==0);	 /* pause execution until the FLL has locked */
  while(ICGS2_DCOS==0);  /* optional for time critical tasks */
#endif

#ifdef FEI
  ICGC2=0x01;
  ICGC1=0x28;	
  while(ICGS1_LOCK==0);	 /* pause execution until the FLL has locked */
  while(ICGS2_DCOS==0);  /* optional for time critical tasks */
#endif
  
#ifdef SCM
  ICGFLT=0x940;
  ICGC2=0x01;
#endif

}