/**
* Copyright (c) 2005, Freescale Semiconductor
* Freescale Willy Note
*
* File name : main.c
* Project name: ADC_GB60.mcp
*
* Author : Andrs Barrilado
* Department : RTAC Americas
*
* Description : This example illustrates the use of the ADC module for the 
*               MC9S08GB60 microcontroller. This project was made with the 
*               Device Initialization tool which sets the module, according to 
*               the user's needs. For this example, the ADC module is configured
*               to trigger the channel interrupt every time the timer overflows and
*               toggle a LED to show the service of this interrupt event. 
*               The example's configuration goes as follows:
*                       + Software conversion trigger selected, single conversion
*                         mode (to allow conversion only when the conversion complete 
*                         flag is set), 8-bit resolution sample, left alignment,  
*                       + 71.428 khz as sampling frequency (obtained with a prescaler 
*                          value of 0).
*                       + PTB1/AD1P1 channel pin enabled and INITIALIZED as analog 
*                            input (IO control disabled).
*                       + Interrupt enabled - allows to display the most 
*                            significant four of bits in four leds when a conversion
*                            is made. 
*                       + LEDS are controlled by PTF0-PTF3,which must be 
*                            initialized as output pins as well. 
*
*               The initialization of the module is the Device Initialization tool 
*               automatically generated MCUinit.c code, which was included in this 
*               project.
*
*               This example was explicitly made for the MC9S08GB60 microcontroller 
*               migrating may need some changes in the code.
*           
*               (Refer to AN3136 for more information about Device Initialization)

* History :   
* 10/22/2005  : Migration to CW 4.0(r12370c)
*/
#include <hidef.h> /* for EnableInterrupts macro */
#include "derivative.h" /* include peripheral declarations */
#include "MCUinit.h"

void main(void) {

    MCU_init();
    
  for(;;) {

  } 
}
