/*
 * The Clear BSD License
 * Copyright (c) 2017, NXP Semiconductor, Inc.
 * All rights reserved.
 *
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted (subject to the limitations in the disclaimer below) provided
 * that the following conditions are met:
 *
 * o Redistributions of source code must retain the above copyright notice, this list
 *   of conditions and the following disclaimer.
 *
 * o Redistributions in binary form must reproduce the above copyright notice, this
 *   list of conditions and the following disclaimer in the documentation and/or
 *   other materials provided with the distribution.
 *
 * o Neither the name of copyright holder nor the names of its
 *   contributors may be used to endorse or promote products derived from this
 *   software without specific prior written permission.
 *
 * NO EXPRESS OR IMPLIED LICENSES TO ANY PARTY'S PATENT RIGHTS ARE GRANTED BY THIS LICENSE.
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/*
 * spirit_level_test.c
 *
 */

#include "main.h"

#define MSG_STRING_LEN 80

#define I2C_MASTER_CLOCK_FREQUENCY CLOCK_GetFreq(kCLOCK_Flexcomm2)
#define EXAMPLE_I2C_MASTER_BASE (I2C2_BASE)

extern bool done;

i2c_master_handle_t g_MasterHandle;
static char msgString[MSG_STRING_LEN];

/* MMA8652 device address */
const uint8_t g_accel_address = 0x1DU;
uint8_t accelGValue = 0;
uint8_t dataScale = 0;
int16_t accelXData = 0;
int16_t accelYData = 0;
int16_t accelZData = 0;
int16_t xAngle = 0;
int16_t yAngle = 0;
int16_t zAngle = 0;


status_t level_test_cmd (uint32_t argc, char *argv[])
{
    mma_handle_t mmaHandle = {0};
    mma_data_t accelSensorData = {0};
    i2c_master_config_t masterConfig;

    /* Define the init structure for the output LED pin*/
	gpio_pin_config_t led_config =
	{
	   kGPIO_DigitalOutput, 0,
	};

//	PRINTF("%s \n", __FUNCTION__);

    /*Setup Accelerometer*/
    mmaHandle.base = BOARD_ACCEL_I2C_BASEADDR;
    mmaHandle.i2cHandle = &g_MasterHandle;

    /*
       * masterConfig->enableMaster = true;
       * masterConfig->baudRate_Bps = 100000U;
       * masterConfig->enableTimeout = false;
       */
    I2C_MasterGetDefaultConfig(&masterConfig);
    I2C_MasterInit(BOARD_ACCEL_I2C_BASEADDR, &masterConfig, I2C_MASTER_CLOCK_FREQUENCY);
    I2C_MasterTransferCreateHandle(BOARD_ACCEL_I2C_BASEADDR, &g_MasterHandle, NULL, NULL);

    mmaHandle.xfer.slaveAddress = g_accel_address;
    mmaHandle.xfer.direction = kI2C_Write;

    /*Initialize the accelerometer device:- Dynamic range : -4g to +4g; FIFO : disabled; F_READ : Normal Read mode*/
    if (MMA_Init(&mmaHandle) != kStatus_Success)
    {
        PRINTF ("Failed to initialize accelerometer\n\r");
        return kStatus_Fail;
    }

    /* Get Accelerometer dynamic range */
    if (MMA_ReadReg(&mmaHandle, kMMA8652_XYZ_DATA_CFG, &accelGValue) != kStatus_Success)
    {
        PRINTF ("Failed to get accelerometer dynamic range\n\r");
        return kStatus_Fail;
    }
    /*Check FS bits[1:0] for dynamic range value : 2g = 0x00; 4g = 0x01; 8g = 0x02 */
    if ((accelGValue & 0x03) == 0x00)
    {
        dataScale = 2;
    }
    else if ((accelGValue & 0x03) == 0x01)
    {
        dataScale = 4;
    }
    else if ((accelGValue & 0x03) == 0x02)
    {
        dataScale = 8;
    }

    //PRINTF("\n\r Accelerometer initialized");

    /* Init output LED GPIO. */
       GPIO_PortInit(GPIO, BOARD_LED3_PORT);
       GPIO_PortInit(GPIO, BOARD_LED2_PORT);
       GPIO_PortInit(GPIO, BOARD_LED1_PORT);

       GPIO_PinInit(GPIO, BOARD_LED3_PORT, BOARD_LED3_PIN, &led_config);
       GPIO_PinInit(GPIO, BOARD_LED2_PORT, BOARD_LED2_PIN, &led_config);
       GPIO_PinInit(GPIO, BOARD_LED2_PORT, BOARD_LED1_PIN, &led_config);

       GUI_Clear();
       snprintf(msgString,MSG_STRING_LEN,"\n\rRunning Spirit Level application\n\r");
       GUI_DispString(msgString);
       PRINTF(msgString);
       snprintf(msgString,MSG_STRING_LEN,"Press User button (SW5) to go to Self-Test main menu\n\r");
       GUI_DispString(msgString);
       PRINTF(msgString);

    while (1)
        {

    		/* Read Accelerometer Sensor Data*/
            if (MMA_ReadSensorData(&mmaHandle, &accelSensorData) != kStatus_Success)
            {
                return kStatus_Fail;
            }

            /* Save each sensor data as a 16 bit result.
            * The 16 bit result is in left-justified format.
            * Shift 4 bits to the right(12-bit resolution) to get the actual value.
            */
            accelXData =
                (int16_t)(((uint16_t)(accelSensorData.accelXMSB << 8)) | ((uint16_t)(accelSensorData.accelXLSB))) / 16U;
            accelYData =
                (int16_t)(((uint16_t)(accelSensorData.accelYMSB << 8)) | ((uint16_t)(accelSensorData.accelYLSB))) / 16U;
            accelZData =
                (int16_t)(((uint16_t)(accelSensorData.accelZMSB << 8)) | ((uint16_t)(accelSensorData.accelZLSB))) / 16U;

            /* Convert raw accelerometer sensor data to angle (normalize to 0-90 degrees). No negative angles. */
            xAngle = (int16_t)floor((double)accelXData * (double)dataScale * 180 / 4096);
            yAngle = (int16_t)floor((double)accelYData * (double)dataScale * 180 / 4096);

            snprintf(msgString,MSG_STRING_LEN,"\r\n\t X angle = %3d Y angle = %3d",xAngle,yAngle);
            GUI_DispStringAt(msgString, 30, 100);
//            PRINTF(msgString);

            if((yAngle < 90) && (yAngle > 50))
			{
				GPIO_PinWrite(GPIO, BOARD_LED3_PORT,BOARD_LED3_PIN,1);
				GPIO_PinWrite(GPIO, BOARD_LED2_PORT,BOARD_LED2_PIN,1);
				GPIO_PinWrite(GPIO, BOARD_LED1_PORT,BOARD_LED1_PIN,0);
			}

            if((yAngle < 50) && (yAngle > 15))
			{
				GPIO_PinWrite(GPIO, BOARD_LED3_PORT,BOARD_LED3_PIN,1);
				GPIO_PinWrite(GPIO, BOARD_LED2_PORT,BOARD_LED2_PIN,0);
				GPIO_PinWrite(GPIO, BOARD_LED1_PORT,BOARD_LED1_PIN,0);
			}

            if((yAngle < 15) && (yAngle > -15))
			{
				GPIO_PinWrite(GPIO, BOARD_LED3_PORT,BOARD_LED3_PIN,0);
				GPIO_PinWrite(GPIO, BOARD_LED2_PORT,BOARD_LED2_PIN,0);
				GPIO_PinWrite(GPIO, BOARD_LED1_PORT,BOARD_LED1_PIN,0);
			}

       		if((yAngle < -15) && (yAngle > -50))
			{
				GPIO_PinWrite(GPIO, BOARD_LED3_PORT,BOARD_LED3_PIN,0);
				GPIO_PinWrite(GPIO, BOARD_LED2_PORT,BOARD_LED2_PIN,0);
				GPIO_PinWrite(GPIO, BOARD_LED1_PORT,BOARD_LED1_PIN,1);
			}

			if((yAngle < -50) && (yAngle > -90))
			{
				GPIO_PinWrite(GPIO, BOARD_LED3_PORT,BOARD_LED3_PIN,0);
				GPIO_PinWrite(GPIO, BOARD_LED2_PORT,BOARD_LED2_PIN,1);
				GPIO_PinWrite(GPIO, BOARD_LED1_PORT,BOARD_LED1_PIN,1);
			}

			if (done)
				break;
         }
    done = false;
    GUI_Display_Help();
    cli_help();
    return kStatus_Success;
}

