/*
 * The Clear BSD License
 * Copyright (c) 2017, NXP Semiconductor, Inc.
 * All rights reserved.
 *
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted (subject to the limitations in the disclaimer below) provided
 * that the following conditions are met:
 *
 * o Redistributions of source code must retain the above copyright notice, this list
 *   of conditions and the following disclaimer.
 *
 * o Redistributions in binary form must reproduce the above copyright notice, this
 *   list of conditions and the following disclaimer in the documentation and/or
 *   other materials provided with the distribution.
 *
 * o Neither the name of copyright holder nor the names of its
 *   contributors may be used to endorse or promote products derived from this
 *   software without specific prior written permission.
 *
 * NO EXPRESS OR IMPLIED LICENSES TO ANY PARTY'S PATENT RIGHTS ARE GRANTED BY THIS LICENSE.
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/*
 * ethernet_test.c
 *
 */

#include "main.h"

extern bool done;

#define APP_LCD LCD
#define LCD_PANEL_CLK 9000000
#define LCD_PPL 480
#define LCD_HSW 2
#define LCD_HFP 8
#define LCD_HBP 43
#define LCD_LPP 272
#define LCD_VSW 10
#define LCD_VFP 4
#define LCD_VBP 12
#define LCD_POL_FLAGS kLCDC_InvertVsyncPolarity | kLCDC_InvertHsyncPolarity
#define IMG_HEIGHT 272
#define IMG_WIDTH 480
#define LCD_INPUT_CLK_FREQ CLOCK_GetFreq(kCLOCK_LCD)
#define APP_LCD_IRQHandler LCD_IRQHandler
#define APP_LCD_IRQn LCD_IRQn
#define EXAMPLE_I2C_MASTER_BASE (I2C2_BASE)
#define I2C_MASTER_CLOCK_FREQUENCY (12000000)
#define APP_PIXEL_PER_BYTE 8

#define EXAMPLE_I2C_MASTER ((I2C_Type *)EXAMPLE_I2C_MASTER_BASE)
#define I2C_MASTER_SLAVE_ADDR_7BIT 0x7EU
#define I2C_BAUDRATE 100000U


#if (defined(__CC_ARM) || defined(__GNUC__))
__attribute__((aligned(8)))
#elif defined(__ICCARM__)
#pragma data_alignment = 8
#else
#error Toolchain not support.
#endif
static uint8_t s_frameBufs[IMG_HEIGHT][IMG_WIDTH / APP_PIXEL_PER_BYTE];
void *vram_ptr = s_frameBufs;

/* Frame end flag. */
//static volatile bool s_frameEndFlag;

/* Color palette. */
// static const uint32_t palette[] = {0x0000001F};

/* 32x32 pixel cursor image. */
#if (defined(__CC_ARM) || defined(__GNUC__))
__attribute__((aligned(4)))
#elif defined(__ICCARM__)
#pragma data_alignment = 4
#else
#error Toolchain not support.
#endif

static void APP_FillBuffer(void *buffer)
{
    uint16_t* fb = (uint16_t*)buffer;
      for(int i = 0; i < IMG_WIDTH*55; i++)
        *fb++ = 0xF800;
      for(int i = 0; i < IMG_WIDTH*54; i++)
        *fb++ = 0x7E0;
      for(int i = 0; i < IMG_WIDTH*54; i++)
        *fb++ = 0x1F;
      for(int i = 0; i < IMG_WIDTH*54; i++)
        *fb++ = 0xFFFF;
      for(int i = 0; i < IMG_WIDTH*55; i++)
        *fb++ = 0x0;
}

status_t APP_I2C_Init(void)
{
    i2c_master_config_t masterConfig;

    I2C_MasterGetDefaultConfig(&masterConfig);

    /* Change the default baudrate configuration */
    masterConfig.baudRate_Bps = I2C_BAUDRATE;

    /* Initialize the I2C master peripheral */
    I2C_MasterInit(EXAMPLE_I2C_MASTER, &masterConfig, I2C_MASTER_CLOCK_FREQUENCY);

    return kStatus_Success;
}

void APP_SetCursorPosition(int posX, int posY)
{
    posX -= 12;
    posY -= 5;

    LCDC_SetCursorPosition(APP_LCD, posX, posY);
}


void lcd_touch_test_cmd (uint32_t argc, char *argv[])
{
    int cursorPosX = 0U;
    int cursorPosY = 0U;

    ft5406_handle_t touch_handle;
    touch_event_t touch_event;

    status_t status;

    gpio_pin_config_t pin_config =
    {
        kGPIO_DigitalOutput, 0,
    };
// Ensure EMC is selected; could be wrong if ethernet test was run
    BOARD_InitSDRAMPins();

    PRINTF("\r\nLCD touch panel test\r\n");
    PRINTF("\r\nLCD will display color bar test pattern and cursor.\r\n");
    PRINTF("\r\nEnsure JP14 and JP15 are in the SD position; restart test if this is not the case.\r\n");
    PRINTF("\r\nPress User button to exit test.\r\n");
    APP_FillBuffer((void *)(VRAM_ADDR));

    status = APP_LCDC_Init();
    if (status != kStatus_Success)
    {
        PRINTF("LCD init failed\r\n");
    	goto exit;
    }

    status = APP_I2C_Init();
    if (status != kStatus_Success)
    {
        PRINTF("I2C init failed\r\n");
    }
    assert(status == kStatus_Success);

    GPIO_PinInit(GPIO, 2, 27, &pin_config);
    GPIO_PinWrite(GPIO, 2, 27, 1);

    status = FT5406_Init(&touch_handle, EXAMPLE_I2C_MASTER);
    if (status != kStatus_Success)
    {
        PRINTF("\r\nTouch panel init failed\r\n");
        goto exit;
    }
//    assert(status == kStatus_Success);

    LCDC_EnableCursor(APP_LCD,true);

    for (;;)
    {
        if (kStatus_Success == FT5406_GetSingleTouch(&touch_handle, &touch_event, &cursorPosX, &cursorPosY))
        {
            if ((touch_event == kTouch_Down) || (touch_event == kTouch_Contact))
            {
                /* Update cursor position */
                APP_SetCursorPosition(cursorPosY, cursorPosX);
//                PRINTF("0x%2x 0x%2x", cursorPosX, cursorPosY);
//                PRINTF("\r\n");
            }
        }
        else
        {
            PRINTF("error reading touch controller\r\n");
        }

		if (done)
			break;
     }
    LCDC_EnableCursor(APP_LCD,false);
exit:
 	done = false;
    GUI_Display_Prompt();
    cli_display_prompt();
}

