#ifndef __THERMOSTAT_KEYS__

  #define __THERMOSTAT_KEYS__
  
  #include "S08_Keyboard.h"
  #include "S08_IRQ.h"
  #include "FslTypes.h"
  
  #define UP_PIN               KB_PIN3
  #define DOWN_PIN             KB_PIN2
  #define TIME_PIN             KB_PIN1
  #define PROGRAM_PIN          KB_PIN0
  #define RUN_HOLD_PIN         PTCD_PTCD7
  
  
  /*
  #define UP_KEY               KB_PIN3_EVENT
  #define DOWN_KEY             KB_PIN2_EVENT
  #define TIME_DATE_KEY        KB_PIN1_EVENT
  #define PROGRAM_KEY          KB_PIN0_EVENT
  #define RUN_HOLD_KEY         gu8TPM_Status & (1<<TPM1_CHAN0_INTERRUPT)
  */
  
  #define UP_KEY               KB_PIN3_EVENT || (!(KB_PORT & (1<<UP_PIN)))
  #define DOWN_KEY             KB_PIN2_EVENT || (!(KB_PORT & (1<<DOWN_PIN)))
  #define TIME_DATE_KEY        KB_PIN1_EVENT || (!(KB_PORT & (1<<TIME_PIN)))
  #define PROGRAM_KEY          KB_PIN0_EVENT || (!(KB_PORT & (1<<RUN_HOLD_PIN)))
  //#define RUN_HOLD_KEY       gu8TPM_Status & (1<<TPM1_CHAN0_INTERRUPT) || (!PTCD_PTCD2)
  //#define RUN_HOLD_KEY         IRQ_Occurred() || (!IRQ_Pin)
  #define RUN_HOLD_KEY         IRQ_Occurred()
  
  #define UP_KEY_CLEAR         KB_PIN3_CLEAR_EVENT
  #define DOWN_KEY_CLEAR       KB_PIN2_CLEAR_EVENT
  #define TIME_DATE_KEY_CLEAR  KB_PIN1_CLEAR_EVENT
  #define PROGRAM_KEY_CLEAR    KB_PIN0_CLEAR_EVENT
  //#define RUN_HOLD_KEY_CLEAR   gu8TPM_Status &= ~(1<<TPM1_CHAN0_INTERRUPT)
  #define RUN_HOLD_KEY_CLEAR   IRQ_Clear_Event()
  
  #define AcknowledgeKBInterrupts()     KBISC_KBACK = 1;\
                                        IRQSC_IRQACK = 1;
                                        
  #define DisableKBInterrupts()         KBISC_KBIE = 0;\
                                        IRQSC_IRQIE= 0;
  
  #define EnableKBInterrupts()          KBISC_KBIE = 1;\
                                        IRQSC_IRQIE= 1;
  
  typedef enum
  {
    TIME_DATE_KEY_PRESSED,
    PROGRAM_KEY_PRESSED,
    RUN_HOLD_KEY_PRESSED,
    UP_KEY_PRESSED,
    DOWN_KEY_PRESSED,
  }_TSTAT_KEYS_ENUM_;
  
  
  //#define THERMOSTAT_KB_PRESSED()    (TIME_DATE_KEY || UP_KEY || DOWN_KEY || PROGRAM_KEY || RUN_HOLD_KEY)
  
  #define THERMOSTAT_KB_PRESSED()    (TIME_DATE_KEY || UP_KEY || DOWN_KEY || PROGRAM_KEY || RUN_HOLD_KEY \
                                     || (!(KB_PORT & (1<<UP_PIN)))\
                                     || (!(KB_PORT & (1<<DOWN_PIN)))\
                                     || (!(KB_PORT & (1<<TIME_PIN)))\
                                     || (!(KB_PORT & (1<<PROGRAM_PIN))))
                                     //|| (!RUN_HOLD_PIN))

  
  #define THERMOSTAT_CLEAR_KEYS()    TIME_DATE_KEY_CLEAR;\
                                     UP_KEY_CLEAR;\
                                     DOWN_KEY_CLEAR;\
                                     PROGRAM_KEY_CLEAR;\
                                     RUN_HOLD_KEY_CLEAR

  
  
  void vfnThermostatKeys_Init(void); 
  UINT8 u8ThermostatGetKey(void);
  
#endif
