#include "S08_Keyboard.h"

UINT8 gu8KB_Status;

void vfnKeyboard_Init(UINT8 lu8KeyboardPinsUsed, UINT8 lu8KB_Configuration)
{
  
  /* Configure the pins used */
  KBIPE = lu8KeyboardPinsUsed;
  
  KB_PULLUPS |= lu8KeyboardPinsUsed;
  KB_DDR &= ~lu8KeyboardPinsUsed;

  
  KBISC = lu8KB_Configuration | KBISC_KBACK_MASK;
  gu8KB_Status = 0xFF;
}


__interrupt VectorNumber_Vkeyboard void KeyboardISR(void)
{
  KBISC_KBACK = 1;
  /* Read the Keyboard Port to check the pins with a low level */
  gu8KB_Status = KB_PORT;

}