/** ###################################################################
**     Filename  : Events.H
**     Project   : PE_LL64_Quick_Start
**     Processor : MC9S08LL64C_LQFP80
**     Beantype  : Events
**     Version   : Driver 01.02
**     Compiler  : CodeWarrior HCS08 C Compiler
**     Date/Time : 5/26/2009, 3:40 PM
**     Abstract  :
**         This is user's event module.
**         Put your event handler code here.
**     Settings  :
**     Contents  :
**         No public methods
**
** ###################################################################*/

#ifndef __Events_H
#define __Events_H
/* MODULE Events */

#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"
#include "PE_Timer.h"
#include "LCD1.h"
#include "ADC1.h"
#include "LED1.h"
#include "LED2.h"
#include "LED3.h"
#include "LED4.h"
#include "TOD1.h"
#include "IRQ1.h"
#include "AS1.h"
#include "ACCEL_SLEEP_B.h"
#include "KBI1.h"
#include "BUZZER.h"

void KB1_OnInterrupt(void);
/*
** ===================================================================
**     Event       :  KB1_OnInterrupt (module Events)
**
**     From bean   :  KB1 [KBI]
**     Description :
**         This event is called when the active signal edge/level
**         occurs. This event is enabled only if Interrupt
**         service/events are enabled.
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/

#ifdef ISR_IN_NONBANKED
#pragma CODE_SEG __NEAR_SEG NON_BANKED
#endif
__interrupt void TOD_Interrupt(void);
/*
** ===================================================================
**     Interrupt handler : TOD_Interrupt
**
**     Description :
**         User interrupt service routine. 
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
__interrupt void KBI_Isr(void);
/*
** ===================================================================
**     Interrupt handler : KBI_Isr
**
**     Description :
**         User interrupt service routine. 
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/

__interrupt void tod_interrupt(void);
/*
** ===================================================================
**     Interrupt handler : tod_interrupt
**
**     Description :
**         User interrupt service routine. 
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
#ifdef ISR_IN_NONBANKED
#pragma CODE_SEG DEFAULT
#endif



#ifdef ISR_IN_NONBANKED
#pragma CODE_SEG __NEAR_SEG NON_BANKED
#endif
__interrupt void TOD_isr(void);
/*
** ===================================================================
**     Interrupt handler : TOD_isr
**
**     Description :
**         User interrupt service routine. 
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
#ifdef ISR_IN_NONBANKED
#pragma CODE_SEG DEFAULT
#endif



#ifdef ISR_IN_NONBANKED
#pragma CODE_SEG __NEAR_SEG NON_BANKED
#endif
__interrupt void IRQ_ISR(void);
/*
** ===================================================================
**     Interrupt handler : IRQ_ISR
**
**     Description :
**         User interrupt service routine. 
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
#ifdef ISR_IN_NONBANKED
#pragma CODE_SEG DEFAULT
#endif



#ifdef ISR_IN_NONBANKED
#pragma CODE_SEG __NEAR_SEG NON_BANKED
#endif
__interrupt void SCI_ERROR_ISR(void);
/*
** ===================================================================
**     Interrupt handler : SCI_ERROR_ISR
**
**     Description :
**         User interrupt service routine. 
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
#ifdef ISR_IN_NONBANKED
#pragma CODE_SEG DEFAULT
#endif



void BUZZER_OnEnd(void);
/*
** ===================================================================
**     Event       :  BUZZER_OnEnd (module Events)
**
**     From bean   :  BUZZER [PWM]
**     Description :
**         This event is called when the specified number of cycles has
**         been generated. (Only when the bean is enabled - <Enable>
**         and the events are enabled - <EnableEvent>). The event is
**         available only when the <Interrupt service/event> property
**         is enabled.
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/

#ifdef ISR_IN_NONBANKED
#pragma CODE_SEG __NEAR_SEG NON_BANKED
#endif
__interrupt void KBIOnInterrupt(void);
/*
** ===================================================================
**     Interrupt handler : KBIOnInterrupt
**
**     Description :
**         User interrupt service routine. 
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
#ifdef ISR_IN_NONBANKED
#pragma CODE_SEG DEFAULT
#endif



#ifdef ISR_IN_NONBANKED
#pragma CODE_SEG __NEAR_SEG NON_BANKED
#endif
__interrupt void KBI_ISR(void);
/*
** ===================================================================
**     Interrupt handler : KBI_ISR
**
**     Description :
**         User interrupt service routine. 
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
#ifdef ISR_IN_NONBANKED
#pragma CODE_SEG DEFAULT
#endif



/* END Events */
#endif /* __Events_H*/

/*
** ###################################################################
**
**     This file was created by Processor Expert 3.06 [04.26]
**     for the Freescale HCS08 series of microcontrollers.
**
** ###################################################################
*/
