/** ###################################################################
**     Filename  : LCD1.C
**     Processor : MC9S08LL64C_LQFP80
**     Beantype  : Init_LCD
**     Compiler  : CodeWarrior HCS08 C Compiler
**     Date/Time : 8/13/2009, 7:23 PM
**     Abstract  :
**          This file implements the Liquid Crystal Display (LCD)
**          module initialization according to the Peripheral 
**          Initialization Bean settings, and defines interrupt service 
**          routines prototypes.
**     Settings  :
**          Bean name                                      : LCD1
**          Device                                         : LCD
**          Settings                                       : 
**            Clock settings                               : 
**              Clock source select                        : External clock reference
**              Base clock prescaler                       : 8
**              LCD module clock                           : 33 kHz
**              Base clock                                 : 64.453 Hz
**              Charge pump clock adjust                   : Slowest clock
**              Charge pump clock                          : 687.5 Hz
**              Blink rate bits value                      : 4
**              Blink rate                                 : 0.50354 Hz
**              Frame frequency                            : 32.226 Hz
**              Duty                                       : 1/2
**            Stop in Wait mode                            : no
**            Stop in Stop3 mode                           : no
**            Regulated volatge                            : Enabled
**            Regulated volatge trim                       : 0
**            Charge pump                                  : Enabled
**            Charge pump mode                             : Voltage doubler
**            Op Amp control                               : Buffered mode
**            Voltage supply control                       : Drive VLL3 externally
**            Blink mode select                            : Alternate Display
**            Data register mode select                    : On/Off control
**            Display mode                                 : 2 backplanes
**          Pins                                           : 
**            Frontplane pin 0 :
**              Frontplane  pin                            : PTD0_LCD0
**              Frontplane pin signal                      : PIN1
**            Frontplane pin 1 :
**              Frontplane  pin                            : PTD1_LCD1
**              Frontplane pin signal                      : PIN2
**            Frontplane pin 2 :
**              Frontplane  pin                            : PTD2_LCD2
**              Frontplane pin signal                      : PIN3
**            Frontplane pin 3 :
**              Frontplane  pin                            : PTD3_LCD3
**              Frontplane pin signal                      : PIN4
**            Frontplane pin 4 :
**              Frontplane  pin                            : PTD4_LCD4
**              Frontplane pin signal                      : PIN5
**            Frontplane pin 5 :
**              Frontplane  pin                            : PTD5_LCD5
**              Frontplane pin signal                      : PIN6
**            Frontplane pin 6 :
**              Frontplane  pin                            : PTD6_LCD6
**              Frontplane pin signal                      : PIN7
**            Frontplane pin 7 :
**              Frontplane  pin                            : PTD7_LCD7
**              Frontplane pin signal                      : PIN8
**            Frontplane pin 8 :
**              Frontplane  pin                            : PTE0_LCD13
**              Frontplane pin signal                      : PIN9
**            Frontplane pin 9 :
**              Frontplane  pin                            : PTE1_LCD14
**              Frontplane pin signal                      : PIN10
**            Frontplane pin 10 :
**              Frontplane  pin                            : PTE2_LCD15
**              Frontplane pin signal                      : PIN11
**            Frontplane pin 11 :
**              Frontplane  pin                            : PTE3_LCD16
**              Frontplane pin signal                      : PIN12
**            Frontplane pin 12 :
**              Frontplane  pin                            : PTE4_LCD17
**              Frontplane pin signal                      : PIN13
**            Frontplane pin 13 :
**              Frontplane  pin                            : PTE5_LCD18
**              Frontplane pin signal                      : PIN14
**            Frontplane pin 14 :
**              Frontplane  pin                            : PTE6_LCD19
**              Frontplane pin signal                      : PIN15
**            Frontplane pin 15 :
**              Frontplane  pin                            : PTE7_LCD20
**              Frontplane pin signal                      : PIN16
**            Frontplane pin 16 :
**              Frontplane  pin                            : LCD21
**              Frontplane pin signal                      : PIN17
**            Frontplane pin 17 :
**              Frontplane  pin                            : LCD22
**              Frontplane pin signal                      : PIN18
**            Frontplane pin 18 :
**              Frontplane  pin                            : LCD23
**              Frontplane pin signal                      : PIN19
**            Frontplane pin 19 :
**              Frontplane  pin                            : LCD24
**              Frontplane pin signal                      : PIN20
**            Frontplane pin 20 :
**              Frontplane  pin                            : LCD25
**              Frontplane pin signal                      : PIN21
**            Frontplane pin 21 :
**              Frontplane  pin                            : LCD26
**              Frontplane pin signal                      : PIN22
**            Frontplane pin 22 :
**              Frontplane  pin                            : LCD27
**              Frontplane pin signal                      : PIN23
**            Frontplane pin 23 :
**              Frontplane  pin                            : LCD28
**              Frontplane pin signal                      : PIN24
**            Frontplane pin 24 :
**              Frontplane  pin                            : LCD29
**              Frontplane pin signal                      : PIN25
**            Frontplane pin 25 :
**              Frontplane  pin                            : LCD30
**              Frontplane pin signal                      : PIN26
**            Frontplane pin 26 :
**              Frontplane  pin                            : LCD38
**              Frontplane pin signal                      : PIN27
**            Frontplane pin 27 :
**              Frontplane  pin                            : LCD39
**              Frontplane pin signal                      : PIN28
**            Backplane pin 0 :
**              Backplane pin                              : LCD40
**              Backplane pin signal                       : 
**            Backplane pin 1 :
**              Backplane pin                              : LCD41
**              Backplane pin signal                       : 
**            Backplane pin 2 :
**            Backplane pin 3 :
**            Backplane pin 4 :
**            Backplane pin 5 :
**            Backplane pin 6 :
**            Backplane pin 7 :
**          Interrupts                                     : 
**            Interrupt                                    : Vlcd
**            LCD Interrupt                                : Disabled
**            ISR name                                     : 
**          Initialization                                 : 
**            Enable LCD module                            : Enabled
**     Contents  :
**         Init - void LCD1_Init(void);
**
**     Copyright : 1997 - 2009 Freescale Semiconductor, Inc. All Rights Reserved.
**     
**     http      : www.freescale.com
**     mail      : support@freescale.com
** ###################################################################*/

/* MODULE LCD1. */

#include "LCD1.h"

/*
** ===================================================================
**     Method      :  LCD1_Init ( Init_LCD)
**
**     Description :
**         This method initializes registers of the LCD module
**         according to this Peripheral Initialization Bean settings.
**         Call this method in the user code to initialize the
**         module. By default, the method is called by PE
**         automatically; see "Call Init method" property of the
**         bean for more details.
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
void LCD1_Init(void)
{
  /* LCDC0: SOURCE=0 */
  clrReg8Bits(LCDC0, 0x40);             
  /* LCDRVC: RVEN=1,??=0,??=0,??=0,RVTRIM3=0,RVTRIM2=0,RVTRIM1=0,RVTRIM0=0 */
  setReg8(LCDRVC, 0x80);                
  /* LCDSUPPLY: CPSEL=1,HREFSEL=0,LADJ1=1,LADJ0=1,??=0,BBYPASS=0,VSUPPLY1=1,VSUPPLY0=1 */
  setReg8(LCDSUPPLY, 0xB3);             
  /* LCDC1: LCDIEN=0,??=0,??=0,??=0,??=0,FCDEN=0,LCDWAI=0,LCDSTP=0 */
  setReg8(LCDC1, 0x00);                 
  /* LCDC0: LCDEN=0,SOURCE=0,LCLK2=1,LCLK1=0,LCLK0=0,DUTY2=0,DUTY1=0,DUTY0=1 */
  setReg8(LCDC0, 0x21);                 
  /* LCDBCTL: BLINK=0,ALT=0,BLANK=0,??=0,BMODE=1,BRATE2=1,BRATE1=0,BRATE0=0 */
  setReg8(LCDBCTL, 0x0C);               
  /* LCDPEN0: PEN7=1,PEN6=1,PEN5=1,PEN4=1,PEN3=1,PEN2=1,PEN1=1,PEN0=1 */
  setReg8(LCDPEN0, 0xFF);               
  /* LCDBPEN0: BPEN7=0,BPEN6=0,BPEN5=0,BPEN4=0,BPEN3=0,BPEN2=0,BPEN1=0,BPEN0=0 */
  setReg8(LCDBPEN0, 0x00);              
  /* LCDPEN1: PEN15=1,PEN14=1,PEN13=1,PEN12=0,PEN11=0,PEN10=0,PEN9=0,PEN8=0 */
  setReg8(LCDPEN1, 0xE0);               
  /* LCDBPEN1: BPEN15=0,BPEN14=0,BPEN13=0,BPEN12=0,BPEN11=0,BPEN10=0,BPEN9=0,BPEN8=0 */
  setReg8(LCDBPEN1, 0x00);              
  /* LCDPEN2: PEN23=1,PEN22=1,PEN21=1,PEN20=1,PEN19=1,PEN18=1,PEN17=1,PEN16=1 */
  setReg8(LCDPEN2, 0xFF);               
  /* LCDBPEN2: BPEN23=0,BPEN22=0,BPEN21=0,BPEN20=0,BPEN19=0,BPEN18=0,BPEN17=0,BPEN16=0 */
  setReg8(LCDBPEN2, 0x00);              
  /* LCDPEN3: PEN31=0,PEN30=1,PEN29=1,PEN28=1,PEN27=1,PEN26=1,PEN25=1,PEN24=1 */
  setReg8(LCDPEN3, 0x7F);               
  /* LCDBPEN3: BPEN31=0,BPEN30=0,BPEN29=0,BPEN28=0,BPEN27=0,BPEN26=0,BPEN25=0,BPEN24=0 */
  setReg8(LCDBPEN3, 0x00);              
  /* LCDPEN4: PEN39=1,PEN38=1,PEN37=0,PEN36=0,PEN35=0,PEN34=0,PEN33=0,PEN32=0 */
  setReg8(LCDPEN4, 0xC0);               
  /* LCDBPEN4: BPEN39=0,BPEN38=0,BPEN37=0,BPEN36=0,BPEN35=0,BPEN34=0,BPEN33=0,BPEN32=0 */
  setReg8(LCDBPEN4, 0x00);              
  /* LCDPEN5: ??=0,??=0,??=0,??=0,PEN43=0,PEN42=0,PEN41=1,PEN40=1 */
  setReg8(LCDPEN5, 0x03);               
  /* LCDBPEN5: ??=0,??=0,??=0,??=0,BPEN43=0,BPEN42=0,BPEN41=1,BPEN40=1 */
  setReg8(LCDBPEN5, 0x03);              
  /* LCDWF40: BPHLCD40=0,BPGLCD40=0,BPFLCD40=0,BPELCD40=0,BPDLCD40=0,BPCLCD40=0,BPBLCD40=0,BPALCD40=1 */
  setReg8(LCDWF40, 0x01);               
  /* LCDWF41: BPHLCD41=0,BPGLCD41=0,BPFLCD41=0,BPELCD41=0,BPDLCD41=0,BPCLCD41=0,BPBLCD41=1,BPALCD41=0 */
  setReg8(LCDWF41, 0x02);               
  /* LCDS: LCDIF=1,??=0,??=0,??=0,??=0,??=0,??=0,??=0 */
  setReg8(LCDS, 0x80);                  
  /* LCDC0: LCDEN=1 */
  setReg8Bits(LCDC0, 0x80);             
}

/* END LCD1. */

/*
** ###################################################################
**
**     This file was created by Processor Expert 3.06 [04.26]
**     for the Freescale HCS08 series of microcontrollers.
**
** ###################################################################
*/
