#ifndef __S08_TPM__

  #define __S08_TPM__

  #include "Derivative.h"
  #include "FslTypes.h"
    
    
    typedef enum
    {
      TPM1 = 1,
      TPM2
    }_AVAILABLE_TPMS_ENUM_;
    
    typedef enum
    {
      TPM_CHANNEL0,
      TPM_CHANNEL1
    }_TPM_CHANNELS_;
    
    typedef enum
    {
      TPM1_CHAN0_INTERRUPT,
      TPM1_CHAN1_INTERRUPT,
      TPM2_CHAN0_INTERRUPT,
      TPM2_CHAN1_INTERRUPT,
      TPM1_OVF_INTERRUPT,
      TPM2_OVF_INTERRUPT
    }_TPM_STATUS_FLAGS_;
    
    
    #define TPM1Address   &TPM1SC
    #define TPM2Address   &TPM2SC
    
    #define TPM_BUS_CLOCK       TPM1SC_CLKSA_MASK
    #define TPM_FIXED_CLOCK     TPM1SC_CLKSB_MASK
    #define TPM_EXT_CLOCK       TPM1SC_CLKSA_MASK | TPM1SC_CLKSB_MASK
    
    #define TPM_PRESCALER_1     0
    #define TPM_PRESCALER_2     TPM1SC_PS0_MASK
    #define TPM_PRESCALER_4     TPM1SC_PS1_MASK
    #define TPM_PRESCALER_8     TPM1SC_PS1_MASK | TPM1SC_PS0_MASK
    #define TPM_PRESCALER_16    TPM1SC_PS2_MASK
    #define TPM_PRESCALER_32    TPM1SC_PS2_MASK | TPM1SC_PS0_MASK
    #define TPM_PRESCALER_64    TPM1SC_PS2_MASK | TPM1SC_PS1_MASK
    #define TPM_PRESCALER_128   TPM1SC_PS2_MASK | TPM1SC_PS1_MASK | TPM1SC_PS0_MASK
    
    #define TPM_OVF_INTERRUPT   TPM1SC_TOIE_MASK
    
    #define INPUT_CAPTURE_RISING_EDGE    TPM1C0SC_ELS0A_MASK
    #define INPUT_CAPTURE_FALLING_EDGE   TPM1C0SC_ELS0B_MASK
    #define INPUT_CAPTURE_BOTH_EDGES     TPM1C0SC_ELS0A_MASK | TPM1C0SC_ELS0B_MASK
    
    #define SW_COMPARE                   TPM1C0SC_MS0A_MASK
    #define TOGGLE_ON_COMPARE            TPM1C0SC_MS0A_MASK | TPM1C0SC_ELS0A_MASK
    #define CLEAR_ON_COMPARE             TPM1C0SC_MS0A_MASK | TPM1C0SC_ELS0B_MASK
    #define SET_ON_COMPARE               TPM1C0SC_MS0A_MASK | TPM1C0SC_ELS0A_MASK | TPM1C0SC_ELS0B_MASK
    
    #define TPM_CHANNEL_INTERRUPT        TPM1C0SC_CH0IE_MASK
    
                                                       
    #define TIMER_INIT(TPMNum, Config)                  TPM##TPMNum##SC = Config
    #define TIMER_CHANNEL_INIT(TPMNum, TPMChan, Config) TPM##TPMNum##C##TPMChan##SC = Config     
    
    #define SET_TIMER_PERIOD(TPM, Period)               TPM##TPM##MOD = (UINT16)Period
                                                
    #define SET_DUTY_CYCLE(TPM, TPMChannel, DutyCycle)  TPM##TPM##C##TPMChannel##V = (UINT16)DutyCycle
    
    #define GET_INPUTCAPTURE(TPM, TPMChannel)           TPM##TPM##C##TPMChannel##V 
    
    extern UINT8 gu8TPM_Status;
    
#endif  