#ifndef __S08_TOD_Driver__

  #define __S08_TOD_Driver__
  
  #include "Derivative.h"
  #include "FslTypes.h"
  
  /* Oscillator Definitions */
  #define _TOD_LPO_OSCILLATOR_  0b00110000
  #define _TOD_32_768KHZ_XTAL_  0b00010001
  #define _TOD_INTERNAL_REF_    0b01010011
  #define _TOD_32KHZ_XTAL_      0b00010010
  #define _TOD_4_9152MHZ_XTAL_  0b00010100
  #define _TOD_4MHZ_XTAL_       0b00010101
  #define _TOD_8MHZ_XTAL_       0b00010110
  #define _TOD_16MHZ_XTAL_      0b00010111  
  
  /* Status Flags Definitions */
  typedef enum
  {
    TOD_QSECONDS,
    TOD_SECONDS,
    TOD_MATCH    
  };
  
  /* Match Conditions */
  #define TOD_MATCH_5_SEC           20
  #define TOD_MATCH_10_SEC          40
  #define TOD_MATCH_15_SEC          60
  #define TOD_MATCH_30_SEC          120
  #define TOD_MATCH_45_SEC          180
  #define TOD_MATCH_60_SEC          240
  
  #define TOD_QSECONDS_EVENT()   (gu8TOD_Status & (1<<TOD_QSECONDS))
  #define TOD_SECONDS_EVENT()    (gu8TOD_Status & (1<<TOD_SECONDS))
  #define TOD_MATCH_EVENT()      (gu8TOD_Status & (1<<TOD_MATCH))
  
  #define CLEAR_QSECONDS_EVENT() gu8TOD_Status &= ~(1<<TOD_QSECONDS)
  #define CLEAR_SECONDS_EVENT()  gu8TOD_Status &= ~(1<<TOD_SECONDS)
  #define CLEAR_MATCH_EVENT()    gu8TOD_Status &= ~(1<<TOD_MATCH)
  
  
  
  /* Public Function Prototypes */
  void vfnTOD_Init(UINT8 TOD_ClockSource, UINT8 DesiredInterrupts, UINT8 MatchValue);
  
  /* Public Variables */
  extern UINT8 gu8TOD_Status;
  
#endif