#include "LCD_GD4935.h"

byte bLCD_CharPosition;
volatile byte bflgLCD_Scroll = 0x01;

byte *bpaPlace [ ] =
{
          &Char1a,  &Char1b,
          &Char2a,  &Char2b,
          &Char3a,  &Char3b,
          &Char4a,  &Char4b,
          &Char5a,  &Char5b,
          &Char6a,  &Char6b,
          &Char7a,  &Char7b,
          &Char8a,  &Char8b,
          &Char9a,  &Char9b,
};

const byte baAscii [ ] =
{
          _0a, _0b, 
          _1a, _1b, 
          _2a ,_2b, 
          _3a, _3b, 
          _4a, _4b, 
          _5a ,_5b,
          _6a ,_6b, 
          _7a, _7b, 
          _8a, _8b, 
          _9a, _9b,
          _a2Points,_b2Points,                                             //  :
          _aSemicolon, _bSemicolon,                                  //  ;
          _aMinusThat, _bMinusThat,                                  //  <
          _aEqual, _bEqual,                                                  //  =
          _aMajorThat,_bMajorThat,                                   //   > 
          _aQuestion,_bQuestion,                                      //  ? 
          _aDegrees,_bDegrees,                                        //   
          _Aa, _Ab,  
          _Ba, _Bb, 
          _Ca, _Cb, 
          _Da, _Db,
          _Ea, _Eb,  		
          _Fa, _Fb,     
          _Ga,_Gb,    
          _Ha, _Hb,  
          _Ia,  _Ib, 	
          _Ja, _Jb,   	
          _Ka, _Kb,
          _La, _Lb,  	 
          _Ma, _Mb,  	
          _Na, _Nb,   	
          _Oa, _Ob,  
          _Pa,  _Pb,  
          _Qa,_Qb,   
          _Ra, _Rb,  
          _Sa, _Sb,  
          _Ta, _Tb,  	
          _Ua, _Ub,  	
          _Va, _Vb,  	
          _Wa, _Wb,  
          _Xa, _Xb,  	
          _Ya, _Yb,  	
          _Za, _Zb,  	
          /*[ */ 0x00,0xA3, 
          /*\ */ 0x40,0x04, 	
          /*] */ 0x93,0x00, 
          /*^ */ 0x00,0x00,	
          /*_ */ 0x80,0x80,       
} ;



void vfnLCD_Init  (void)
{
	PTADD = 0x30;
  PTDDD = 0xFF;
  PTEDD =0xFF;
  PTAD = 0x00;
  PTDD = 0x0;
  PTED =0x00;
	
	LCDC0_INIT; 										// Configure  the LCD0 register   			     
	LCDSUPPLY_INIT;								         // Configure  the Voltage Supply 
	LCDRVC_INIT;										// Configure  the Regulated Voltage Control
	LCDC1_INIT;									         // Configure  the LCD1 register
	LCDBCTL_INIT; 										// Configure  the Blink Control register
  vfnEnablePins ();
  vfnLCD_ConfigureBackplanes (); 						//Enable the characterisitcs of a Backplane
	LCDEN; 											// Enable the LCD module
  }

  void vfnEnablePins (void)
  {
  	PinEnable0;
  	PinEnable1;
  	PinEnable2;
  	PinEnable3;
  }
  
  
 void vfnLCD_ConfigureBackplanes (void)
  {
          LCDBPEN0 = 0;
          LCDBPEN1 = 0;
          LCDBPEN2 = 0;
          LCDBPEN3 = 0;

          
          EnableCom1; 										//Enable the characterisitcs of a Backplane
          EnableCom2;
          EnableCom3;
          EnableCom4;
          EnableCom5;
          EnableCom6;
          EnableCom7;
          EnableCom8;
          
          SetCom1;	 										//Give to each backplane previously enbale his COM number
          SetCom2;
          SetCom3;
          SetCom4;
          SetCom5;
          SetCom6;
          SetCom7;
          SetCom8;

  
  }
  

 void vfnLCD_Home (void)
{
      bLCD_CharPosition =  0; 								//Reset the index that points to the LCD alphanumeric positions   (*bpaPlace)
}

void vfnLCD_Contrast (byte lbContrast)
{
       lbContrast &= 0x0F;									//Forced to the only values accepted 
       LCDRVC_RVTRIM   = lbContrast;							// Write the contrast value to the register on the mcu
}


 
 void  vfnLCD_Write_Msg (byte *lbpMessage, byte lbSize )
 {
            do
            {
                    vfnLCD_Write_Char (*lbpMessage);	  			   	//Send to write to one alphanumeric
                    lbpMessage ++;     								//Move on the array to write
             }while (--lbSize);
 }

void vfnLCD_Write_Char (byte lbValue)
{
          byte *lbpLCDWF;
          byte lbCounter = _LCDTYPE;
          lbValue = (lbValue-'0')*_LCDTYPE;
          
          if (bLCD_CharPosition == _LCDTYPE*_CHARNUM)
          {
            bLCD_CharPosition = 0;
          }
          
          while (lbCounter--)
          {
                    lbpLCDWF = bpaPlace[bLCD_CharPosition];   			//Search the alphanumeric to write
                    *lbpLCDWF = baAscii[lbValue];				         //Write the value to the Waveform 
                    lbValue++;									//Search the next value to write 
                    bLCD_CharPosition++;							//Search the next Waveform to write
          }

}


void vfnLCD_All_Segments_ON (void)
{
	WF8_ON;	        										//Turn on all the segments
	WF9_ON;	
	WF10_ON;
	WF11_ON;
	WF12_ON;
	WF13_ON;
	WF14_ON;
	WF15_ON;
	WF31_ON;
	WF30_ON;
	WF29_ON;
	WF28_ON;
	WF27_ON;
	WF26_ON;
	WF25_ON;
	WF24_ON;
	WF23_ON;
	WF22_ON;
	WF21_ON;
	WF20_ON;
	WF19_ON;
	WF18_ON;
	WF17_ON;
	WF16_ON;
}

void vfnLCD_All_Segments_OFF (void)
{
	WF8_OFF;	        										//Turn on all the segments
	WF9_OFF;	
	WF10_OFF;
	WF11_OFF;
	WF12_OFF;
	WF13_OFF;
	WF14_OFF;
	WF15_OFF;
	WF31_OFF;
	WF30_OFF;
	WF29_OFF;
	WF28_OFF;
	WF27_OFF;
	WF26_OFF;
	WF25_OFF;
	WF24_OFF;
	WF23_OFF;
	WF22_OFF;
	WF21_OFF;
	WF20_OFF;
	WF19_OFF;
	WF18_OFF;
	WF17_OFF;
	WF16_OFF;
}


