#include "Calendar.h"

const UINT8 DaysPerMonth[12] = {31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};

/* Disable Message that String is not Zero Terminated */
#pragma MESSAGE DISABLE C3401
const UINT8 MonthsNames[12][3]=
{
  "JAN",
  "FEB",
  "MAR",
  "APR",
  "MAY",
  "JUN",
  "JUL",
  "AUG",
  "SEP",
  "OCT",
  "NOV",
  "DEC"
};

const UINT8 DaysNames[7][2]=
{
  "SU",
  "MO",
  "TU",
  "WE",
  "TH",
  "FR",
  "SA"
};

/* Re-Enable Message that String is not Zero Terminated */
#pragma MESSAGE DEFAULT C3401

RTC_Type Calendar_RTC;

void vfnCalendar_Init(UINT8 CalendarOptions, UINT8 CalendarWakeupPeriod)
{
  /*
  vfnCalendar_SetTime(12, 0, 0);
  vfnCalendar_SetDate (8, 1, 1, _TUESDAY_);
  */
  vfnCalendar_SetTime(16, 42, 0);
  vfnCalendar_SetDate (9, 2, 1, _SUNDAY_);
    INIT_CALENDAR_COUNTER(CalendarOptions, CalendarWakeupPeriod);
  //INIT_CALENDAR_COUNTER(CALENDAR_MATCH_WAKEUPIN_5SECS);
}

void vfnCalendar_SetTime (UINT8 Hours, UINT8 Minutes, UINT8 Seconds)
{
  Calendar_RTC.Hours = Hours;
  Calendar_RTC.Minutes = Minutes;
  Calendar_RTC.Seconds = Seconds;
  
}

void vfnCalendar_SetDate (UINT8 Year, UINT8 Month, UINT8 Date, UINT8 Day)
{
  Calendar_RTC.Year = Year;
  Calendar_RTC.Month = Month;
  Calendar_RTC.Date = Date;
  Calendar_RTC.Day = Day;
  /* Enable seconds interrupt and Match Event Interrupts; the match will occur every 240 counts, meaning every minute */
}


void vfnCalendarUpdateHours(void)
{
  if (Calendar_RTC.Hours == 24)
  {
    Calendar_RTC.Hours = 0;
  }
  
  else if (Calendar_RTC.Hours > 24)
  {
    Calendar_RTC.Hours = 23;
  }
  
}

void vfnCalendarUpdateMinutes(void)
{
  if (Calendar_RTC.Minutes == 60)
  {
    Calendar_RTC.Minutes = 0;
  }
  
  else if (Calendar_RTC.Minutes > 60)
  {
    Calendar_RTC.Minutes = 59;
  }
}

void vfnCalendarUpdateDay(void)
{
  if (Calendar_RTC.Day == DAYS_OF_WEEK)
  {
    Calendar_RTC.Day = 0;
  }
  
  else if (Calendar_RTC.Day > DAYS_OF_WEEK)
  {
    Calendar_RTC.Day = 6;
  }
}

void vfnCalendarUpdateDate(void)
{
  if (Calendar_RTC.Date == (DaysPerMonth[Calendar_RTC.Month] + 1))
  {
    Calendar_RTC.Date = 1;
  }
  
  else if (Calendar_RTC.Date > (DaysPerMonth[Calendar_RTC.Month] + 1))
  {
    Calendar_RTC.Date = DaysPerMonth[Calendar_RTC.Month];
  }  
}

void vfnCalendarUpdateMonth(void)
{
  if (Calendar_RTC.Month == MONTHS_PER_YEAR)
  {
    Calendar_RTC.Month = 0;
  }
  
  else if (Calendar_RTC.Month > MONTHS_PER_YEAR)
  {
    Calendar_RTC.Month = MONTHS_PER_YEAR - 1;
  }
}

void vfnCalendarUpdateYear(void)
{
  if (Calendar_RTC.Year == 100)
  {
    Calendar_RTC.Year = 0;
  }
  
  else if (Calendar_RTC.Year > 100)
  {
    Calendar_RTC.Year = 99;
  }
}

void vfnCalendar_UpdateDateAndTime(void)
{
  if (++Calendar_RTC.Seconds >= 60)
  {
    Calendar_RTC.Seconds = 0;
    if (++Calendar_RTC.Minutes == 60)
    {
      Calendar_RTC.Minutes = 0;
      if (++Calendar_RTC.Hours == 24)
      {
        Calendar_RTC.Hours = 0;
        if (++Calendar_RTC.Day > 6)
        {
          Calendar_RTC.Day = 0;
        }
        if (++Calendar_RTC.Date > DaysPerMonth[Calendar_RTC.Month])
        {
          Calendar_RTC.Date = 1;
          if (++Calendar_RTC.Month > 11)
          {
            Calendar_RTC.Month = 0;
            Calendar_RTC.Year++;
          }
        }
      }
    }
  }
}

void vfnClalendar_Calculate_Day(void){
  
  
  
}