/*
** ###################################################################
**
**     Filename  : accelerometer.h
** 
**     Version   : 0.0
**
**     Compiler  : Metrowerks HCS08 C Compiler
**
**     Date      : 21July08
**
** ###################################################################
*/

#ifndef _accelerometer_H
#define _accelerometer_H
#define DEMOLL

// Declare 'define' constants
//#define Trim_Val  0x8B     //Part A1 trim value for 25 MHz
//#define Trim_Val  0x93     //Part B2 trim value for 25 MHz
//#define Trim_Val  0x9E     //Part 64-2 trim value for 25 MHz
//#define FTrim_Val 1        //Part 64-2 ftrim value for 25 MHz
//#define Trim_Val  0xAD     //Part 64-2 trim value for 24 MHz
#define FTrim_Val 0        //Part 64-2 ftrim value for 24 MHz

#define max    0x10         //Max number of samples to average/filter
#define dis_base   base16

typedef struct  {
  dword  reading[max];
  dword  result[max];
} ResultStct;

#define ON  1
#define OFF 0
#ifdef DEMOLL
#define SW1 PTAD_PTAD6
#define SW2 PTAD_PTAD7
#define SW3 PTAD_PTAD4
#define SW4 PTCD_PTCD7
#define KBI_SW KBIPE_KBIPE6_MASK | KBIPE_KBIPE7_MASK  | KBIPE_KBIPE4_MASK
#define KBI_VAL ((PTAD&0xD0))>>4

#define LED_PORT PTCD
#define LED_DD PTCDD
#define LED1 PTCD_PTCD2
#define LED2 PTCD_PTCD3
#define LED3 PTCD_PTCD4
#define LED4 PTCD_PTCD5
#define LED_ON 0
#define LED_OFF 1

#endif

 
 

#define Enter_Stop3 asm(jsr RamStop)
#define Enter_Wait asm(wait)
#define Breakpoint asm(bgnd)


#define ICSC1_FEI 0x04
#define ICSC2_FEI 0x06
#define ICSSC_FEI 0x00 | FTrim_Val
#define FEI_Speed 8000000
#define hi_baud 19200
#define fei_baud FEI_Speed/16/hi_baud

#define ICSC1_FEE 0x02
#define ICSC2_FEE 0x07
#define ICSSC_FEE 0x30
#define FEE_Speed 10000000
#define hi_baud 19200
#define fee_baud FEE_Speed/16/hi_baud

#define SCGC1_gates_on  0x81;
#define SCGC2_gates_on  0x30;
#define SCGC1_gates_off 0xFF;
#define SCGC2_gates_off 0xFF;

#define zero  0x30
#define one   0x31
#define two   0x32
#define three 0x33
#define four  0x34
#define five  0x35
#define six   0x36
#define seven 0x37
#define eight 0x38
#define nine  0x39
#define ten   0x61
#define enter 0x0D
#define space 0x20
#define EXIT  0x45
#define exit  0x65
#define yes   1
#define no    0
#define filter 0x09
#define avg    0x05
#define acc    0x0c
#define base10 1
#define base16 0

// RAM variables
#pragma DATA_SEG _DATA_ZEROPAGE
static byte samp=0,mode=0,n_str[5];
static word StartCount,StopCount;

#pragma DATA_SEG DEFAULT
static ResultStct x;
static ResultStct y;
static ResultStct z;

void SendChar(char s_char);

#endif  //end #ifndef _accelerometer_H
