/******************************************************************************		
*                                                                                   	
*       Copyright (C) 2008 Freescale Semiconductor, Inc.                            	
*       All Rights Reserved								              				
*														              					
* Filename:       ADC16.h               											
*														              					
* Description:	  16-bit ADC Header files for MC9S08LH64	        	    	   	       						
*																						
* Notes:          
*     																		
******************************************************************************/		

/******************************************************************************/

#ifndef ADC12_H        /*prevent duplicated includes*/
#define ADC12_H


/************************* Project Include Files *****************************/

/************************* Variables *****************************************/

/************************* #Defines ******************************************/

// ADCSC1
#define COCO_COMPLETE     0x80
#define COCO_NOT          0x00

#define AIEN_ON           0x40
#define AIEN_OFF          0x00

#define DIFF_SINGLE       0x00

// ADCCFG1
#define ADLPC_NORMAL      0x00
#define ADLPC_LOW         0x80

#define ADIV_1            0x00
#define ADIV_2            0x20
#define ADIV_4            0x40
#define ADIV_8            0x60

#define ADLSMP_SHORT      0x00
#define ADLSMP_LONG       0x10

#define MODE_8            0x00
#define MODE_12           0x04
#define MODE_10           0x08

#define ADICLK_BUS        0x00
#define ADICLK_BUS_2      0x01
#define ADICLK_ALTCLK     0x02
#define ADICLK_ADACK      0x03

// ADCCFG2
#define ADACKEN_DISABLED  0x00
#define ADACKEN_ENABLED   0x80

#define ADHSC_NORMAL      0x00
#define ADHSC_HISPEED     0x40

#define ADLSTS_20          0x00
#define ADLSTS_12          0x01
#define ADLSTS_6           0x02
#define ADLSTS_2           0x03

//ADCSC2
#define ADACT_INACTIVE     0x00
#define ADACT_ACTIVE       0x80

#define ADTRG_SW           0x00
#define ADTRG_HW           0x40

#define ACFE_DISABLED      0x00
#define ACFE_ENABLED       0x20

#define ACFGT_LESS         0x00
#define ACFGT_GREATER      0x10

#define ADCO_SINGLE        0x00
#define ADCO_CONTINUOUS    0x08



/************************* #Defines ******************************************/

/************************* Macros ********************************************/

/************************* Prototypes ****************************************/
void ADC_Init(unsigned char CONFIG1, unsigned char CONFIG2, unsigned char STATUS2, unsigned char STATUS3, unsigned char STATUS1);
void ADC_Config(unsigned char CONFIG1, unsigned char CONFIG2, unsigned char STATUS2, unsigned char STATUS3, unsigned char STATUS1);



#endif /* ADC12_H */