/******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2011-2012 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
***************************************************************************//*!
*
* @file main.c
*
* @author a13984
*
* @version 0.0.1
*
* @date Jul-15-2011
*
* @brief 
*       Hall-sensor Bipolar
      
  \n Copyright (c) 2011 Freescale Semiconductor
  \n Freescale Confidential Proprietary
  
  \brief        Motor control using Hall Sensors Hands on                        
  \n            The firmware was developed on CodeWarrior 10.1                                                                                       
  \n            Description: The firmware initialize 6 PWM to work in            
  \n            center-aligned modeputs in order to drive six transistors of the 
  \n            3-phase power stage. A startup                                   
  \n            routine was implemented to get out the motor from its stand still
  \n            position. Speed measurement is implmented in this Lab. This Lab  
  \n            uses two push buttons, one switch and various LEDs. The motor can
  \n            spin in clockwise and counter clockwise direction. Also can be   
  \n            stop it at any moment using the swtich (SW2). Can control speeds 
  \n            from 500 rpm to 5000 rpm. The PWM used is bipolar                
  
 \ maxon EC motor  EC32 200187 Flat motor 
                 
                  motor runs on CW as specified on data sheet of motor
                  if voltage is positive  PWM% >50%  (500 - 850)
                                                        
 Notes: The global variables and local variables declared within   
 this code are written in lowercase. The constant used in this     
 project are written in uppercase                                  
                                                                                                             

 PT60 Tower board TWRI-to-APMOTOR56F800 connection:
 
 1.PWM Connection:	
 PT60              APMOTOR56F800               TWRPI pin
 =============     ==================        =================
 FTM2 Channel0 --> Phase A  Q1_TOP_A         right pin14
 FTM2 Channel1 --> Phase A  Q4_BOTTOM_A      right pin15
 FTM2 Channel2 --> Phase B  Q2_TOP_B         right pin16
 FTM2 Channel3 --> Phase B  Q5_BOTTOM_B      right pin18
 FTM2 Channel4 --> Phase C  Q3_TOP_C         right pin19
 FTM2 Channel5 --> Phase C  Q6_BOTTOM_C      right pin20
 
 2. Power connection:
    PT60              APMOTOR56F800               TWRPI pin
 =============     ==================        =================
   3.3V                  pin 1                 right pin2
   GND				     pin 3                 right pin3
 
 3. Hall Connection:
    PT60              APMOTOR56F800               TWRPI pin
 =============     ==================        =================
 PTF6/ADC1        --> T0 (Hall Sensor 1)       left pin8
 PTF5/ADC2        --> T1 (Hall Sensor 2)       left pin11
 PTF4/ADC3        --> T2 (Hall Sensor 3)       left pin12                           
 
 Usage:
  1. Press SW2 on tower board to RUN/STOP motor
  2. Push  PAD1 on tower board to increase the speed or set clockwise direction
  3. Push  PAD2 on tower board to decrease the speed or set counter clockwise direction                                  
*
*******************************************************************************
*
* provide a demo for how to initialize the PT60, output messages via SCI, 
* flash operations, etc.
* NOTE:
*	printf call may occupy a lot of memory (around 1924 bytes), so please
*	consider your code size before using printf.
******************************************************************************/

#include <hidef.h> /* for EnableInterrupts macro */
#include "derivative.h" /* include peripheral declarations */
#include "common.h"
#include "ics.h"
#include "printf.h"
#include "ir.h"
#include "uart.h"

/******************************************************************************
* Local types
******************************************************************************/

/******************************************************************************
* Local function prototypes
******************************************************************************/

void GPIO_Init(void) ;

/******************************************************************************
* Local variables
******************************************************************************/

/******************************************************************************
* Global variables
******************************************************************************/

/******************************************************************************
* Local functions
******************************************************************************/
void GPIO_Init(void) 
{ 
  
/* Enable Switch as outputs*/

	PORT_PTFOE_PTFOE6 = 0;
    PORT_PTFOE_PTFOE5 = 0;
    PORT_PTFOE_PTFOE4 = 0;
    PORT_PTFIE_PTFIE6 = 1;
    PORT_PTFIE_PTFIE5 = 1;
    PORT_PTFIE_PTFIE4 = 1;  
}


unsigned int m_uiTemp;
/******************************************************************************
* Global functions
******************************************************************************/
void main(void) {
  //TXOSC_Control XOSCCtrl;
   unsigned short uiTime; 
  /* 
   * Initialize system including clocks
   */
  Sys_Init();
  GPIO_Init();
  /* Initialize user LEDs */
  LED0_Init();
  LED1_Init();
  LED2_Init();
  LED3_Init();  
  
	  LED0_Set();
	LED1_Set();
	LED2_Set();
	LED3_Set();  

  printf("Welcome to IR-echo!\n");
 
  Button_Init();

  // init IR
  IR_Init();
 
  EnableInterrupts; /* enable interrupts */
 
  for(;;) 
  {
	  IR_test();
	  uiTime ++;
	  if( uiTime > 25 )
	  {
		  uiTime = 0;
		  LED3_Toggle();
	  }
  }
}










