/*
 * ir.c
 *
 *  Created on: Sep 15, 2011
 *      Author: B37531
 */

#include "common.h"
#include "Uart.h"
#include "ir.h"
#include "pt60_tower.h"
#include "printf.h"
void FTM0CH0_Init( void )
{
	// Init FTM0 to PWM output,frequency is 38khz
	FTM0_MOD = FTM0_MOD_VALUE;
	FTM0_C0SC = 0x28;
	FTM0_C0V = FTM0_C0V_VALUE;
	FTM0_SC = 0x08; // bus clock divide by 2
}

void ACMP_Init ( void )
{
	ACMP_C1_DACVAL = 36;
	ACMP_C1 |= ACMP_C1_DACEN_MASK | ACMP_C1_DACREF_MASK;    // enable DAC
	ACMP_C0_ACPSEL = 0x03;
	ACMP_C0_ACNSEL = 0x01;
	ACMP_C2_ACIPE = 0x02;            // enable ACMP1 connect to PIN
	ACMP_CS_ACE = 1;                 // enable ACMP
}

void IR_Init( void )
{
	unsigned char dummy;
	// init SCI0
	Init_SCI0(BUS_CLK_HZ);
	
	PORT_PTBOE_PTBOE1 = 1;
	
	// init FTM0CH1 to 38k PWM out out
	FTM0CH0_Init();
	// enable ACMP
#if( ACMP_SUPPORT )
	ACMP_Init();
	SYS_SOPT2_RXDFE = 1;
	SCI0_S2_RXINV = 0;
#endif
	//
	SYS_SOPT2_TXDME = 1;
	SYS_SOPT2_RXDCE = 0;
//	
}
void IR_test( void )
{
	unsigned short uiCount;
	volatile unsigned char dummy;
	volatile unsigned char dummy1;

	uiCount = 0xffff;
	while( ( ( SCI0_S1 & SCI0_S1_RDRF_MASK) != SCI0_S1_RDRF_MASK ) &&
	       ( --uiCount ) );
	if( uiCount == 0 )
	{
		LED2_Toggle();
		return ;
	}
	dummy1 = SCI0_S1;
	dummy = SCI0_D;		
	TERMIO_PutChar1(dummy);
	LED2_Set();

}	


