/******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2011-2012 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
***************************************************************************//*!
*
* @file crc.c
*
* @author B37531
*
* @version 0.0.1
*
* @date Aug 23, 2011
*
* @brief application entry point which performs application specific tasks. 
*
*******************************************************************************
*
* provide crc driver,complete Crc configuration and generate 16bit crc or 32bit CRc
******************************************************************************/
/******************************************************************************
* Global functions
******************************************************************************/
//Type Protocol      POLYNOMIAL      32width TransI  TransO  XOR        SEED
// 0   CRC-16        0x8005          1b0     Yes     Yes     0x0000     0x0000
// 1   CRC-CCITT     0x1021          1b0     No      No      0x0000     0xFFFF
// 2   CRC-16-Modbus 0x8005          1b0     Yes     Yes     0x0000     0xFFFF
// 3   CRC-KERMIT    0x1021          1b0     Yes     Yes     0x0000     0x0000
// 4   CRC-DNP       0x3D65          1b0     Yes     Yes     0xFFFF     0x0000
// 5   CRC-CCITT     0x1021          1b0     No      No      0x0000     0x1D0F
// 6   CRC-CCITT     0x1D0F          1b0     No      No      0x0000     0x1D0F
// 7   CRC-32        0x04C11DB7      1b1     Yes     Yes     0xFFFFFFFF 0xFFFFFFFF
// When programming data values for CRC calculation, data must be provided in CRC_D3 register only. 
#include "common.h"
#include "crc.h"
/*****************************************************************************//*!
   +FUNCTION----------------------------------------------------------------
   * @function name: CRC_config_16bit
   *
   * @brief configure CRC as 16bit mode
   *        
   * @param  	   TOT   -- reverse of write
   * 			   TOTR  -- reverse of read
   * 			   FXOR  -- 0 Normal checksum output.
							1 Complement of checksum output.
   *			   Poly  -- 16bit polynomial
   *			   Seed --  16bit seeds
   *
   * @return none
   *
   * @ Pass/ Fail criteria: none
   *****************************************************************************/
void CRC_config_16bit(unsigned char TOT, unsigned char TOTR, unsigned char FXOR, unsigned short Poly, unsigned short Seed){
	CRC_CTRL_TCRC = 0;    // TCRC=0; select 16bit;
	CRC_CTRL_TOT  = TOT;
	CRC_CTRL_TOTR = TOTR;
	CRC_CTRL_FXOR = FXOR;
	CRC_P2P3      = Poly; // 16bit polynomial;
	CRC_CTRL_WAS  = 1;
	CRC_D2D3      = Seed; // 16bit seed;
	CRC_CTRL_WAS  = 0;
}
/*****************************************************************************//*!
   +FUNCTION----------------------------------------------------------------
   * @function name: CRC_config_32bit
   *
   * @brief configure CRC as 32bit mode
   *        
   * @param        TOT   -- reverse of write
   * 			   TOTR  -- reverse of read
   * 			   FXOR  -- 0 Normal checksum output.
							1 Complement of checksum output.
				   Poly_H -- High 16bit of polynomial
				   Poly_L -- Low 16bit of polynomial
				   Seed_H -- High 16bit of seeds
				   Seed_L -- Low 16bit of seeds
   *
   * @return none
   *
   * @ Pass/ Fail criteria: none
   *****************************************************************************/
void CRC_config_32bit(unsigned char TOT, unsigned char TOTR, unsigned char FXOR, unsigned short Poly_H, unsigned short Poly_L, unsigned short Seed_H, unsigned short Seed_L){
	CRC_CTRL_TCRC = 1;    // TCRC=1; select 32bit;
	CRC_CTRL_TOT  = TOT;
	CRC_CTRL_TOTR = TOTR;
	CRC_CTRL_FXOR = FXOR;
	CRC_P0P1      = Poly_H; // 32bit polynomial;
	CRC_P2P3      = Poly_L;
	CRC_CTRL_WAS  = 1;
	CRC_D0D1      = Seed_H; // 32bit seed;
	CRC_D2D3      = Seed_L;
	CRC_CTRL_WAS  = 0;
}
/*****************************************************************************//*!
   +FUNCTION----------------------------------------------------------------
   * @function name: Crc16Calculate
   *
   * @brief calculate 16bit CRC value
   *        
   * @param  *pBuff -- the data buffer calculated CRC
   *         *pBuff -- data buffer length
   *
   * @return 16bit CRC value
   *
   * @ Pass/ Fail criteria: 
   *****************************************************************************/
unsigned short Crc16Calculate( unsigned char *pBuff, unsigned short uiLength )
{
	unsigned short i;
	/* configure crc*/
	CRC_config_16bit(0,0,0,CRC_POLYNOMIAL,CRC_SEED);
	/* calculate crc value */
	for( i = 0; i < uiLength; i++ )
	{
		CRC_D3 = pBuff[i];
		asm{
			nop;
			nop;
		}
	}
	return CRC_D2D3;
}

