RESET_STACK_POINTER	    EQU   0x10001FFC

    AREA RESET, CODE

	IMPORT Write_Secure_Test_Entry
                 ; Import exceptions handlers
    IMPORT  NMI_Handler
    IMPORT  HardFault_Handler
    IMPORT  MemManage_Handler
    IMPORT  BusFault_Handler
    IMPORT  UsageFault_Handler
    IMPORT  SVC_Handler
    IMPORT  DebugMon_Handler
    IMPORT  PendSV_Handler
    IMPORT  SysTick_Handler

; Boot Exception Vectors

        ;; interrupt/exception vector table -
        ;; this MUST be mapped to location 0x00000000

RESET_SP	
	  DCD	RESET_STACK_POINTER	     ; 0 load stack pointer is first entry in table
	  DCD     reset                ; 1 Reset
    DCD  NMI_Handler
    DCD  HardFault_Handler
    DCD  MemManage_Handler
    DCD  BusFault_Handler
    DCD  UsageFault_Handler
    DCD  0xFFFFFFFF        ; Reserved
    DCD  0xFFFFFFFF        ; Reserved
    DCD  0xFFFFFFFF        ; Reserved
    DCD  0xFFFFFFFF        ; Reserved
    DCD  SVC_Handler
    DCD  DebugMon_Handler
    DCD  0xFFFFFFFF        ; Reserved
    DCD  PendSV_Handler
    DCD  SysTick_Handler

	ENTRY

reset 

    LDR r2, Reset_Address
    BX  r2
    
    ALIGN 4
                
Reset_Address      DCD     Write_Secure_Test_Entry
   END