/*
 * sgtl5000_config.c
 *
 *  Created on: Aug 31, 2018
 *      Author: nxf45772
 */


#include <sgtl5000.h>


//vddio=3.3v vdda=1.8v,not need charge chump,vddd is external

//to save power,only start a necessary part

const sgtl5000_power_config_t power={
		.anolog_power=DAC_MONO|ADC_MONO|REFTOP_POWER|VAG_POWER|DAC_POWER|HP_POWER|HP_CAPLESS_POWER|ADC_POWER|PLL_POWER|PLL_VCO_POWER,
		.digtal_power=ADC_DIG_POWER|DAC_DIG_POWER|I2S_IN_POWER|I2S_OUT_POWER,
};
// vref should be vdda/2
const sgtl5000_chip_ref_config_t chip_ref={
		.bias_ctrl=7,
		.small_pop=1,
		.vag_val=900, //mv
};
const sgtl5000_clk_config_t clk={
		.mclk=MCLK_256_FS,
		.sr=SR_48K,
};
const sgtl5000_i2s_config_t i2s={
		.i2s_dlen=I2S_DLEN_16,
		.i2s_lr_align=I2S_LRA_1,
		.i2s_lr_pol=I2S_LRPOL_L,
		.i2s_master=I2S_MASTER,
		.i2s_mode=I2S_MODE_I2S,
		.i2s_sclk_fs=I2S_SCLK_32FS,
		.i2s_slck_inv=I2S_SCLK_RE,
};
const sgtl5000_path_config_t path={
		.ana=mic_adc_dac_hp,
		.sss=adc_i2so_i2si_dac
};

sgtl5000_config_t sgtl5000_config={
		.chip_ref=(sgtl5000_chip_ref_config_t*)&chip_ref,
		.clk=(sgtl5000_clk_config_t*)&clk,
		.i2s=(sgtl5000_i2s_config_t*)&i2s,
		.path=(sgtl5000_path_config_t*)&path,
		.power=(sgtl5000_power_config_t*)&power
};





