/*
 * sgtl5000.h
 *
 *  Created on: Jun 1, 2018
 *      Author: nxf45772
 */

#ifndef SGTL5000_H_BAK_
#define SGTL5000_H_BAK_

#include "CPU.h"
#include "lpi2c1.h"

#define CHIP_ID 0x0000 //default 0xa0xx
#define CHIP_DIG_POWER 0X0002
#define CHIP_CLK_CTRL 0X0004
#define CHIP_I2S_CTRL 0X0006
#define CHIP_SSS_CTRL 0X000A
#define CHIP_ADCDAC_CTRL 0X000E
#define CHIP_DAC_VOL 0X0010
#define CHIP_PAD_STRENGTH 0X0014
#define CHIP_ANA_ADC_CTRL 0X0020
#define CHIP_ANA_HP_CTRL 0X0022
#define CHIP_ANA_CTRL 0X0024
#define CHIP_LINREG_CTRL 0X0026
#define CHIP_REF_CTRL 0X0028
#define CHIP_MIC_CTRL 0X002A
#define CHIP_LINE_OUT_CTRL 0X002C
#define CHIP_LINE_OUT_VOL 0X002E
#define CHIP_ANA_POWER 0X0030
#define CHIP_PLL_CTRL 0X0032
#define CHIP_CLK_TOP_CTRL 0X0034
#define CHIP_ANA_STATUS 0x0036
#define CHIP_ANA_TEST1 0x0038
#define CHIP_ANA_TEST2 0x003a
#define CHIP_SHORT_CTRL 0x003c
//DAP


//anolog power bit
#define DAC_MONO (1<<14)
#define LINREG_SIMPLE_POWER (1<<13)
#define STARTUP_POWER (1<<12)
#define VDDC_POWER (1<<11)
#define PLL_POWER (1<<10)
#define LINREG_D_POWER (1<<9)
#define PLL_VCO_POWER (1<<8)
#define VAG_POWER (1<<7)
#define ADC_MONO (1<<6)
#define REFTOP_POWER (1<<5)
#define HP_POWER (1<<4)
#define DAC_POWER (1<<3)
#define HP_CAPLESS_POWER (1<<2)
#define ADC_POWER (1<<1)
#define LINEOUT_POWER (1)
//digtal power bit
#define ADC_DIG_POWER (1<<6)
#define DAC_DIG_POWER (1<<5)
#define DAP_POWER (1<<4)
#define I2S_OUT_POWER (1<<1)
#define I2S_IN_POWER (1)

//sample rate

#define SR_32K 0
#define SR_44_1K (1<<2)
#define	SR_48K (2<<2)
#define	SR_96K (3<<2)


#define	MCLK_256_FS 0
#define	MCLK_384_FS 1
#define	MCLK_512_FS 2
#define MCLK_PLL 3


#define I2S_SCLK_64FS 0
#define I2S_SCLK_32FS (1<<8)
#define I2S_MASTER 0
#define I2S_SLAVE (1<<7)
#define I2S_SCLK_RE 0 //rising edge
#define I2S_SCLK_FE (1<<6)
#define I2S_DLEN_32 0
#define I2S_DLEN_23 (1<<4)
#define I2S_DLEN_20 (2<<4)
#define I2S_DLEN_16 (3<<4)
#define I2S_MODE_I2S 0
#define I2S_MODE_RJ (1<<2)
#define I2S_MODE_PCM (2<<2)
#define I2S_LRA_1 0
#define I2S_LRA_0 (1<<1)
#define I2S_LRPOL_L 0
#define I2S_LPROL_R 1



#define BIAS_RES_OFF 0
#define BIAS_RES_2K  (1<<8)
#define BIAS_RES_4K  (2<<8)
#define BIAS_RES_8K  (3<<8)

#define MUTE_LO (1<<8)
#define SELECT_HP_LINEIN (1<<6)
#define EN_ZCD_HP (1<<5)
#define MUTE_HP (1<<4)
#define SELECT_ADC_LINEIN (1<<2)
#define EN_ZCD_ADC (1<<1)
#define MUTE_ADC (1)

#define DAP_MIX_ADC (0<<8)
#define DAP_MIX_I2S_IN (1<<8)
#define DAP_ADC (0<<6)
#define DAP_I2S_IN (1<<6)
#define DAC_ADC (0<<4)
#define DAC_I2S_IN (1<<4)
#define DAC_DAP (3<<4)
#define I2S_OUT_ADC (0)
#define I2S_OUT_I2S_IN (1)
#define I2S_OUT_DAP (3)

#define I2S_32FS (1<<8)
#define I2S_16BIT (3<<4)
#define SYS_FS_32K (0<<2)
#define SYS_FS_44_1K (1<<2)
#define SYS_FS_48K (2<<2)
#define SYS_FS_96K (3<<2)



#define PLL 1
#define MCLK 12000000U
#define SAMPLE_CLK 48000U
#if PLL
#if (SAMPLE_CLK!=44100)
#define PLL_OUTPUT_CLK 196608000U
#else
#define PLL_OUTPUT_CLK 180633600U
#endif
#endif




typedef struct{
	uint16_t i2s_sclk_fs;
	uint16_t i2s_master;
	uint16_t i2s_slck_inv;
	uint16_t i2s_dlen;
	uint16_t i2s_mode;
	uint16_t i2s_lr_align;
	uint16_t i2s_lr_pol;
}sgtl5000_i2s_config_t;


typedef enum{
	linein_hp=0x66,  //playback
	linein_adc_dac_hp=0x26,//linein->adc dac->headphone
	mic_adc_dac_hp=0x22,//mic->adc dac->headphone
}sgtl5000_ana_e;
typedef enum{
	adc_i2so_i2si_dac=(3<<8)|(3<<6)|(1<<4), //adc->i2s_out,i2s_in->dac
	adc_dap_i2so_i2si_dac=(3<<8)|(1<<4)|(3),//adc->dap->i2s_out,i2s_in->dac
	adc_i2so_i2si_dap_dac=(3<<8)|(1<<6)|(3<<4),//adc->i2s_out,i2s_in->dap->dac
	adc_dac=(3<<8)|(3<<6)|(2),//playback
}sgtl5000_sss_e;

typedef struct{
	sgtl5000_ana_e ana;
	sgtl5000_sss_e sss;
}sgtl5000_path_config_t;

typedef struct{
	uint16_t digtal_power;
	uint16_t anolog_power;
}sgtl5000_power_config_t;
typedef struct{
	uint16_t vag_val;
	uint16_t bias_ctrl;
	uint16_t small_pop;
}sgtl5000_chip_ref_config_t;
typedef struct{
	uint16_t sr;
	uint16_t mclk;
}sgtl5000_clk_config_t;

typedef struct{
	sgtl5000_power_config_t* power;
	sgtl5000_chip_ref_config_t* chip_ref;
	sgtl5000_clk_config_t* clk;
	sgtl5000_i2s_config_t* i2s;
	sgtl5000_path_config_t* path;
}sgtl5000_config_t;


/*
 * 0:0db
 * 1:+20db
 * 2:+30db
 * 3:+40db
 */
status_t sgtl5000_mic_gain(uint8_t a);
status_t sgtl5000_mute_dac(bool mute);
status_t sgtl5000_dac_vol(uint8_t r_vol,uint8_t l_vol);
status_t sgtl5000_init(sgtl5000_config_t* config);
status_t sgtl5000_pll_init();

#endif /* SGTL5000_H_BAK_ */
