/* ###################################################################
**     Filename    : main.c
**     Processor   : S32K14x
**     Abstract    :
**         Main module.
**         This module contains user's application code.
**     Settings    :
**     Contents    :
**         No public methods
**
** ###################################################################*/
/*!
** @file main.c
** @version 01.00
** @brief
**         Main module.
**         This module contains user's application code.
*/
/*!
**  @addtogroup main_module main module documentation
**  @{
*/
/* MODULE main */


/* Including necessary module. Cpu.h contains other modules needed for compiling.*/
#include "Cpu.h"

  volatile int exit_code = 0;

/* User includes (#include below this line is not maintained by Processor Expert) */
#include "sgtl5000.h"
#include "sai1.h"
#include "lpi2c1.h"
#include "clockMan1.h"
#include "pin_mux.h"
#include "data.h"
#include <sgtl5000_config.h>


#define BUF_SIZE 200

#define PLAY_MUSIC  0

//int16_t right1[BUF_SIZE];
//int16_t left1[BUF_SIZE];
//int16_t* buff1[2]={right1,left1};
//int16_t right2[BUF_SIZE];
//int16_t left2[BUF_SIZE];
//int16_t* buff2[2]={right2,left2};

  int16_t slice1[BUF_SIZE];
  int16_t* buff1[2]={slice1};
  int16_t slice2[BUF_SIZE];
  int16_t* buff2[1]={slice2};



void sai_rx_callback(sai_report_type_t event, void *userData){
	static uint8_t cnt_recv;
	if(event==SAI_RX_COMPLETE){
		if(cnt_recv%2==0){
			SAI_DRV_Receive(INST_SAI1,(uint8_t**)(buff1),BUF_SIZE);
#if PLAY_MUSIC==0
			SAI_DRV_Send(INST_SAI1,(const uint8_t**)(buff2),BUF_SIZE);
#endif
		}else{
			SAI_DRV_Receive(INST_SAI1,(uint8_t**)(buff2),BUF_SIZE);
#if PLAY_MUSIC==0
			SAI_DRV_Send(INST_SAI1,(const uint8_t**)(buff1),BUF_SIZE);
#endif
		}
		cnt_recv++;
	}

}
/*!
  \brief The main function for the project.
  \details The startup initialization sequence is the following:
 * - startup asm routine
 * - main()
*/
int main(void)
{
  /* Write your local variable definition here */
	lpi2c_master_state_t lpi2c1MasterState;

  /*** Processor Expert internal initialization. DON'T REMOVE THIS CODE!!! ***/
  #ifdef PEX_RTOS_INIT
    PEX_RTOS_INIT();                   /* Initialization of the selected RTOS. Macro is defined by the RTOS component. */
  #endif
  /*** End of Processor Expert internal initialization.                    ***/

  /* Write your code here */
    CLOCK_SYS_Init(g_clockManConfigsArr, CLOCK_MANAGER_CONFIG_CNT,
    				   g_clockManCallbacksArr, CLOCK_MANAGER_CALLBACK_CNT);
    CLOCK_SYS_UpdateConfiguration(0U, CLOCK_MANAGER_POLICY_AGREEMENT);

    PINS_DRV_Init(NUM_OF_CONFIGURED_PINS, g_pin_mux_InitConfigArr);

    EDMA_DRV_Init(&dmaController1_State,&dmaController1_InitConfig0,edmaChnStateArray,edmaChnConfigArray,EDMA_CONFIGURED_CHANNELS_COUNT);
    OSIF_TimeDelay(100);

    LPI2C_DRV_MasterInit(INST_LPI2C1,&lpi2c1_MasterConfig0,&lpi2c1MasterState);


    sai1_InitConfig1.callback=sai_rx_callback;
    SAI_DRV_TxInit(INST_SAI1,&sai1_InitConfig0,&sai1TxState);
    SAI_DRV_RxInit(INST_SAI1,&sai1_InitConfig1,&sai1RxState);


    INT_SYS_EnableIRQGlobal();


    sgtl5000_init(&sgtl5000_config);
    //SAI_DRV_SendBlocking(INST_SAI1,(const uint8_t**)music,sizeof(data)/2,10000);
    SAI_DRV_Receive(INST_SAI1,(uint8_t**)(buff2),BUF_SIZE);
#if PLAY_MUSIC==1
    uint8_t* music1[1];
    uint32_t length;
    uint32_t index;
    while(1){
    	music1[0]=(uint8_t*)data;
    	index=0;
    	length=sizeof(data)/2;
    	while(length/1024){
    		SAI_DRV_SendBlocking(INST_SAI1,(const uint8_t**)music1,1024,10000);
    		index++;
    		music1[0]=(uint8_t*)((uint32_t)data+index*1024);
    		length-=1024;
    	}
    	SAI_DRV_SendBlocking(INST_SAI1,(const uint8_t**)music1,length%1024,10000);

    }
#else
    while(1);
#endif
  /* For example: for(;;) { } */

  /*** Don't write any code pass this line, or it will be deleted during code generation. ***/
  /*** RTOS startup code. Macro PEX_RTOS_START is defined by the RTOS component. DON'T MODIFY THIS CODE!!! ***/
  #ifdef PEX_RTOS_START
    PEX_RTOS_START();                  /* Startup of the selected RTOS. Macro is defined by the RTOS component. */
  #endif
  /*** End of RTOS startup code.  ***/
  /*** Processor Expert end of main routine. DON'T MODIFY THIS CODE!!! ***/
  for(;;) {
    if(exit_code != 0) {
      break;
    }
  }
  return exit_code;
  /*** Processor Expert end of main routine. DON'T WRITE CODE BELOW!!! ***/
} /*** End of main routine. DO NOT MODIFY THIS TEXT!!! ***/

/* END main */
/*!
** @}
*/
/*
** ###################################################################
**
**     This file was created by Processor Expert 10.1 [05.21]
**     for the Freescale S32K series of microcontrollers.
**
** ###################################################################
*/
