/*
 * usr7s4.h
 *
 *  Created on: Jul 10, 2018
 *      Author: nxf45772
 */

#ifndef USR7S4_H_
#define USR7S4_H_

#include "CPU.h"

typedef enum{
	USR_TCP=0U,
	USR_UDP,
}socket_type_t;

typedef enum{
	USR_CONN_SHORT=0U,
	USR_CONN_LONG,
}socket_conn_time_t;

typedef struct{
	socket_type_t type;
	socket_conn_time_t time;
	char* domain;
	uint16_t port;
	uint8_t client_num; //0~3
}socket_t;

typedef enum{
	USR_NO_NET=0U,
	USR_NET_GSM,
	USR_NET_WCDMA,
	USR_NET_TD,
	USR_NET_LTE,
	USR_NET_ERR,
}usr_net_status_t;

void usr7s4_init();
int socket(socket_t* s);
int connect(int fd);
int close(int fd);
int socket_read(int fd,char *data,int len);
int socket_write(int fd,char *data,int len);

#endif /* USR7S4_H_ */
