/*
 * serialbuf.c
 *
 *  Created on: Jul 9, 2018
 *      Author: nxf45772
 */
#include "CPU.h"
#include "ringbuf.h"

#define BUF_SIZE 256

static ringbuf_handle_t rb;

static uint8_t recv_data[BUF_SIZE];
static QueueHandle_t recv_sem;
static SemaphoreHandle_t uart_mx;
static SemaphoreHandle_t data_a_sem;

void uart_rx_callback(void *driverState, uart_event_t event, void *userData){
	BaseType_t xHigherPriorityTaskWoken=pdFALSE;
	uint32_t leftNum;
	if(event==UART_EVENT_RX_FULL||event==UART_EVENT_RX_IDLE){
		LPUART_DRV_GetReceiveStatus(INST_LPUART1,&leftNum);
		xQueueSendFromISR(recv_sem,&leftNum,&xHigherPriorityTaskWoken);
		if(event==UART_EVENT_RX_IDLE){
			LPUART_DRV_AbortReceivingData(INST_LPUART1);
		}
	}
	if(xHigherPriorityTaskWoken==pdTRUE){
		taskYIELD ();
	}
}
static void serial_recv_task(){
	uint32_t data;
	LPUART_DRV_ReceiveData(INST_LPUART1,recv_data,BUF_SIZE);
	while(1){
		xQueueReceive(recv_sem,&data,portMAX_DELAY);
		rb_write(rb,(char *)recv_data,BUF_SIZE-data,portMAX_DELAY);
		LPUART_DRV_ReceiveData(INST_LPUART1,recv_data,BUF_SIZE);
		xSemaphoreGive(data_a_sem);
	}
}
static void _low_uart_send(char* data,int len){
	xSemaphoreTake(uart_mx,portMAX_DELAY);
	LPUART_DRV_SendDataBlocking(INST_LPUART1,(const uint8_t*)data,len,portMAX_DELAY);
	xSemaphoreGive(uart_mx);
}
int serial_read(char* data,int len){
	//peak the recv_sem
	xSemaphoreTake(data_a_sem,portMAX_DELAY);
	int al=rb_bytes_filled(rb);
	if(len>al)
		len=al;
	return rb_read(rb,data,len,portMAX_DELAY);//should no block
}

int serial_send(char* data,int len){
	_low_uart_send(data,len);
	return len;
}
status_t serial_init(){
	rb=rb_create(2048,1);
	if(rb==NULL)
		return STATUS_ERROR;
	LPUART_DRV_Init(INST_LPUART1,&lpuart1_State,&lpuart1_InitConfig0);
	LPUART_DRV_InstallRxCallback(INST_LPUART1,uart_rx_callback,NULL);
	recv_sem=xQueueCreate(1,sizeof(int));
	uart_mx=xSemaphoreCreateMutex();
	data_a_sem=xSemaphoreCreateBinary();
	if(recv_sem==NULL)
		return STATUS_ERROR;
	//start receive task
	INT_SYS_SetPriority(DMA0_IRQn,4);
	INT_SYS_SetPriority(DMA1_IRQn,5);
	INT_SYS_SetPriority(LPUART2_RxTx_IRQn,5);
	xTaskCreate(serial_recv_task,"readTask",512,NULL,7,NULL);
	return STATUS_SUCCESS;
}





