/*
 * GPS_NEO_6M.c
 *
 *  Created on: Jul 2, 2018
 *      Author: nxa07657
 */

#include <GPS_NEO_6M.h>
#include "string.h"
#include "usr7s4.h"
#include "Cpu.h"
#include "lpuart2.h"
#include "task.h"
#include "lpuart3.h"
#include "cJSON.h"
#include "PCA85063A_RTC.h"
#include "MMA845x.h"



#define RX_BUFFER_SIZE		2048

static uint8_t gps_rx_buf[RX_BUFFER_SIZE];/*double buffer for ping-peng operation/receive*/
static QueueHandle_t gps_recv_sem;

static nmea_msg gpsx;

void gps_rx_callback(void *driverState, uart_event_t event, void *userData){
	BaseType_t xHigherPriorityTaskWoken=pdFALSE;
	uint32_t leftNum;
	if(event==UART_EVENT_RX_FULL||event==UART_EVENT_RX_IDLE){
		LPUART_DRV_GetReceiveStatus(INST_LPUART2,&leftNum);
		leftNum=RX_BUFFER_SIZE-leftNum;
		LPUART_DRV_AbortReceivingData(INST_LPUART2);
		xQueueSendFromISR(gps_recv_sem,&leftNum,&xHigherPriorityTaskWoken);
	}
	if(xHigherPriorityTaskWoken==pdTRUE){
		taskYIELD ();
	}
}



static uint8_t NMEA_Comma_Pos(uint8_t *buf,uint8_t cx)
{
	uint8_t *p=buf;
	while(cx)
	{
		if(*buf=='*'||*buf<' '||*buf>'z')return 0XFF;
		if(*buf==',')cx--;
		buf++;
	}
	return buf-p;
}

static uint32_t NMEA_Pow(uint8_t m,uint8_t n)
{
	uint32_t result=1;
	while(n--)result*=m;
	return result;
}

static int NMEA_Str2num(uint8_t *buf,uint8_t*dx)
{
	uint8_t *p=buf;
	uint32_t ires=0,fres=0;
	uint8_t ilen=0,flen=0,i;
	uint8_t mask=0;
	int res;
	while(1)
	{
		if(*p=='-'){mask|=0X02;p++;}
		if(*p==','||(*p=='*'))break;
		if(*p=='.'){mask|=0X01;p++;}
		else if(*p>'9'||(*p<'0'))
		{
			ilen=0;
			flen=0;
			break;
		}
		if(mask&0X01)flen++;
		else ilen++;
		p++;
	}
	if(mask&0X02)buf++;
	for(i=0;i<ilen;i++)
	{
		ires+=NMEA_Pow(10,ilen-1-i)*(buf[i]-'0');
	}
	if(flen>5)flen=5;
	*dx=flen;
	for(i=0;i<flen;i++)
	{
		fres+=NMEA_Pow(10,flen-1-i)*(buf[ilen+1+i]-'0');
	}
	res=ires*NMEA_Pow(10,flen)+fres;
	if(mask&0X02)res=-res;
	return res;
}

//GPRMC
static void NMEA_GPRMC_Analysis(nmea_msg *gpsx,uint8_t *buf)
{
	uint8_t *p1,dx;
	uint8_t posx;
	uint32_t temp;
	float rs;
	p1=(uint8_t*)strstr((const char *)buf,"GPRMC");
	posx=NMEA_Comma_Pos(p1,1);
	if(posx!=0XFF)
	{
		temp=NMEA_Str2num(p1+posx,&dx)/NMEA_Pow(10,dx);
		gpsx->utc.hour=temp/10000;
		gpsx->utc.min=(temp/100)%100;
		gpsx->utc.sec=temp%100;
	}
	posx=NMEA_Comma_Pos(p1,3);
	if(posx!=0XFF)
	{
		temp=NMEA_Str2num(p1+posx,&dx);
		gpsx->latitude=temp/NMEA_Pow(10,dx+2);
		rs=temp%NMEA_Pow(10,dx+2);
		gpsx->latitude=gpsx->latitude*NMEA_Pow(10,5)+(rs*NMEA_Pow(10,5-dx))/60;
	}
	posx=NMEA_Comma_Pos(p1,4);
	if(posx!=0XFF)gpsx->nshemi=*(p1+posx);
 	posx=NMEA_Comma_Pos(p1,5);
	if(posx!=0XFF)
	{
		temp=NMEA_Str2num(p1+posx,&dx);
		gpsx->longitude=temp/NMEA_Pow(10,dx+2);
		rs=temp%NMEA_Pow(10,dx+2);
		gpsx->longitude=gpsx->longitude*NMEA_Pow(10,5)+(rs*NMEA_Pow(10,5-dx))/60;
	}
	posx=NMEA_Comma_Pos(p1,6);
	if(posx!=0XFF)gpsx->ewhemi=*(p1+posx);
	posx=NMEA_Comma_Pos(p1,9);
	if(posx!=0XFF)
	{
		temp=NMEA_Str2num(p1+posx,&dx);
		gpsx->utc.date=temp/10000;
		gpsx->utc.month=(temp/100)%100;
		gpsx->utc.year=2000+temp%100;
	}

}

//GPGSV
static void NMEA_GPGSV_Analysis(nmea_msg *gpsx,uint8_t *buf)
{
	uint8_t *p,*p1,dx;
	uint8_t len,i,j,slx=0;
	uint8_t posx;
	p=buf;
	p1=(uint8_t*)strstr((const char *)p,"$GPGSV");
	len=p1[7]-'0';
	posx=NMEA_Comma_Pos(p1,3);
	if(posx!=0XFF)gpsx->svnum=NMEA_Str2num(p1+posx,&dx);
	for(i=0;i<len;i++)
	{
		p1=(uint8_t*)strstr((const char *)p,"$GPGSV");
		for(j=0;j<4;j++)
		{
			posx=NMEA_Comma_Pos(p1,4+j*4);
			if(posx!=0XFF)gpsx->slmsg[slx].num=NMEA_Str2num(p1+posx,&dx);
			else break;
			posx=NMEA_Comma_Pos(p1,5+j*4);
			if(posx!=0XFF)gpsx->slmsg[slx].eledeg=NMEA_Str2num(p1+posx,&dx);
			else break;
			posx=NMEA_Comma_Pos(p1,6+j*4);
			if(posx!=0XFF)gpsx->slmsg[slx].azideg=NMEA_Str2num(p1+posx,&dx);
			else break;
			posx=NMEA_Comma_Pos(p1,7+j*4);
			if(posx!=0XFF)gpsx->slmsg[slx].sn=NMEA_Str2num(p1+posx,&dx);
			else break;
			slx++;
		}
 		p=p1+1;
	}
}


//GPGGA
static void NMEA_GPGGA_Analysis(nmea_msg *gpsx,uint8_t *buf)
{
	uint8_t *p1,dx;
	uint8_t posx;
	p1=(uint8_t*)strstr((const char *)buf,"$GPGGA");
	posx=NMEA_Comma_Pos(p1,6);
	if(posx!=0XFF)gpsx->gpssta=NMEA_Str2num(p1+posx,&dx);
	posx=NMEA_Comma_Pos(p1,7);
	if(posx!=0XFF)gpsx->posslnum=NMEA_Str2num(p1+posx,&dx);
	posx=NMEA_Comma_Pos(p1,9);
	if(posx!=0XFF)gpsx->altitude=NMEA_Str2num(p1+posx,&dx);
}

//GPGSA
static void NMEA_GPGSA_Analysis(nmea_msg *gpsx,uint8_t *buf)
{
	uint8_t *p1,dx;
	uint8_t posx;
	uint8_t i;
	p1=(uint8_t*)strstr((const char *)buf,"$GPGSA");
	posx=NMEA_Comma_Pos(p1,2);
	if(posx!=0XFF)gpsx->fixmode=NMEA_Str2num(p1+posx,&dx);
	for(i=0;i<12;i++)
	{
		posx=NMEA_Comma_Pos(p1,3+i);
		if(posx!=0XFF)gpsx->possl[i]=NMEA_Str2num(p1+posx,&dx);
		else break;
	}
	posx=NMEA_Comma_Pos(p1,15);
	if(posx!=0XFF)gpsx->pdop=NMEA_Str2num(p1+posx,&dx);
	posx=NMEA_Comma_Pos(p1,16);
	if(posx!=0XFF)gpsx->hdop=NMEA_Str2num(p1+posx,&dx);
	posx=NMEA_Comma_Pos(p1,17);
	if(posx!=0XFF)gpsx->vdop=NMEA_Str2num(p1+posx,&dx);
}

//GPVTG
static void NMEA_GPVTG_Analysis(nmea_msg *gpsx,uint8_t *buf)
{
	uint8_t *p1,dx;
	uint8_t posx;
	p1=(uint8_t*)strstr((const char *)buf,"$GPVTG");
	posx=NMEA_Comma_Pos(p1,7);
	if(posx!=0XFF)
	{
		gpsx->speed=NMEA_Str2num(p1+posx,&dx);
		if(dx<3)gpsx->speed*=NMEA_Pow(10,3-dx);
	}
}

#if 0
void Send_NMEA_GPRMC(nmea_msg *gpsx)
{
	printf("year:%d ", gpsx->utc.year);
	printf("month:%d ", gpsx->utc.month);
	printf("date:%d ", gpsx->utc.date);
	printf("hour:%d ", (gpsx->utc.hour+8)%24);
	printf("min:%d ", gpsx->utc.min);
	printf("sec:%d ", gpsx->utc.sec);

	printf("%c latit:", gpsx->nshemi);
	printf("%f ", (float)gpsx->latitude/100000);

	printf("%c longi:", gpsx->ewhemi);
	printf("%f\r\n", (float)gpsx->longitude/100000);
}

void Send_NMEA_GPGSV(nmea_msg *gpsx)
{
	int i, j = gpsx->svnum;
	printf("satellites in view%d \r\n", gpsx->svnum);
	printf("satellite number  elevation in degrees    azimuth in degrees to true   SNR in dB\r\n");
	for (i = 0; i < j; i++)
	{
		printf("%d\t\t\t",gpsx->slmsg[i].num);
		printf("%d\t\t\t",gpsx->slmsg[i].eledeg);
		printf("%d\t\t\t",gpsx->slmsg[i].azideg);
		printf("%d",gpsx->slmsg[i].sn);
		printf("\r\n");
	}
}

void Send_NMEA_GPGGA(nmea_msg *gpsx)
{
	printf("GPS quality indicator: %d    Number of satellites in view: %d    high:%.3f\r\n", \
		gpsx->gpssta, gpsx->posslnum, (float)gpsx->altitude/10);
}

void Send_NMEA_GPGSA(nmea_msg *gpsx)
{
	int i;
	printf("mode: %d\tPDOP: %.3f\tHDOP:%.3f\tVDOP:%.3f", \
		gpsx->fixmode, (float)gpsx->pdop/100, (float)gpsx->hdop/100, (float)gpsx->vdop/100);
	printf("\r\nNO:");
	for (i = 0 ; i < gpsx->posslnum; i++)
	{
		printf("%d ",gpsx->possl[i]);
	}
	printf("\r\n");
}

void Send_NMEA_GPVTG(nmea_msg *gpsx)
{
	printf("speed: %f\r\n\r\n", (float)gpsx->speed/1000);
}

#endif

void GPSMSG_Analysis(nmea_msg *gpsx, uint8_t *buf)
{
	NMEA_GPRMC_Analysis(gpsx,buf);
	NMEA_GPGSV_Analysis(gpsx,buf);
	NMEA_GPGGA_Analysis(gpsx,buf);
	NMEA_GPGSA_Analysis(gpsx,buf);
	NMEA_GPVTG_Analysis(gpsx,buf);
}

#if 0
void Send_NMEA_MSG(nmea_msg *gpsx)
{
	Send_NMEA_GPRMC(gpsx);
	Send_NMEA_GPGSV(gpsx);
	Send_NMEA_GPGGA(gpsx);
	Send_NMEA_GPGSA(gpsx);
	Send_NMEA_GPVTG(gpsx);
}
#endif
static void gps_handle_task(){
	LPUART_DRV_ReceiveData(INST_LPUART2,gps_rx_buf,RX_BUFFER_SIZE);
	int len;

	while(1)
	{
		xQueueReceive(gps_recv_sem,&len,portMAX_DELAY);
		uint8_t* raw=pvPortMalloc(len+1);
		if(raw==NULL)
			continue;
		memcpy((char*)raw,gps_rx_buf,len);
		LPUART_DRV_ReceiveData(INST_LPUART2,gps_rx_buf,RX_BUFFER_SIZE);
		raw[len]=0;
		GPSMSG_Analysis(&gpsx,raw);
		vPortFree(raw);
		//LPUART_DRV_SendDataBlocking(INST_LPUART3,(const uint8_t *)raw,len,1000);

	}
}
status_t gps_init()
{
	LPUART_DRV_Init(INST_LPUART2,&lpuart2_State,&lpuart2_InitConfig0);
	LPUART_DRV_InstallRxCallback(INST_LPUART2,gps_rx_callback,NULL);

	gps_recv_sem=xQueueCreate(1,sizeof(int));
	if(gps_recv_sem==NULL)
		return STATUS_ERROR;
	//start receive task
	INT_SYS_SetPriority(DMA2_IRQn,2);
	INT_SYS_SetPriority(DMA3_IRQn,3);
	INT_SYS_SetPriority(LPUART1_RxTx_IRQn,4);
	xTaskCreate(gps_handle_task,"gpsTask",512,NULL,7,NULL);
	return STATUS_SUCCESS;
}
void gps_get_ll(float *logitude,float *latitude){
	*logitude=gpsx.longitude/100000.0;
	*latitude=gpsx.latitude/100000.0;
}
