/*
 * UART_BSP_Test.c
 *
 *  Created on: Sep 28, 2018
 *      Author: nxa07657
 */

/*
 * include the BSP and test configuration header
 */
#include "S32K148_TBOX_BSP.h"
#include "S32K148_TBOX_BSP_test_Config.h"

uint8_t UART0_txBuff[100] = "This is UART0 sending data = 0\n";
uint8_t UART1_txBuff[100] = "This is UART1 sending data = 0\n";
uint8_t UART2_txBuff[100] = "This is UART2 sending data = 0\n";

uint8_t UART0_rxBuff[100];
uint8_t UART1_rxBuff[100];
uint8_t UART2_rxBuff[100];


 uint32_t bytesRemaining = 0;

 void UART_BSP_Init(void)
 {
     /*
      * initialize UART0/1/2 for BLE, GPS and 4G module communication
      */
     UART_Init(&uart_pal1_instance, &uart_pal1_Config0);

     UART_Init(&uart_pal2_instance, &uart_pal2_Config0);

     UART_Init(&uart_pal3_instance, &uart_pal3_Config0);
 }

 void UART_BSP_Test(void)
 {

#ifdef UART1_test
	  /*
	   * UART0 TX/RX test
	   */
	  while(STATUS_SUCCESS!=UART_GetTransmitStatus(&uart_pal1_instance,&bytesRemaining));/*check and confirm the TX has completed*/
	  UART_SendData(&uart_pal1_instance, UART0_txBuff, 31);/*send string info via UART0*/

	  UART_ReceiveData(&uart_pal1_instance,UART0_rxBuff, 10);/*receive data via UART0*/
	  while(STATUS_SUCCESS!=UART_GetReceiveStatus(&uart_pal1_instance,&bytesRemaining));/*wait for RX complete*/

#endif

#ifdef UART2_test
	  /*
	   * UART1 TX/RX test
	   */

	  while(STATUS_SUCCESS!=UART_GetTransmitStatus(&uart_pal2_instance,&bytesRemaining));/*check and confirm the TX has completed*/
	  UART_SendData(&uart_pal2_instance, UART1_txBuff, 31);/*send string info via UART0*/

	  UART_ReceiveData(&uart_pal2_instance,UART1_rxBuff, 10);/*receive data via UART0*/
	  while(STATUS_SUCCESS!=UART_GetReceiveStatus(&uart_pal2_instance,&bytesRemaining));/*wait for RX complete*/
#endif

#ifdef UART3_test
	  /*
	   * UART2 TX/RX test
	   */
	  while(STATUS_SUCCESS!=UART_GetTransmitStatus(&uart_pal3_instance,&bytesRemaining));/*check and confirm the TX has completed*/
	  UART_SendData(&uart_pal3_instance, UART2_txBuff, 31);/*send string info via UART0*/

	  UART_ReceiveData(&uart_pal3_instance,UART2_rxBuff, 10);/*receive data via UART0*/
	  while(STATUS_SUCCESS!=UART_GetReceiveStatus(&uart_pal3_instance,&bytesRemaining));/*wait for RX complete*/

#endif

 }
