/*
 * TSS_ADC_PWM_HS_RGBLED_Timer_BSP_Test.c
 *
 *  Created on: Sep 28, 2018
 *      Author: nxa07657
 */
/*
 * include the BSP and test configuration header
 */
#include "S32K148_TBOX_BSP.h"
#include "S32K148_TBOX_BSP_test_Config.h"

uint32_t LPIT_Initialized = 0;/*used to record the LPIT timer initialization status, 1->initialized, 0->uninitialized*/
void RGBLED_Ctrl(void);  /*used for touch sense detection and RGB set according to the result*/

/* Variables used to store PWM duty cycle */
ftm_state_t ftmStateStruct1,ftmStateStruct2;
uint16_t dutyCycle = 0x4000U;
bool increaseDutyCycle = false;

uint32_t Duty_Measure_Done_Flag = 0;
uint32_t Period_Measure_Done_Flag = 0;

uint32_t PWM_Frequency,frequency;

void timing_pal1_channel_callBack0(void * userData)
 {
	Turn_Toggle_LED(LED_BLUE);/*toggle LED_BLUE*/
	/*no need to clean the timer interrupt flag, for it's cleaned in ISR*/
 }
/******************************************************************************
 * the callback for FlexTimer Input Capture interrupt
 *****************************************************************************/
void FTM_IC1_Finished_Callback(ic_event_t event, void *userData)
{
	if(IC_EVENT_MEASUREMENT_COMPLETE==event)
	{
		Period_Measure_Done_Flag = 1;/*set the flag to inform the main program */
	}
	else
	{
		/*do nothing*/
	}

}
/******************************************************************************
 * the callback for FlexTimer Input Capture interrupt
 *****************************************************************************/
void FTM_IC2_Finished_Callback(ic_event_t event, void *userData)
{
	if(IC_EVENT_MEASUREMENT_COMPLETE==event)
	{
		Duty_Measure_Done_Flag = 1;/*set the flag to inform the main program */
	}
	else
	{
		/*do nothing*/
	}

}

void FTM6_Ovf_Reload_IRQHandler(void)
{

	Turn_Toggle_LED(LED_BLUE);/*toggle the LED*/

	FTM_RMW_SC(FTM6, FTM_SC_TOF_MASK,FTM_SC_TOF(0));/*clear the interrupt flag*/


}
 /***************************************************************************
  * the PIT channel 0 interrupt ISR
  ***************************************************************************/
 void LPIT0_Ch0_ISR(void)
 {
	 Turn_Toggle_LED(LED_GREEN);/*toggle LED_GREEN*/
	  LPIT_DRV_ClearInterruptFlagTimerChannels(INST_LPIT1,(1<<0));/*clean the interrupt flag*/
 }

 /***************************************************************************
  * the PIT channel 1 interrupt ISR
  * it is use to toggle RGB LED according to the Touch Sensor input
  ***************************************************************************/
 void LPIT0_Ch1_ISR(void)
 {

	  RGBLED_Ctrl(); /* check the touch pad input and control RGB LED */
	  LPIT_DRV_ClearInterruptFlagTimerChannels(INST_LPIT1,(1<<1));/*clean the interrupt flag*/
 }

 /***************************************************************************
  * the PORTC_IRQn_Button_ISR for button rising input interrupt
  ***************************************************************************/

 void PORTC_IRQn_Button_ISR(void)
 {
	  uint32_t Flag_Status = 0;

	  Flag_Status = PINS_DRV_GetPortIntFlag(BIN_PORT);

	  if(Flag_Status&(1<<BUTTON_BIN0))/*if button 0 press down*/
	  {
		  GPS_Debug_Ctr = GPS_DEBUG_RX_BUFFER;/*GPS debug via sending out RX buffer data*/

		  Turn_Toggle_LED(LED_BLUE);/*toggle LED_BLUE*/

		  PWM_Frequency += 500;/*increase 0.5KHz*/
		  if(PWM_Frequency>20000)/*check whether the frequency is bigger than 20KHz*/
			  PWM_Frequency = 20000;/*keep the MAX frequency*/
		  FTM_DRV_UpdatePwmPeriod(ECU_EXT_HS_FTM,FTM_PWM_UPDATE_IN_DUTY_CYCLE,PWM_Frequency,true);/*set and change the PWM frequency*/

	  }

	  if(Flag_Status&(1<<BUTTON_BIN1))/*if button 1 press down*/
	  {
		  GPS_Debug_Ctr = GPS_DEBUG_Parsed_INFO;/*GPS debug via sending out RX buffer data*/

		  Turn_Toggle_LED(LED_BLUE);/*toggle LED_BLUE*/

		  PWM_Frequency -= 500;/*decrease 0.5KHz*/
		  if(PWM_Frequency<500)/*check whether the frequency is smaller than 500Hz*/
			  PWM_Frequency = 500;/*set the MIN frequency*/
		  FTM_DRV_UpdatePwmPeriod(ECU_EXT_HS_FTM,FTM_PWM_UPDATE_IN_DUTY_CYCLE,PWM_Frequency,true);/*set and change the PWM frequency*/
	  }

	  PINS_DRV_ClearPortIntFlagCmd(BIN_PORT);/*clean the interrupt flags*/

 }


 /**************************************************************************************
  * this function is called to set user RGBLED according the touch pad detection result
  *************************************************************************************/
 void RGBLED_Ctrl(void)
 {
   	uint8_t electrodeTouched[2] = {0};

   	TSS_FilterDecode_GetResult(electrodeTouched);
       /* Electrode 0, RED LED */
       if (electrodeTouched[0] == 1)
       {
    	   Turn_On_LED(LED_RED);/* Turn on LED_RED */
       }
       else
       {
    	   Turn_Off_LED(LED_RED);/* Turn off LED_RED */
       }

       /* Electrode 1, GREEN LED */
       if (electrodeTouched[1] == 1)
       {
    	   Turn_On_LED(LED_GREEN);/* Turn on LED_GREEN */
       }
       else
       {
    	   Turn_Off_LED(LED_GREEN);/* Turn off LED_GREEN */
       }
}
/*
 * initialize the ADC module
 */
 void ADC_BSP_Init(void)
 {
	 /*
	  * Important: To avoid the same SDK component initialize twice and cause global driver structure destroy
	  * -->if TSS is not enabled(which will use ADC0 module) or POT connect to ADC1
	  * -->it's necessary to initialize the ADC module and do auto calibration
	  */
#if ((TSS_test==0)||(POT_ADC==1))
 	ADC_DRV_ConfigConverter(POT_ADC, &adConv1_ConvConfig0);/*configure the ADC module to work in SW trigger mode*/
 	ADC_DRV_AutoCalibration(POT_ADC);					   /*this is a must to get the TUE(Total Un-calibration Error) error in data sheet*/
#endif

 }
/************************************************************************************
 * call this function to start a ADC software(SW) trigger sample with:
 * Adc_No: the ADC module instance, 0/1;
 * chanIndex: the ADC channel want to be sampled
 *
 * return the sample and convert result
 ***********************************************************************************/
 uint16_t ADC_SW_Convert(uint32_t Adc_No, adc_inputchannel_t chanIndex)
 {
	 uint16_t ADC_ConvertResult = 0;/*use to get the ADC convert result*/

	adConv1_ChnConfig0.channel = chanIndex;/*assign the ADC channel for ADC measurement*/

	ADC_DRV_ConfigChan(Adc_No, 0, &adConv1_ChnConfig0);    /*trigger the ADC convert by SW*/
	ADC_DRV_WaitConvDone(Adc_No);		                    /*wait for convert complete*/
	ADC_DRV_GetChanResult(Adc_No,0,&ADC_ConvertResult);/*get the result*/

	return ADC_ConvertResult;/*return the result*/
 }

 /********************************************************************************************************
  * use ADC software trigger mode to sample
  * 1) the on-board Potentiometer(POT)
  * 2) ECU_EXT_ADC1/2 input signals
  * and then output it on the serial terminal if enabled debug printf
  ********************************************************************************************************/
 void ADC_Test(void)
 {

#ifdef POT_ADC_test
	uint16_t ADC_ConvertResult = 0;/*use to get the ADC convert result*/
	float AD_Voltage_V = 0.0;/*use to store the ADC sample signal voltage in unit V*/

	/*sample on board Potentiometer voltage and get the result */
	ADC_ConvertResult = ADC_SW_Convert(POT_ADC,POT_ADC_CH);
	AD_Voltage_V = (ADC_RefVoltage*ADC_ConvertResult)/4096;/*convert to real voltage*/

	/*
	 * print out the POT ADC convert result
	 */
	printf("the ADC_POT_CH has completed conversion,  the raw result is %d, and corresponding voltage is %-5f V \n", ADC_ConvertResult,AD_Voltage_V);

	if(ADC_ConvertResult>2048)
	{
		Turn_On_LED(LED_BLUE);/*turn on the blue LED*/
	}
	else if(ADC_ConvertResult>200)
	{
		Turn_Off_LED(LED_BLUE);/*turn off the blue LED*/
	}
	else
	{
		/*release the blue LED control*/
	}
#endif /*end of POT_ADC_test*/

#ifdef ECU_EXT_ADC_test

	/*
	 * sample ECU_EXT_ADC1_CH voltage and get the result
	 */
	ADC_ConvertResult = ADC_SW_Convert(ECU_EXT_ADC,ECU_EXT_ADC1_CH);
	AD_Voltage_V = (ECU_EXT_AD_FACTOR*ADC_ConvertResult)/4096;/*convert to real voltage*/
	/*print out the ECU_EXT_ADC signal sample result*/
	printf("the ECU_EXT_ADC1_CH sample has completed,  the raw result is %d,and corresponding voltage is %-5f V \n",ADC_ConvertResult,AD_Voltage_V);

	/*
	 * sample ECU_EXT_ADC2_CH voltage and get the result
	 */
	ADC_ConvertResult = ADC_SW_Convert(ECU_EXT_ADC,ECU_EXT_ADC2_CH);
	AD_Voltage_V = (ECU_EXT_AD_FACTOR*ADC_ConvertResult)/4096;/*convert to real voltage*/
	/*print out the ECU_EXT_ADC signal sample result*/
	printf("the ECU_EXT_ADC2_CH sample has completed,  the raw result is %d,and corresponding voltage is %-5f V \n",ADC_ConvertResult,AD_Voltage_V);

#endif /*end of ECU_EXT_ADC_test*/

 }

 void TSS_BSP_Init(void)
 {
	  /* Initialize electrode touch sense */
		TSS_Raw_Init(&tss1_RawConfig, &tss1_RawState, electrodeRawStateArr);
		TSS_FilterDecode_Init(&tss1_FilterDecodeConfig, &tss1_FilterDecodeState, electrodeFDStateArr);

		/*
		* use PIT channel 1 with 50ms interrupt period
		*/
		if(LPIT_Initialized!=1)
		{
			LPIT_DRV_Init(INST_LPIT1, &lpit1_InitConfig);/*initialize the LPIT timer*/
			LPIT_Initialized = 1;/*set the status to initialized*/
		}

		INT_SYS_InstallHandler(LPIT0_Ch1_IRQn, &LPIT0_Ch1_ISR,NULL);/*install the ISR*/
		/*	it's a must to set the interrupt priority lower than 0 */
		INT_SYS_SetPriority(LPIT0_Ch1_IRQn,2);/*set the interrupt priority*/

		LPIT_DRV_InitChannel(INST_LPIT1, 1, &lpit1_ChnConfig1);/*configure 50ms period*/
		LPIT_DRV_StartTimerChannels(INST_LPIT1,(1<<1));/*start channel 1 */
 }

 void TSS_ADC_PWM_HS_RGBLED_Timer_BSP_Init(void)
 {

#ifdef ECU_EXT_HS_test
      /* Initialize FTM PWM channel 0 PTE21
	   *  -   See FTM component for more info
	   */
	  FTM_DRV_Init(ECU_EXT_HS_FTM, &flexTimer_pwm1_InitConfig, &ftmStateStruct1);
	  /* Initialize FTM PWM channel */
	  FTM_DRV_InitPwm(ECU_EXT_HS_FTM, &flexTimer_pwm1_PwmConfig);

	  PWM_Frequency = flexTimer_pwm1_PwmConfig.uFrequencyHZ;/*initialize the frequency*/

#endif /*end of ECU_EXT_HS_test*/

#ifdef ECU_EXT_PWM_IN_test

	   FTM_DRV_Init(ECU_EXT_PWM_IN_FTM, &flexTimer_ic1_InitConfig,&ftmStateStruct2);
	   FTM_DRV_InitInputCapture(ECU_EXT_PWM_IN_FTM, &flexTimer_ic1_InputCaptureConfig);

	   /*
	    * Get the FTM1 frequency to calculate the frequency of the measured signal.
		*/
	   frequency = FTM_DRV_GetFrequency(ECU_EXT_PWM_IN_FTM);

	   /*start a new measurement on ECU_EXT_PWM_IN1_CH*/
	   FTM_DRV_StartNewSignalMeasurement(ECU_EXT_PWM_IN_FTM,ECU_EXT_PWM_IN1_CH);
	   /*start a new measurement on ECU_EXT_PWM_IN2_CH*/
	   FTM_DRV_StartNewSignalMeasurement(ECU_EXT_PWM_IN_FTM,ECU_EXT_PWM_IN2_CH);
#endif /*end of ECU_EXT_PWM_IN_test*/

#ifdef Timer_RGB_LED_test
      /*
       * initialize a timer for LED toggle at certain interrupt period
       */
      TIMING_Init(&timing_pal1_instance, &timing_pal1_InitConfig);
      TIMING_StartChannel(&timing_pal1_instance,0,100);/*interrupt @ period of 10Hz*/

      /*
       * use PIT channel 0 with 200ms interrupt period
       */
      INT_SYS_InstallHandler(LPIT0_Ch0_IRQn, &LPIT0_Ch0_ISR,NULL);/*install the ISR*/

      /*
       * it's a must to configure the timer interrupt priority lower than LPM timer interrupt
       * (0,the default and highest programmable peripheral interrupt priority) which is used by TSS
       * or some touch pad sense detection will loss
       */
      LPIT_DRV_Init(INST_LPIT1, &lpit1_InitConfig);

      LPIT_Initialized = 1; /*set status to initialized*/
      LPIT_DRV_InitChannel(INST_LPIT1, 0/*uint32_t channel*/, &lpit1_ChnConfig0);/*configure 200ms period*/
      LPIT_DRV_StartTimerChannels(INST_LPIT1,(1<<0));/*channel 0 mask*/
#endif /*end of Timer_RGB_LED_test*/

#ifdef Button_test
      /*
       * install the PORTC IRQ interrupt ISR for user button event handle
       */
      INT_SYS_InstallHandler(PORTC_IRQn, PORTC_IRQn_Button_ISR,NULL);/*install the ISR*/

      INT_SYS_EnableIRQ(PORTC_IRQn);/*enable the PORTC IRQ interrupt*/
#endif /*end of Button_test*/


#ifdef TSS_test
      TSS_BSP_Init();
#endif /*end of TSS_test*/
 }

/****************************************************************************************************
 * this function designed to mainly test the FlexTimer(FTM) to:
 *
 * 1) generate PWM signal and then output though high side(HS) driver for ECU external circuit driver
 * 2) input capture(IC) the ECU external input PWM signal, measure the period/frequency and duty
 *
 ***************************************************************************************************/
void PWM_HS_Timer_BSP_Test(void)
 {
	 uint16_t Capture_Value1, Capture_Value2;
	 uint32_t Timer_ClkFreq = 0;
	 float Duty = 0.0;
	 uint16_t Frequency = 0;

#ifdef ECU_EXT_HS_test

	   if (increaseDutyCycle == false)
	   {
		   dutyCycle -= 0x1000;
		   if (dutyCycle <=01U)
			   increaseDutyCycle = true;
	   }
	   else
	   {
		   dutyCycle += 0x1000;
		   if (dutyCycle >= FTM_MAX_DUTY_CYCLE)
			   increaseDutyCycle = false;
	   }

	   FTM_DRV_UpdatePwmChannel(ECU_EXT_HS_FTM, ECU_EXT_HS1_CH, FTM_PWM_UPDATE_IN_DUTY_CYCLE, dutyCycle, 0U, true);

	   FTM_DRV_UpdatePwmChannel(ECU_EXT_HS_FTM, ECU_EXT_HS2_CH, FTM_PWM_UPDATE_IN_DUTY_CYCLE, dutyCycle, 0U, true);

	   Duty = ((float)(dutyCycle*100.0))/FTM_MAX_DUTY_CYCLE;
	   Frequency = PWM_Frequency;/*get the PWM frequency*/

	   printf("The duty of output PWM signal on ECU_EXT_HS1  is %2.2f%%, and frequency is %d Hz\n", Duty,Frequency);
	   printf("The duty of output PWM signal on ECU_EXT_HS2  is %2.2f%%, and frequency is %d Hz \n\r", Duty,Frequency);

#endif /*end of ECU_EXT_HS_test*/


#ifdef ECU_EXT_PWM_IN_test

	   if(Period_Measure_Done_Flag)
	   {
		   Period_Measure_Done_Flag = 0;/*clean the flag*/
		   /*get the signal Period*/
		   Capture_Value1 = FTM_DRV_GetInputCaptureMeasurement(ECU_EXT_PWM_IN_FTM,ECU_EXT_PWM_IN1_CH);

		   /*get the FTM module clock frequency for input signal period and frequency calculation*/
		   Timer_ClkFreq = FTM_DRV_GetFrequency(ECU_EXT_PWM_IN_FTM);

		   /*
			* calculate out period and frequency of the input signal and print to serial terminal
			*/
		   printf("The Period of signal input on ECU_EXT_PWM_IN1 is %f second, Frequency is %d Hz\n",\
				   (((float)Capture_Value1)/Timer_ClkFreq),(Timer_ClkFreq/Capture_Value1));

		   /*start a new measurement on ECU_EXT_PWM_IN1_CH*/
		   FTM_DRV_StartNewSignalMeasurement(ECU_EXT_PWM_IN_FTM,ECU_EXT_PWM_IN1_CH);
	   }

	   if(Duty_Measure_Done_Flag)
	   {
		   Duty_Measure_Done_Flag = 0;/*clean the flag*/
		   /*get the signal ON duty*/
		   Capture_Value2 = FTM_DRV_GetInputCaptureMeasurement(ECU_EXT_PWM_IN_FTM,ECU_EXT_PWM_IN2_CH);

		   /*get the FTM module clock frequency for input signal period and frequency calculation*/
		   Timer_ClkFreq = FTM_DRV_GetFrequency(ECU_EXT_PWM_IN_FTM);

		   /*
			* calculate out ON duty of the input signal and print to serial terminal
			*/
		   printf("The ON(high) duty cycles of signal input on ECU_EXT_PWM_IN2 is %d, and corresponding time is % f second \n\r", \
				   Capture_Value2,(float)((float)Capture_Value2)/Timer_ClkFreq);

		  /*start a new measurement on ECU_EXT_PWM_IN2_CH*/
		  FTM_DRV_StartNewSignalMeasurement(ECU_EXT_PWM_IN_FTM,ECU_EXT_PWM_IN2_CH);
	   }

#endif /*end of ECU_EXT_PWM_IN_test*/

 }
