/*
 * BLE_HC08.c
 *
 *  Created on: Jun 29, 2018
 *      Author: nxa07657
 */

#include "BLE_HC08.h"

/*****************************************************************************************************************
 * call this function to check the response by compare the string of  *Response and *Anwser with the Length bytes
 ****************************************************************************************************************/
status_t Response_Check(uint8_t *Response, uint8_t *Anwser, uint8_t Length)
{
	status_t Result = STATUS_SUCCESS;/*defaut no error*/
	while(Length--)
	{
		if(*Response++!=*Anwser++)
		{
			Result = STATUS_ERROR; /*not the same*/
			break;
		}
	}

	return Result;
}

/***************************************************************************************************
 * this function is used to check whether the HC08 BLE module is OK to response AT command via UART
 ***************************************************************************************************/
status_t BLE_HC08_UART_Check( void )
{
	uint8_t AT_Cmd_Response[10];

	UART_SendDataBlocking(BLE_UART, "AT", 2, 0xFF);/*send AT command*/

	UART_ReceiveDataBlocking(BLE_UART,AT_Cmd_Response,2,0xFF);

	return Response_Check(AT_Cmd_Response, "OK",2);
}

/****************************************************************************************************
 * call this function to set the HC08 BLE module configuration default to factory setting
 ****************************************************************************************************/
status_t BLE_HC08_Factory_Recover( void )
{
	uint8_t AT_Cmd_Response[10];

	UART_SendDataBlocking(BLE_UART, "AT+DEFAULT", 10, 0xFF);/*send AT command*/

	UART_ReceiveDataBlocking(BLE_UART,AT_Cmd_Response,2,0xFF);

	return Response_Check(AT_Cmd_Response, "OK",2);
}

/****************************************************************************************************
 * call this function to reset the HC08 BLE module
 ****************************************************************************************************/
status_t BLE_HC08_Reset( void )
{
	uint8_t AT_Cmd_Response[10];

	UART_SendDataBlocking(BLE_UART, "AT+REST", 7, 0xFF);/*send AT command*/

	UART_ReceiveDataBlocking(BLE_UART,AT_Cmd_Response,2,0xFF);

	return Response_Check(AT_Cmd_Response, "OK",2);
}

/****************************************************************************************************
 * call this function to get the HC08 BLE module name
 * Notes: the name length should not longer than 12 bytes
 ****************************************************************************************************/
status_t BLE_HC08_GetName( uint8_t *Name, uint8_t *Length )
{

	status_t Cmd_Status = STATUS_SUCCESS;
	uint8_t AT_Cmd_Send[50] = "AT+NAME=?";
	uint32_t Byte_Remaining = 0;


	UART_SendDataBlocking(BLE_UART, AT_Cmd_Send, 9, 0xFF);/*send AT command*/

	Cmd_Status = UART_ReceiveData(BLE_UART,Name,20);/*get response*/

	Cmd_Status = UART_GetReceiveStatus(BLE_UART,&Byte_Remaining);
	while(STATUS_SUCCESS!=Cmd_Status)/*wait for receive complete*/
	{
		if(Cmd_Status==STATUS_UART_ABORTED)
		{
			*Length = 20 - Byte_Remaining;
			break;
		}
		else
			*Length = 20;

		Cmd_Status = UART_GetReceiveStatus(BLE_UART,&Byte_Remaining);
	}

	return Cmd_Status;
}
/****************************************************************************************************
 * call this function to set the HC08 BLE module name with *Name
 * Notes: the name length should not longer than 12 bytes
 ****************************************************************************************************/
status_t BLE_HC08_SetName( uint8_t *Name )
{
	uint8_t AT_Cmd_Response[10] = {0};
	uint8_t AT_Cmd_Send[50] = "AT+NAME=";
	uint32_t bytesRemaining;

	uint8_t i,Length = strlen(Name);

	if(Length>HC08_NAME_MAX_LENGTH)
		return STATUS_ERROR;/*the name is too long*/

	for(i=0;i<Length;i++)
	{
		AT_Cmd_Send[8+i] = *Name++;  /*attach the name to AT command*/
	}

	UART_SendDataBlocking(BLE_UART, AT_Cmd_Send, (Length+8), 0x1FF);/*send AT command*/

	UART_ReceiveData(BLE_UART,AT_Cmd_Response,strlen("OKsetNAME"));/*get response*/
	while(STATUS_SUCCESS!=UART_GetReceiveStatus(BLE_UART,&bytesRemaining));

	return Response_Check(AT_Cmd_Response,"OKsetNAME",strlen("OKsetNAME"));
}

/****************************************************************************************************
 * call this function to set the HC08 BLE module UART communication baudrate
 * the support baudrate is : 1200, 2400, 4800, 9600, 19200, 38400, 57600, 115200
 ****************************************************************************************************/
status_t BLE_HC08_Set_Baudrate( uint32_t Baudrate )
{
	if((Baudrate<1200)||(Baudrate>115200))
			return STATUS_ERROR;/*the baudrate is out of range*/

	switch(Baudrate)
	{
		case 1200: UART_SendDataBlocking(BLE_UART, "AT+BAUD=1200", 12, 0x1FF);/*send AT command*/ break;
		case 2400: UART_SendDataBlocking(BLE_UART, "AT+BAUD=2400", 12, 0x1FF);/*send AT command*/ break;
		case 4800: UART_SendDataBlocking(BLE_UART, "AT+BAUD=4800", 12, 0x1FF);/*send AT command*/ break;
		case 9600: UART_SendDataBlocking(BLE_UART, "AT+BAUD=9600", 12, 0x1FF);/*send AT command*/ break;
		case 19200: UART_SendDataBlocking(BLE_UART, "AT+BAUD=19200", 13, 0x1FF);/*send AT command*/ break;
		case 38400: UART_SendDataBlocking(BLE_UART, "AT+BAUD=38400", 13, 0x1FF);/*send AT command*/ break;
		case 57600: UART_SendDataBlocking(BLE_UART, "AT+BAUD=57600", 13, 0x1FF);/*send AT command*/ break;
		case 115200: UART_SendDataBlocking(BLE_UART, "AT+BAUD=115200", 14, 0x1FF);/*send AT command*/ break;

		default: break;
	}

	UART_SetBaudRate(BLE_UART,Baudrate);/*set the UART baud rate as BLE module*/

	return STATUS_SUCCESS;

}

/****************************************************************************************************
 * call this function to do some basic test with the API for the HC08 BLE module operations
 ****************************************************************************************************/
status_t BLE_HC08_Test(void)
{
	status_t AT_Cmd_Reslut = STATUS_SUCCESS;
	uint8_t Module_Name_Old[50]={0};
	uint8_t Module_Name_New[50]={0};
	uint8_t Modue_Info[INFO_LENGTH] = {0};

	uint8_t Name_Length = 0;
	uint16_t Received_Info_Length, Byte_Remaining = 0;

	AT_Cmd_Reslut = BLE_HC08_UART_Check();/*check whether the UART communication is OK*/
#if CHECK_MODULE_DETAILS_ENABLE
	if(AT_Cmd_Reslut==STATUS_SUCCESS) /*if the BLE module is OK to accept AT command*/
	{
		UART_SendDataBlocking(BLE_UART, "AT+RX", 5, 0xFF);/*send module information/parameters inquiry AT command*/

		AT_Cmd_Reslut = UART_ReceiveData(BLE_UART,Modue_Info,INFO_LENGTH);/*get response*/

		AT_Cmd_Reslut = UART_GetReceiveStatus(BLE_UART,&Byte_Remaining);
		while(STATUS_SUCCESS!=AT_Cmd_Reslut)/*wait for receive complete*/
		{
			if(AT_Cmd_Reslut==STATUS_UART_ABORTED)
			{
				Received_Info_Length = INFO_LENGTH - Byte_Remaining;
				break;
			}
			else
				Received_Info_Length = INFO_LENGTH;

			AT_Cmd_Reslut = UART_GetReceiveStatus(BLE_UART,&Byte_Remaining);
		}

	}
	else
	{
		printf("The BLE module cannot accept the AT command now, please check whether the HC-08 module is present on the board!\n");
		return STATUS_ERROR;    /*return error*/
	}


	if(Received_Info_Length<10)
	{
		AT_Cmd_Reslut = UART_ReceiveData(BLE_UART,&Modue_Info[Received_Info_Length],INFO_LENGTH-Received_Info_Length);/*get response*/

		AT_Cmd_Reslut = UART_GetReceiveStatus(BLE_UART,&Byte_Remaining);
		while(STATUS_SUCCESS!=AT_Cmd_Reslut)/*wait for receive complete*/
		{
			if(AT_Cmd_Reslut==STATUS_UART_ABORTED)
			{
				Received_Info_Length = INFO_LENGTH - Byte_Remaining;
				break;
			}
			else
				Received_Info_Length = INFO_LENGTH;

			AT_Cmd_Reslut = UART_GetReceiveStatus(BLE_UART,&Byte_Remaining);
		}

	}
	printf("The BLE module is OK to response the AT command now!\n");
	printf("Got the HC-08 BLE detailed information as below:\n");
	printf(" %s\n",Modue_Info);/*printf the received information*/
#else
	if(AT_Cmd_Reslut==STATUS_SUCCESS) /*if the BLE module is OK to accept AT command*/
		printf("The BLE module is OK to response the AT command now!\n");
	else
	{
		printf("The BLE module cannot accept the AT command now, please check whether the HC-08 module is present on the board!\n");
		return STATUS_ERROR;    /*return error*/
	}
#endif

	AT_Cmd_Reslut = BLE_HC08_Reset();     /*reset the module*/

	AT_Cmd_Reslut = BLE_HC08_GetName(Module_Name_Old,&Name_Length);/*get the module name*/

	AT_Cmd_Reslut = BLE_HC08_SetName("S32K-BLE");    /*set the name as "S32K-BLE"*/

	OSIF_TimeDelay(10);/*some delay is required for the BLE module to response the name set command*/

	AT_Cmd_Reslut = BLE_HC08_GetName(Module_Name_New,&Name_Length);/*get the module name*/

	return Response_Check("S32K-BLE",Module_Name_New, sizeof("S32K-BLE"));/*return the result*/

}

