#ifndef __THERMOSTAT_DEFINES__

  #define __THERMOSTAT_DEFINES__
  
  #define BusClockHighSpeed    8388000
  #define BusClockLowSpeed     32768
  
  #undef  __LOWEND_TSTAT__
  #define  __HIGHEND_TSTAT__
  
  //#define DEBUG_ON
  #undef DEBUG_ON

  #define _DEBOUNCE_25msec              1700
  #define _DEBOUNCE_100msec             6800
  #define _DEBOUNCE_150msec             10300
  #define _DEBOUNCE_200msec             13350
  #define _DEBOUNCE_250msec             16400
  #define _DEBOUNCE_500msec             38800
  

  #define TEMPERATURE_DIGITS            3
  #define TEMP_SHIFT                    4
  #define LCD_TEMPERATURE_POS           5
  
  #define HOUR_DIGITS                   4
  #define LCD_HOUR_COLON_BLINK          _LCD_COL1_Blink
  #define _LCD_COLON_OFF                _LCD_COL1_OFF
  #define _LCD_COLON_ON                 _LCD_COL1_ON
  #define LCD_HOURS_POS                 0
  #define LCD_MINUTES_POS               2
  
  #define _LCD_HOLD_OFF                 _LCD_MODE_OFF
  #define _LCD_HOLD_ON                  _LCD_MODE_ON
  #define _LCD_HOLD_Blink               _LCD_MODE_Blink
  
  #define _LCD_ONE_OFF                  LCD_SET_CURSOR(LCD_HOURS_POS);\
                                        vfnLCD_Write_Char(_LCD_BLANK_SPACE_)
                                        
  #define _LCD_COOL_ON                  _LCD_M5_ON
  #define _LCD_COOL_OFF                 _LCD_M5_OFF
  
  #define _LCD_HEAT_ON                  _LCD_M1_ON
  #define _LCD_HEAT_OFF                 _LCD_M1_OFF
  
  /* Delay in Seconds to show the current Profile */
  #define SHOW_PROGRAM_DELAY            5
  
  
  #define TEMP_MEASUREMENT_WAKEUP       TOD_MATCH_EVENT
  #define CLEAR_TEMP_MEASUREMENT_FLAG   CLEAR_MATCH_EVENT
  
  #define BLINK_ON_TIME                 2  // Times 0.25 Seconds
  

  #ifdef DEBUG_ON
    #define SW_BREAKPOINT()        asm("bgnd")
    
    #define CONFIG_DEBUG_SIGNAL()  PTBDD_PTBDD3 = 1
    #define DEBUG_SIGNAL_ON()      PTBD_PTBD3 = 1
    #define DEBUG_SIGNAL_OFF()     PTBD_PTBD3 = 0
    
  #else
    #define SW_BREAKPOINT()   asm("nop")
  #endif


#endif