/**
Copyright (c) 2009 Freescale Semiconductor

\file       Ascii.h
\brief      Header file for the Thermostat LCD. Determines which LCD will be used in the included files
\author     Freescale Semiconductor
\author     Technical Information Center
\version    1.0
\date       February/2009
*/
/********************************************************************************************
* Freescale reserves the right to make changes without further notice to any product
* herein to improve reliability, function, or design. Freescale does not assume any
* liability arising out of the application or use of any product, circuit, or software
* described herein; neither does it convey any license under its patent rights nor the
* rights of others. Freescale products are not designed, intended, or authorized for
* use as components in systems intended for surgical implant into the body, or other
* applications intended to support life, or for any other application in which the
* failure of the Freescale product could create a situation where personal injury or
* death may occur. Should Buyer purchase or use Freescale products for any such
* intended or unauthorized application, Buyer shall indemnify and hold Freescale and
* its officers, employees, subsidiaries, affiliates, and distributors harmless against
* all claims, costs, damages, and expenses, and reasonable attorney fees arising out
* of, directly or indirectly, any claim of personal injury or death associated with
* such unintended or unauthorized use, even if such claim alleges that Freescale was
* negligent regarding the design or manufacture of the part.
*
* Freescale is a registered trademark of Freescale, Inc.
********************************************************************************************/	

/*****************************************************************************************************
* Module definition against multiple inclusion
*****************************************************************************************************/
#ifndef __TSTAT_LCD__
  #define __TSTAT_LCD__

/*****************************************************************************************************
* Include files
*****************************************************************************************************/  
  #include "FslTypes.h"
  #include "Thermostat_Definitions.h"
  #include "Calendar.h"
  #include "Ascii.h"
  #ifdef __LOWEND_TSTAT__
    #include "LCD_GD5360P.h"
  #else
    #include "LCD_GD4935.h"
  #endif  
  
/*****************************************************************************************************
* Declaration of project wide TYPES
*****************************************************************************************************/

/*****************************************************************************************************
* Definition of project wide VARIABLES
*****************************************************************************************************/

/*****************************************************************************************************
* Definition of project wide MACROS / #DEFINE-CONSTANTS 
*****************************************************************************************************/
  #define _LCD_BLANK_SPACE_     0x3A
  
  #ifdef __HIGHEND_TSTAT__
    #define _LCD_DEGREES_SYMBOL   0x40
  #else
    #define _LCD_DEGREES_SYMBOL   0x3F
  #endif
  
  /* Voltage leveles are in Volts * 10 */
  #define BATT_4_LEVEL_INDICATOR    280
  #define BATT_3_LEVEL_INDICATOR    270
  #define BATT_2_LEVEL_INDICATOR    260
  #define BATT_1_LEVEL_INDICATOR    240

/*****************************************************************************************************
* Declaration of project wide FUNCTIONS
*****************************************************************************************************/
  void vfnThermostatLCD_Init(void);
  void vfnDisplayDayOfWeek(UINT8 DayOfWeek);
  void vfnUpdateDayAndTime(RTC_Type* LocalRTC);
  void vfnDisplayBatteryLife(UINT16 BatteryLevel);
  void vfnDisplayTemperature(UINT16 Temperature);
  
  #ifdef __LOWEND_TSTAT__
    void vfnBlinkDayOfWeek(UINT8 DayOfWeek);
  #endif
  
#endif