/****************************************************************************************************/
/**
Copyright (c) 2009 Freescale Semiconductor

\file       ThermostatKeys.c
\brief      File to determine which of the different Thermostat keys was pressed
\author     Freescale Semiconductor
\author     Technical Information Center
\version    1.0
\date       February/2009
*/
/********************************************************************************************
* Freescale reserves the right to make changes without further notice to any product
* herein to improve reliability, function, or design. Freescale does not assume any
* liability arising out of the application or use of any product, circuit, or software
* described herein; neither does it convey any license under its patent rights nor the
* rights of others. Freescale products are not designed, intended, or authorized for
* use as components in systems intended for surgical implant into the body, or other
* applications intended to support life, or for any other application in which the
* failure of the Freescale product could create a situation where personal injury or
* death may occur. Should Buyer purchase or use Freescale products for any such
* intended or unauthorized application, Buyer shall indemnify and hold Freescale and
* its officers, employees, subsidiaries, affiliates, and distributors harmless against
* all claims, costs, damages, and expenses, and reasonable attorney fees arising out
* of, directly or indirectly, any claim of personal injury or death associated with
* such unintended or unauthorized use, even if such claim alleges that Freescale was
* negligent regarding the design or manufacture of the part.
*
* Freescale is a registered trademark of Freescale, Inc.
********************************************************************************************/	
/*****************************************************************************************************
* Include files
*****************************************************************************************************/
#include "ThermostatKeys.h"

/*****************************************************************************************************
* Declaration of module wide FUNCTIONs - NOT for use in other modules
*****************************************************************************************************/

/*****************************************************************************************************
* Definition of module wide MACROs / #DEFINE-CONSTANTs - NOT for use in other modules
*****************************************************************************************************/

/*****************************************************************************************************
* Declaration of module wide TYPEs - NOT for use in other modules
*****************************************************************************************************/

/*****************************************************************************************************
* Definition of module wide VARIABLEs - NOT for use in other modules
*****************************************************************************************************/

/*****************************************************************************************************
* Definition of module wide (CONST-) CONSTANTs - NOT for use in other modules
*****************************************************************************************************/

/*****************************************************************************************************
* Code of project wide FUNCTIONS
*****************************************************************************************************/
/**
* \brief    Initialize the keyboard and IRQ modules to be used as Keys
* \author   
* \param    void
* \return   void
* \todo     
*/
void vfnThermostatKeys_Init(void)
{
  vfnKeyboard_Init(((1<<TIME_PIN) | (1<<UP_PIN) | (1<<DOWN_PIN) | (1<<PROGRAM_PIN)), KB_INTERRUPT_ENABLED);
  /*
  PTCDD_PTCDD2 = 0;
  PTCPE_PTCPE2 = 1;
  */
  PTCPE_PTCPE7 = 1;
  IRQ_CONFIG();
  IRQSC_IRQACK = 1;
  
}

/**
* \brief    Returns the key name of the key pressed in the Thermostat
* \author   
* \param    void
* \return   Name of the Key pressed
* \todo     
*/

UINT8 u8ThermostatGetKey(void)
{
  if (TIME_DATE_KEY)
  {
    TIME_DATE_KEY_CLEAR;
    return (TIME_DATE_KEY_PRESSED);
  }
  
  if (UP_KEY)
  {
    UP_KEY_CLEAR;
    return (UP_KEY_PRESSED);
  }
  
  if (DOWN_KEY)
  {
    DOWN_KEY_CLEAR;
    return (DOWN_KEY_PRESSED);
  }
  
  if (PROGRAM_KEY)
  {
    PROGRAM_KEY_CLEAR;
    return (PROGRAM_KEY_PRESSED);
  }
  
  if (RUN_HOLD_KEY)
  {
    RUN_HOLD_KEY_CLEAR;
    return (RUN_HOLD_KEY_PRESSED);
  }
}