/**
Copyright (c) 2009 Freescale Semiconductor

\file       S08_TPM.h
\brief      Header file including the initialization definition to start the timer and its channels
\author     Freescale Semiconductor
\author     Technical Information Center
\version    1.0
\date       February/2009
*/
/********************************************************************************************
* Freescale reserves the right to make changes without further notice to any product
* herein to improve reliability, function, or design. Freescale does not assume any
* liability arising out of the application or use of any product, circuit, or software
* described herein; neither does it convey any license under its patent rights nor the
* rights of others. Freescale products are not designed, intended, or authorized for
* use as components in systems intended for surgical implant into the body, or other
* applications intended to support life, or for any other application in which the
* failure of the Freescale product could create a situation where personal injury or
* death may occur. Should Buyer purchase or use Freescale products for any such
* intended or unauthorized application, Buyer shall indemnify and hold Freescale and
* its officers, employees, subsidiaries, affiliates, and distributors harmless against
* all claims, costs, damages, and expenses, and reasonable attorney fees arising out
* of, directly or indirectly, any claim of personal injury or death associated with
* such unintended or unauthorized use, even if such claim alleges that Freescale was
* negligent regarding the design or manufacture of the part.
*
* Freescale is a registered trademark of Freescale, Inc.
********************************************************************************************/	

/*****************************************************************************************************
* Module definition against multiple inclusion
*****************************************************************************************************/
#ifndef __S08_TPM__
  #define __S08_TPM__

/*****************************************************************************************************
* Include files
*****************************************************************************************************/
  #include "Derivative.h"
  #include "FslTypes.h"
    
/*****************************************************************************************************
* Declaration of project wide TYPES
*****************************************************************************************************/
    typedef enum
    {
      TPM1 = 1,
      TPM2
    }_AVAILABLE_TPMS_ENUM_;
    
    typedef enum
    {
      TPM_CHANNEL0,
      TPM_CHANNEL1
    }_TPM_CHANNELS_;
    
    typedef enum
    {
      TPM1_CHAN0_INTERRUPT,
      TPM1_CHAN1_INTERRUPT,
      TPM2_CHAN0_INTERRUPT,
      TPM2_CHAN1_INTERRUPT,
      TPM1_OVF_INTERRUPT,
      TPM2_OVF_INTERRUPT
    }_TPM_STATUS_FLAGS_;

/*****************************************************************************************************
* Definition of project wide VARIABLES
*****************************************************************************************************/
    extern UINT8 gu8TPM_Status;
/*****************************************************************************************************
* Definition of project wide MACROS / #DEFINE-CONSTANTS 
*****************************************************************************************************/
    #define TPM1Address   &TPM1SC
    #define TPM2Address   &TPM2SC
    
    #define TPM_BUS_CLOCK       TPM1SC_CLKSA_MASK
    #define TPM_FIXED_CLOCK     TPM1SC_CLKSB_MASK
    #define TPM_EXT_CLOCK       TPM1SC_CLKSA_MASK | TPM1SC_CLKSB_MASK
    
    #define TPM_PRESCALER_1     0
    #define TPM_PRESCALER_2     TPM1SC_PS0_MASK
    #define TPM_PRESCALER_4     TPM1SC_PS1_MASK
    #define TPM_PRESCALER_8     TPM1SC_PS1_MASK | TPM1SC_PS0_MASK
    #define TPM_PRESCALER_16    TPM1SC_PS2_MASK
    #define TPM_PRESCALER_32    TPM1SC_PS2_MASK | TPM1SC_PS0_MASK
    #define TPM_PRESCALER_64    TPM1SC_PS2_MASK | TPM1SC_PS1_MASK
    #define TPM_PRESCALER_128   TPM1SC_PS2_MASK | TPM1SC_PS1_MASK | TPM1SC_PS0_MASK
    
    #define TPM_OVF_INTERRUPT   TPM1SC_TOIE_MASK
    
    #define INPUT_CAPTURE_RISING_EDGE    TPM1C0SC_ELS0A_MASK
    #define INPUT_CAPTURE_FALLING_EDGE   TPM1C0SC_ELS0B_MASK
    #define INPUT_CAPTURE_BOTH_EDGES     TPM1C0SC_ELS0A_MASK | TPM1C0SC_ELS0B_MASK
    
    #define SW_COMPARE                   TPM1C0SC_MS0A_MASK
    #define TOGGLE_ON_COMPARE            TPM1C0SC_MS0A_MASK | TPM1C0SC_ELS0A_MASK
    #define CLEAR_ON_COMPARE             TPM1C0SC_MS0A_MASK | TPM1C0SC_ELS0B_MASK
    #define SET_ON_COMPARE               TPM1C0SC_MS0A_MASK | TPM1C0SC_ELS0A_MASK | TPM1C0SC_ELS0B_MASK
    
    #define TPM_CHANNEL_INTERRUPT        TPM1C0SC_CH0IE_MASK
    
                                                       
    #define TIMER_INIT(TPMNum, Config)                  TPM##TPMNum##SC = Config
    #define TIMER_CHANNEL_INIT(TPMNum, TPMChan, Config) TPM##TPMNum##C##TPMChan##SC = Config     
    
    #define SET_TIMER_PERIOD(TPM, Period)               TPM##TPM##MOD = (UINT16)Period
                                                
    #define SET_DUTY_CYCLE(TPM, TPMChannel, DutyCycle)  TPM##TPM##C##TPMChannel##V = (UINT16)DutyCycle
    
    #define GET_INPUTCAPTURE(TPM, TPMChannel)           TPM##TPM##C##TPMChannel##V 

/*****************************************************************************************************
* Declaration of project wide FUNCTIONS
*****************************************************************************************************/
    
    
#endif  