/****************************************************************************************************/
/****************************************************************************************************/
/**
Copyright (c) 2009 Freescale Semiconductor

\file       S08_TPM.c
\brief      Source file with the vectors definitions for the different timer channels
\author     Freescale Semiconductor
\author     Technical Information Center
\version    1.0
\date       February/2009
*/
/********************************************************************************************
* Freescale reserves the right to make changes without further notice to any product
* herein to improve reliability, function, or design. Freescale does not assume any
* liability arising out of the application or use of any product, circuit, or software
* described herein; neither does it convey any license under its patent rights nor the
* rights of others. Freescale products are not designed, intended, or authorized for
* use as components in systems intended for surgical implant into the body, or other
* applications intended to support life, or for any other application in which the
* failure of the Freescale product could create a situation where personal injury or
* death may occur. Should Buyer purchase or use Freescale products for any such
* intended or unauthorized application, Buyer shall indemnify and hold Freescale and
* its officers, employees, subsidiaries, affiliates, and distributors harmless against
* all claims, costs, damages, and expenses, and reasonable attorney fees arising out
* of, directly or indirectly, any claim of personal injury or death associated with
* such unintended or unauthorized use, even if such claim alleges that Freescale was
* negligent regarding the design or manufacture of the part.
*
* Freescale is a registered trademark of Freescale, Inc.
********************************************************************************************/	

/*****************************************************************************************************
* Include files
*****************************************************************************************************/
#include "S08_TPM.h"

UINT8 gu8TPM_Status;

__interrupt VectorNumber_Vtpm1ch0 void TPM1_Channel0_ISR(void)
{
  (void)TPM1C0SC;
  TPM1C0SC_CH0F = 0;
  
  gu8TPM_Status |= (1<<TPM1_CHAN0_INTERRUPT);
}

__interrupt VectorNumber_Vtpm1ch1 void TPM1_Channel1_ISR(void)
{
  (void)TPM1C1SC;
  TPM1C1SC_CH1F = 0;
  
  gu8TPM_Status |= (1<<TPM1_CHAN1_INTERRUPT);
}

__interrupt VectorNumber_Vtpm1ovf void TPM1_OverflowISR(void)
{
  (void)TPM1SC;
  TPM1SC_TOF = 0;
  
  gu8TPM_Status |= (1<<TPM1_OVF_INTERRUPT);
}

__interrupt VectorNumber_Vtpm2ch0 void TPM2_Channel0_ISR(void)
{
  (void)TPM2C0SC;
  TPM2C0SC_CH0F = 0;
  
  gu8TPM_Status |= (1<<TPM2_CHAN0_INTERRUPT);
}

__interrupt VectorNumber_Vtpm2ch1 void TPM2_Channel1_ISR(void)
{
  (void)TPM2C1SC;
  TPM2C1SC_CH1F = 0;
  
  gu8TPM_Status |= (1<<TPM2_CHAN1_INTERRUPT);
}

__interrupt VectorNumber_Vtpm2ovf void TPM2_OverflowISR(void)
{
  (void)TPM2SC;
  TPM2SC_TOF = 0;
  
  gu8TPM_Status |= (1<<TPM2_OVF_INTERRUPT);
}