/**
Copyright (c) 2009 Freescale Semiconductor

\file       S08_TOD_Driver.h
\brief      Header file for TOD Driver
\author     Freescale Semiconductor
\author     Technical Information Center
\version    1.0
\date       February/2009
*/
/********************************************************************************************
* Freescale reserves the right to make changes without further notice to any product
* herein to improve reliability, function, or design. Freescale does not assume any
* liability arising out of the application or use of any product, circuit, or software
* described herein; neither does it convey any license under its patent rights nor the
* rights of others. Freescale products are not designed, intended, or authorized for
* use as components in systems intended for surgical implant into the body, or other
* applications intended to support life, or for any other application in which the
* failure of the Freescale product could create a situation where personal injury or
* death may occur. Should Buyer purchase or use Freescale products for any such
* intended or unauthorized application, Buyer shall indemnify and hold Freescale and
* its officers, employees, subsidiaries, affiliates, and distributors harmless against
* all claims, costs, damages, and expenses, and reasonable attorney fees arising out
* of, directly or indirectly, any claim of personal injury or death associated with
* such unintended or unauthorized use, even if such claim alleges that Freescale was
* negligent regarding the design or manufacture of the part.
*
* Freescale is a registered trademark of Freescale, Inc.
********************************************************************************************/	

/*****************************************************************************************************
* Module definition against multiple inclusion
*****************************************************************************************************/
#ifndef __S08_TOD_Driver__
  #define __S08_TOD_Driver__

/*****************************************************************************************************
* Include files
*****************************************************************************************************/
  #include "Derivative.h"
  #include "FslTypes.h"
  
/*****************************************************************************************************
* Declaration of project wide TYPES
*****************************************************************************************************/
/* Status Flags Definitions */
  typedef enum
  {
    TOD_QSECONDS,
    TOD_SECONDS,
    TOD_MATCH    
  };

/*****************************************************************************************************
* Definition of project wide VARIABLES
*****************************************************************************************************/

/*****************************************************************************************************
* Definition of project wide MACROS / #DEFINE-CONSTANTS 
*****************************************************************************************************/
  /* Oscillator Definitions */
  #define _TOD_LPO_OSCILLATOR_  0b00110000
  #define _TOD_32_768KHZ_XTAL_  0b00010001
  #define _TOD_INTERNAL_REF_    0b01010011
  #define _TOD_32KHZ_XTAL_      0b00010010
  #define _TOD_4_9152MHZ_XTAL_  0b00010100
  #define _TOD_4MHZ_XTAL_       0b00010101
  #define _TOD_8MHZ_XTAL_       0b00010110
  #define _TOD_16MHZ_XTAL_      0b00010111  
  
  /* Match Conditions */
  #define TOD_MATCH_5_SEC           20
  #define TOD_MATCH_10_SEC          40
  #define TOD_MATCH_15_SEC          60
  #define TOD_MATCH_30_SEC          120
  #define TOD_MATCH_45_SEC          180
  #define TOD_MATCH_60_SEC          240
  
  #define TOD_QSECONDS_EVENT()   (gu8TOD_Status & (1<<TOD_QSECONDS))
  #define TOD_SECONDS_EVENT()    (gu8TOD_Status & (1<<TOD_SECONDS))
  #define TOD_MATCH_EVENT()      (gu8TOD_Status & (1<<TOD_MATCH))
  
  #define CLEAR_QSECONDS_EVENT() gu8TOD_Status &= ~(1<<TOD_QSECONDS)
  #define CLEAR_SECONDS_EVENT()  gu8TOD_Status &= ~(1<<TOD_SECONDS)
  #define CLEAR_MATCH_EVENT()    gu8TOD_Status &= ~(1<<TOD_MATCH)
  

/*****************************************************************************************************
* Declaration of project wide FUNCTIONS
*****************************************************************************************************/

  /* Public Function Prototypes */
  void vfnTOD_Init(UINT8 TOD_ClockSource, UINT8 DesiredInterrupts, UINT8 MatchValue);
  
  /* Public Variables */
  extern UINT8 gu8TOD_Status;
  
#endif