/**
Copyright (c) 2009 Freescale Semiconductor

\file       Ascii.h
\brief      Header file to use the Keyboard module of an S08 device
\author     Freescale Semiconductor
\author     Technical Information Center
\version    1.0
\date       February/2009
*/
/********************************************************************************************
* Freescale reserves the right to make changes without further notice to any product
* herein to improve reliability, function, or design. Freescale does not assume any
* liability arising out of the application or use of any product, circuit, or software
* described herein; neither does it convey any license under its patent rights nor the
* rights of others. Freescale products are not designed, intended, or authorized for
* use as components in systems intended for surgical implant into the body, or other
* applications intended to support life, or for any other application in which the
* failure of the Freescale product could create a situation where personal injury or
* death may occur. Should Buyer purchase or use Freescale products for any such
* intended or unauthorized application, Buyer shall indemnify and hold Freescale and
* its officers, employees, subsidiaries, affiliates, and distributors harmless against
* all claims, costs, damages, and expenses, and reasonable attorney fees arising out
* of, directly or indirectly, any claim of personal injury or death associated with
* such unintended or unauthorized use, even if such claim alleges that Freescale was
* negligent regarding the design or manufacture of the part.
*
* Freescale is a registered trademark of Freescale, Inc.
********************************************************************************************/	

/*****************************************************************************************************
* Module definition against multiple inclusion
*****************************************************************************************************/
#ifndef __S08_KEYBOARD__
  #define __S08_KEYBOARD__

/*****************************************************************************************************
* Include files
*****************************************************************************************************/
  #include "Derivative.h"
  #include "FslTypes.h"

/*****************************************************************************************************
* Declaration of project wide TYPES
*****************************************************************************************************/
typedef enum
  {
    KB_PIN0,
    KB_PIN1,
    KB_PIN2,
    KB_PIN3,
    KB_PIN4,
    KB_PIN5,
    KB_PIN6,
    KB_PIN7
  }__KB_MODULE_PINS;

/*****************************************************************************************************
* Definition of project wide VARIABLES
*****************************************************************************************************/
  extern UINT8 gu8KB_Status;

/*****************************************************************************************************
* Definition of project wide MACROS / #DEFINE-CONSTANTS 
*****************************************************************************************************/
  #define KB_EDGES_AND_LEVELS    1
  #define KB_INTERRUPT_ENABLED   2
  
  #define KB_PULLUPS              PTAPE
  #define KB_DDR                  PTADD
  #define KB_PORT                 PTAD
  
  
  
  #define KB_PIN0_EVENT         !(gu8KB_Status & (1<<KB_PIN0))
  #define KB_PIN0_CLEAR_EVENT   gu8KB_Status |= (1<<KB_PIN0)
    
  #define KB_PIN1_EVENT         !(gu8KB_Status & (1<<KB_PIN1))
  #define KB_PIN1_CLEAR_EVENT   gu8KB_Status |= (1<<KB_PIN1)
  
  #define KB_PIN2_EVENT         !(gu8KB_Status & (1<<KB_PIN2))
  #define KB_PIN2_CLEAR_EVENT   gu8KB_Status |= (1<<KB_PIN2)
  
  #define KB_PIN3_EVENT         !(gu8KB_Status & (1<<KB_PIN3))
  #define KB_PIN3_CLEAR_EVENT   gu8KB_Status |= (1<<KB_PIN3)
  
  #define KB_PIN4_EVENT         !(gu8KB_Status & (1<<KB_PIN4))
  #define KB_PIN4_CLEAR_EVENT   gu8KB_Status |= (1<<KB_PIN4)
  
  #define KB_PIN5_EVENT         !(gu8KB_Status & (1<<KB_PIN5))
  #define KB_PIN5_CLEAR_EVENT   gu8KB_Status |= (1<<KB_PIN5)
  
  #define KB_PIN6_EVENT         !(gu8KB_Status & (1<<KB_PIN6))
  #define KB_PIN6_CLEAR_EVENT   gu8KB_Status |= (1<<KB_PIN6)
  
  #define KB_PIN7_EVENT         !(gu8KB_Status & (1<<KB_PIN7))
  #define KB_PIN7_CLEAR_EVENT   gu8KB_Status |= (1<<KB_PIN7)

/*****************************************************************************************************
* Declaration of project wide FUNCTIONS
*****************************************************************************************************/
  void vfnKeyboard_Init(UINT8 lu8KeyboardPinsUsed, UINT8 lu8KB_Configuration);
  
#endif