/****************************************************************************************************/
/****************************************************************************************************/
/**
Copyright (c) 2009 Freescale Semiconductor

\file       Ascii.c
\brief      Source file for the ASCII handling routines
\author     Freescale Semiconductor
\author     Technical Information Center
\version    1.0
\date       February/2009
*/
/********************************************************************************************
* Freescale reserves the right to make changes without further notice to any product
* herein to improve reliability, function, or design. Freescale does not assume any
* liability arising out of the application or use of any product, circuit, or software
* described herein; neither does it convey any license under its patent rights nor the
* rights of others. Freescale products are not designed, intended, or authorized for
* use as components in systems intended for surgical implant into the body, or other
* applications intended to support life, or for any other application in which the
* failure of the Freescale product could create a situation where personal injury or
* death may occur. Should Buyer purchase or use Freescale products for any such
* intended or unauthorized application, Buyer shall indemnify and hold Freescale and
* its officers, employees, subsidiaries, affiliates, and distributors harmless against
* all claims, costs, damages, and expenses, and reasonable attorney fees arising out
* of, directly or indirectly, any claim of personal injury or death associated with
* such unintended or unauthorized use, even if such claim alleges that Freescale was
* negligent regarding the design or manufacture of the part.
*
* Freescale is a registered trademark of Freescale, Inc.
********************************************************************************************/	

/*****************************************************************************************************
* Include files
*****************************************************************************************************/
#include "Ascii.h"


/*****************************************************************************************************
* Declaration of module wide FUNCTIONs - NOT for use in other modules
*****************************************************************************************************/

/*****************************************************************************************************
* Definition of module wide MACROs / #DEFINE-CONSTANTs - NOT for use in other modules
*****************************************************************************************************/

/*****************************************************************************************************
* Declaration of module wide TYPEs - NOT for use in other modules
*****************************************************************************************************/

/*****************************************************************************************************
* Definition of module wide VARIABLEs - NOT for use in other modules
*****************************************************************************************************/

/*****************************************************************************************************
* Definition of module wide (CONST-) CONSTANTs - NOT for use in other modules
*****************************************************************************************************/

/*****************************************************************************************************
* Code of project wide FUNCTIONS
*****************************************************************************************************/

/****************************************************************************************************/
/**
* \brief    Converts an ASCII value into its hexadecimal equivalent
* \author   
* \param    UINT8 u8ASCIIData - 
* \return   void
* \todo     
*/
UINT8 u8AsciiDataToUint8(UINT8 u8ASCIIData)
{
    UINT8 u8TempValue;
    if ((u8ASCIIData >= '0') && (u8ASCIIData <= '9'))
    {
        u8TempValue = (UINT8)(u8ASCIIData - '0');
    }
    else
    {
        /* Convert to upper case */
        u8ASCIIData &= 0xDFu;

        /* If(within the range of valid letters) */
        u8TempValue = (UINT8)(u8ASCIIData - 'A' + 10u);
        /*return ERROR */
    }
    return (u8TempValue);
}

/*****************************************************************************************************
* \brief    Converts a Decimal value into two ASCII characters
* \author   Rafael Peralez
* \param    DecData Decimal Value
* \param    *Buffer Buffer where the two ascii characters will be written
* \return   void
* \todo     
*/
void Dec8bitsToASCIIBCD(UINT8 DecData, UINT8* Buffer)
{
  *Buffer = (DecData / 10) + 0x30;
  Buffer++;
  *Buffer = (DecData % 10) + 0x30;
}

/****************************************************************************************************/
