/******************************************************************************
*  (c) copyright Freescale Semiconductor China Ltd. 2008
*  ALL RIGHTS RESERVED
*  File Name: USB_Handle.H
*  Description: USB Header files       			    
*  Assembler:  Codewarrior for HC(S)08 V6.0
*  Version: 1.1                                                         
*  Author: Patrick Yang                              
*  Location: Shanghai, P.R.China                                              
*                                                                                                                  
* UPDATED HISTORY:
*
* REV   YYYY.MM.DD  AUTHOR        DESCRIPTION OF CHANGE
* ---   ----------  ------        --------------------- 
* 1.0   2008.01.09  Patrick Yang  Initial version
* 1.1   2008.08.12  Jose Ruiz     Modify USB Handler 
******************************************************************************/                                                                        
/* Freescale  is  not  obligated  to  provide  any  support, upgrades or new */
/* releases  of  the Software. Freescale may make changes to the Software at */
/* any time, without any obligation to notify or provide updated versions of */
/* the  Software  to you. Freescale expressly disclaims any warranty for the */
/* Software.  The  Software is provided as is, without warranty of any kind, */
/* either  express  or  implied,  including, without limitation, the implied */
/* warranties  of  merchantability,  fitness  for  a  particular purpose, or */
/* non-infringement.  You  assume  the entire risk arising out of the use or */
/* performance of the Software, or any systems you design using the software */
/* (if  any).  Nothing  may  be construed as a warranty or representation by */
/* Freescale  that  the  Software  or  any derivative work developed with or */
/* incorporating  the  Software  will  be  free  from  infringement  of  the */
/* intellectual property rights of third parties. In no event will Freescale */
/* be  liable,  whether in contract, tort, or otherwise, for any incidental, */
/* special,  indirect, consequential or punitive damages, including, but not */
/* limited  to,  damages  for  any loss of use, loss of time, inconvenience, */
/* commercial loss, or lost profits, savings, or revenues to the full extent */
/* such  may be disclaimed by law. The Software is not fault tolerant and is */
/* not  designed,  manufactured  or  intended by Freescale for incorporation */
/* into  products intended for use or resale in on-line control equipment in */
/* hazardous, dangerous to life or potentially life-threatening environments */
/* requiring  fail-safe  performance,  such  as  in the operation of nuclear */
/* facilities,  aircraft  navigation  or  communication systems, air traffic */
/* control,  direct  life  support machines or weapons systems, in which the */
/* failure  of  products  could  lead  directly to death, personal injury or */
/* severe  physical  or  environmental  damage  (High  Risk Activities). You */
/* specifically  represent and warrant that you will not use the Software or */
/* any  derivative  work of the Software for High Risk Activities.           */
/* Freescale  and the Freescale logos are registered trademarks of Freescale */
/* Semiconductor Inc.                                                        */ 
/*****************************************************************************/

#ifndef __USBHandler__
#define __USBHandler__


#include "derivative.h"
#include "SCSI.h"
#include "SD.h"

/* Defines */

    // USB state machine
enum {
  cDETACH=0,
  cATTACH,
  cPOWER,
  cDEFAULT,
  cADR_PENDING,
  cADDRESS,
  cCONFIGURE,
  cSUSPEND,
};

    // Control transfer state machine
enum
{
  cUSBSetup=0,                      
  cUSBWait,  
  cCBW,                 
  cCSW,
  cEP1Tx,
  cEP2Rx,
};

    // USB commands
#define mGET_STATUS           0
#define mCLR_FEATURE          1
#define mSET_FEATURE          3
#define mSET_ADDRESS          5
#define mGET_DESC             6
#define mSET_DESC             7
#define mGET_CONFIG           8
#define mSET_CONFIG           9
#define mGET_INTF             10
#define mSET_INTF             11
#define mSYNC_FRAME           12
#define	mGET_MAXLUN	          0xFE		// Mass Storage command

#define mDEVICE					    1
#define mCONFIGURATION		        2
#define mSTRING					    3
#define mINTERFACE				    4
#define mENDPOINT				    5
#define	mDEVICE_QUALIFIER		    6
#define mOTHER_SPEED_CONFIGURATION	7
#define mINTERFACE_POWER			8


    // Endpoint0 Token define
#define mEP0_OUT      0x00
#define mEP0_IN       0x08
#define mEP1_IN       0x18
#define mEP2_OUT      0x20
#define mSETUP_TOKEN  0b00001101


    // Endpoint buffer size
#define cEP0_BUFF_SIZE  16
#define cEP1_BUFF_SIZE  64
#define cEP2_BUFF_SIZE  64


    // Endpoint buffer address
#define cEP0INBuffAddr  0x08
#define cEP0OUTBuffAddr 0x0C
#define cEP1INBuffAddr  0x10
#define cEP2OUTBuffAddr 0x20


    // BDT status value
#define kMCU      0x00
#define kUDATA0   0x88
#define kUDATA1   0xC8




/* Typedefs */

    // BDT status structure
typedef union _tBDT_STAT
{
    byte _byte;
    struct{
        unsigned :1;
        unsigned :1;
        unsigned BSTALL:1;              //Buffer Stall Enable
        unsigned DTS:1;                 //Data Toggle Synch Enable
        unsigned NINC:1;                //Address Increment Disable
        unsigned KEEP:1;                //BD Keep Enable
        unsigned DATA:1;                //Data Toggle Synch Value
        unsigned UOWN:1;                //USB Ownership
    }McuCtlBit;
       
    struct{
        unsigned    :2;
        unsigned PID:4;                 //Packet Identifier
        unsigned    :2;
    }RecPid;
} tBDT_STAT;                            //Buffer Descriptor Status Register

    // BDT structure
typedef struct _tBDT
{
        tBDT_STAT Stat;
        unsigned char Cnt;
        unsigned char Addr;             //Buffer Address 
} tBDT;                                 //Buffer Descriptor Table

    // Setup token structure
typedef struct _tUSB_Setup 
{
       byte bmRequestType;
       byte bRequest;
       byte wValue_l;
       byte wValue_h;
       byte wIndex_l;
       byte wIndex_h;
       byte wLength_l;
       byte wLength_h;
}tUSB_Setup;



/* Prototypes */
void USB_Init(void);
void EP1_Load(void);


#endif /* __USBHandler__ */