#ifndef __USB_Desc__
#define __USB_Desc__

/* Includes */
#include "derivative.h"


/********************************************************************
*********************************************************************
*       ICP Device Descriptor
*********************************************************************
********************************************************************/
const byte Device_Descriptor[18]= 
{
	0x12,		//blength
	0x01,		//bDescriptor
	0x00,0x02,  //bcdUSB ver R=2.00 
	0x00,		//bDeviceClass
	0x00,		//bDeviceSubClass			
	0x00,		//bDeviceProtocol			
	0x10,		//bMaxPacketSize0
	0xA2,0x15,	//idVendor - 0x15A2(freescale Vendor ID)
	0x37,0x00,	//idProduct
	0x00,0x01,	//bcdDevice - Version 1.00
	0x01,		//iManufacturer - Index to string descriptor
	0x02,		//iProduct - Index to string descriptor
	0x00,		//iSerialNumber - Index to string descriptor
	0x01	    //bNumConfigurations - # of config. at current speed,
};




/********************************************************************
*********************************************************************
*       ICP Configuration Descriptor
*********************************************************************
********************************************************************/
const byte Configuration_Descriptor[32]= 
{
	0x09,		  //blength
	0x02,		  //bDescriptor
	0x20,0x00,	  //wTotalLength - # of bytes including interface and endpoint descpt.
	0x01,		  //bNumInterfaces - at least 1 data interface
	0x01,		  //bConfigurationValue - 
	0x00,		  //iConfiguration - index to string descriptor	
	0x80,		  //bmAttributes - 0x?0	bit 7-bus powered
				  //						        bit 6-self powered
				  //						        bit 5-remote wakeup
				  //						        bit 4-0-reserved
	0x64,		  //bMaxPower - 200mA
	
// ======================================================
// 		Standard Interface Descriptor
// ======================================================

	0x09,	      //blength
	0x04,		  //bDescriptorType - Interface descriptor
	0x00,		  //bInterfaceNumber - Zero based value identifying the index of the config.
	0x00,		  //bAlternateSetting;
	0x02,		  //bNumEndpoints - 2 endpoints
	0x08,		  //bInterfaceClass - mass storage 
	0x06,		  //bInterfaceSubClass - SCSI Transparent command Set
	0x50,		  //bInterfaceProtocol - Bulk-Only transport
	0x00,		  //iInterface - Index to String descriptor
	
// ======================================================
// 		Standard Endpoint Descriptor
//    	Bulk IN Endpoint
// ======================================================
	0x07,		  //bLength;
	0x05,		  //bDescriptorType - Endpoint descriptor
	0x81,		  //bEndpointAddress - bit 3..0 endpoint number
				  // 					         bit 6..4 Reserved reset to zero
				  //					         bit 7	0-OUT, 1-IN									
	0x02,		  //bmAttributes _ Bulk endpoint
	0x40,0x00,	  //wMaxPacketSize - 64 byte packet size
	0x00,		  //bInterval - do not apply to BULK endpoint
	
// ======================================================
// 		Standard Endpoint Descriptor
//    	Bulk OUT Endpoint
// ======================================================
	0x07,		   //bLength;
	0x05,		   //bDescriptorType - Endpoint descriptor
	0x02,		   //bEndpointAddress - bit 3..0 endpoint number
				   // 					         bit 6..4 Reserved reset to zero
				   //					         bit 7	0-OUT, 1-IN									
	0x02,		   //bmAttributes _ Bulk endpoint
	0x40,0x00,	   //wMaxPacketSize - 64 byte packet size
	0x00,		   //bInterval - do not apply to BULK endpoint	
 
};



// ======================================================
//
// 		String Descriptor Zero
//
// ======================================================
const byte String_Descriptor0[4] = 
{
	0x04,		   //bLength;
	0x03,		   //bDescriptorType - STRING descriptor
	0x09,0x04,	   //wLANDID0 - English (American)
};

// ======================================================
//
// 		String Descriptor one
//
// ======================================================
const byte String_Descriptor1[] = 
{
	0x14,			    //bLength; 11 bytes
	0x03,		      //bDescriptorType - STRING descriptor
	'F',0x00,	    // "F"
	'r',0x00,	    // "r"
	'e',0x00,	    // "e"
	'e',0x00,	    // "e"
	's',0x00,	    // "s"
	'c',0x00,	    // "c"
	'a',0x00,	    // "a"
	'l',0x00,	    // "l"
	'e',0x00,	    // "e"
};	 


// ======================================================
//
// 		String Descriptor two
//
// ======================================================
const byte String_Descriptor2[] = 
{
	0x0A,			    //bLength;
	0x03,		      //bDescriptorType - STRING descriptor
	'J',0x00,	    // JM60
	'M',0x00,	
	'6',0x00,	
	'0',0x00,
};	 


const byte* String_Table[3] = 
{
		String_Descriptor0,					// String #0
		String_Descriptor1,					// String #1
		String_Descriptor2					// String #2
};		



#endif /* __USB_Desc__ */