#ifndef __SCSI_Process__
#define __SCSI_Process__

/* Includes */
#include "derivative.h"
#include "FslTypes.h"
#include "USB_Handle.h"
#include "SPI.h"
#include "SD.h"




// ======================================================
//
// 		USB Command Block Wrapper CBW Command
//
// ======================================================

#define kCBWSignature0			0		  // dCBWSignature byte 0 position
#define kCBWSignature1			1		  // dCBWSignature byte 1 position
#define kCBWSignature2			2		  // dCBWSignature byte 2 position
#define kCBWSignature3			3		  // dCBWSignature byte 3 position
#define kCBWTag0				    4		  // dgUSBMSCBWTage byte 0 position
#define kCBWTag1				    5		  // dgUSBMSCBWTage byte 0 position
#define kCBWTag2				    6		  // dgUSBMSCBWTage byte 0 position
#define kCBWTag3				    7		  // dgUSBMSCBWTage byte 0 position
#define kCBWXferLength0			8		  // dCBWDataTransferLength byte 0 position
#define kCBWXferLength1			9		  // dCBWDataTransferLength byte 1 position
#define kCBWXferLength2			10		// dCBWDataTransferLength byte 2 position
#define kCBWXferLength3			11		// dCBWDataTransferLength byte 3 position
#define kCBWFlags				    12		// bmCBWFlags byte position
#define kCBWDirection			  0x80	// direction
#define kHost2Device			  0		  // 0-host to device, 1-device to host
#define kCBWLUN					    13		// bCBWLUN byte position
#define kCBWCBLength			  14		// bCBWCBLength byte position
#define kCBWSCSICommand			15		// CBWCB byte position

#define	kSCSI10LBAByte3			17		// LBA byte 3
#define kSCSI10LBAByte2			18		// LBA byte 2
#define kSCSI10LBAByte1			19		// LBA byte 1
#define kSCSI10LBAByte0			20		// LBA byte 0
#define kSCSI10XferLength1	22		// Transfer Length byte 1
#define kSCSI10XferLength0	23		// Transfer Length byte 0


#define	kCSWPass				    0		  // command completed successfully
#define	kCSWFailed				  1		  // command failed



/* Prototypes */
void SCSI_Init(void);
byte SD_ReadCSD(void);
void SCSI_MemoryInfo(void);
void Send_CSW(void);
void SCSIList00(void);
void SCSIList03(void); 
void SCSIList12(void); 
void SCSIList1A(void);
void SCSIList23(void);
void SCSIList25(void); 
void SCSIList28(void);
void SCSIList2A(void);
void SCSI_NotSupport(void);
void SCSI_Process(void);

#endif /* __SCSI_Process__ */