/*
 * Copyright (c) 2015, Freescale Semiconductor, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * o Redistributions of source code must retain the above copyright notice, this list
 *   of conditions and the following disclaimer.
 *
 * o Redistributions in binary form must reproduce the above copyright notice, this
 *   list of conditions and the following disclaimer in the documentation and/or
 *   other materials provided with the distribution.
 *
 * o Neither the name of Freescale Semiconductor, Inc. nor the names of its
 *   contributors may be used to endorse or promote products derived from this
 *   software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "fsl_common.h"
#include "fsl_iocon.h"
#include "fsl_gpio.h"
#include "pin_mux.h"

/*****************************************************************************
 * Private types/enumerations/variables
 ****************************************************************************/



#ifndef BOARD_USECLKINSRC
#define BOARD_USECLKINSRC   (0)
#endif

/*****************************************************************************
 * Public types/enumerations/variables
 ****************************************************************************/
 
/*****************************************************************************
 * Local Prototypes
 ****************************************************************************/


 /*****************************************************************************
 * Private functions
 ****************************************************************************/
static void ConfigureConsolePort(void)
{
    /* UART0 RX/TX pins */
    IOCON_PinMuxSet(IOCON, 0, 8, IOCON_MODE_INACT | IOCON_FUNC2 | IOCON_DIGITAL_EN);
    IOCON_PinMuxSet(IOCON, 0, 9, IOCON_MODE_INACT | IOCON_FUNC2 | IOCON_DIGITAL_EN);
}

static void ConfigureDebugPort(void)
{
    /* SWD SWCLK/SWDIO pins */
    IOCON_PinMuxSet(IOCON, 0, 12, IOCON_FUNC2 | IOCON_MODE_INACT | IOCON_DIGITAL_EN);
    IOCON_PinMuxSet(IOCON, 0, 13, IOCON_FUNC2 | IOCON_MODE_INACT | IOCON_DIGITAL_EN);
#ifdef ENABLE_DEBUG_PORT_SWO
    /* SWD SWO pin (optional) */
    IOCON_PinMuxSet(IOCON, 0, 14, IOCON_FUNC5 | IOCON_MODE_INACT | IOCON_DIGITAL_EN);
    SYSCON->TRACECLKDIV = 0; /* Clear HALT bit */
#endif
}



/*******************************************************************************
 * Code
 ******************************************************************************/
void BOARD_InitPins(void)
{
	/* Enable IOCON clock */
    CLOCK_EnableClock(kCLOCK_Iocon);
	CLOCK_EnableClock(kCLOCK_InputMux);

    /* Console signals */
    ConfigureConsolePort();

    /* Debugger signals */
    ConfigureDebugPort();


    /* Antenna Diversity Output */
#ifdef ANTENNA_DIVERSITY
    IOCON_PinMuxSet(IOCON, 0, 6,
                      IOCON_FUNC7 | IOCON_DIGITAL_EN | IOCON_INPFILT_OFF);  /* ADE for antenna diversity */
    IOCON_PinMuxSet(IOCON, 0, 7,
                      IOCON_FUNC7 | IOCON_DIGITAL_EN | IOCON_INPFILT_OFF);  /* ADO for antenna diversity */
#endif

    /* I2C0  */
    IOCON_PinMuxSet(IOCON, 0, 10,
                    IOCON_FUNC5 | IOCON_DIGITAL_EN | IOCON_INPFILT_OFF);  /* I2C0_SCL */
    IOCON_PinMuxSet(IOCON, 0, 11,
                    IOCON_FUNC5 | IOCON_DIGITAL_EN | IOCON_INPFILT_OFF);  /* I2C0_SDA */

    /* I2C1  */
    //IOCON_PinMuxSet(IOCON, 0, 6,
    //                IOCON_FUNC5 | IOCON_DIGITAL_EN | IOCON_INPFILT_OFF | IOCON_OPENDRAIN_EN);  /* I2C1_SCL */
    //IOCON_PinMuxSet(IOCON, 0, 7,
    //                IOCON_FUNC5 | IOCON_DIGITAL_EN | IOCON_INPFILT_OFF | IOCON_OPENDRAIN_EN);  /* I2C1_SDA */

	/* IOCON clock left on, this is needed if CLKIN is used. */
	/* Initialize GPIO */
	CLOCK_EnableClock(kCLOCK_Spi0);
	CLOCK_EnableClock(kCLOCK_Spi1);
	CLOCK_EnableClock(kCLOCK_Gpio0);
	RESET_PeripheralReset(kGPIO0_RST_SHIFT_RSTn);


}
