/*******************************************************************************
*
* Copyright 2004-2016, Freescale Semiconductor, Inc.
* Copyright 2016-2019 NXP
* All rights reserved.
*
********************************************************************************
*
* File Name: main.c
*
* Description: Main application file generated automatically from the 
*              DSP56800E_Quick_Start stationery
*
* Target: MC56F83789 device
*
*******************************************************************************/

/* required DSP56F800E_Quick_Start header */
#include "qs.h"

/* low-level driver headers for each module used */
#include "occs.h"
#include "sys.h"
#include "adc12.h"
#include "cop.h"
#include "crc.h"
#include "dac.h"
#include "dma.h"
#include "fcan.h"
#include "ftfe.h"
#include "gpio.h"
#include "hscmp.h"
#include "iic.h"
#include "intc.h"
#include "intctarget.h"
#include "mcm.h"
#include "pmc.h"
#include "pwm.h"
#include "pit.h"
#include "qtimer.h"
#include "sci.h"
#include "scihl.h"
#include "spi.h"
#include "xbar.h"
#include "freemaster.h"

#include "m1_sm_snsless.h"
#include "mcdrv.h"

/*******************************************************************************
 * Variables
 ******************************************************************************/
/* alternate LEDs, each may be on a separate port */
#define GPIO_LED_R2 GPIO_F
#define LED_R2      BIT_8

#define GPIO_LED_G2 GPIO_F
#define LED_G2      BIT_9

#define GPIO_BTN_3  GPIO_F		//SW3
#define BTN_3       BIT_1
/*******************************************************************************
 * Variables
 ******************************************************************************/
/* Demo mode enabled/disabled */
bool_t bDemoMode = FALSE;

/* Used for demo mode */
static uint32_t ui32SpeedStimulatorCnt = 0;

/* Counter for button pressing */
static uint32_t ui32ButtonFilter = 0;
/* Application and board ID  */
app_ver_t   g_sAppId = {
    "evk-mc56f83000",   /* board id */
    "pmsm",             /* motor type */
    MCRSP_VER,          /* sw version */
};
/* Structure used in FM to get required ID's */
app_ver_t   g_sAppIdFM;

/*******************************************************************************
 * Prototypes
 ******************************************************************************/
void McuInit(void);
void DemoSpeedStimulator(void);

/*
 * The main function is invoked from the startup code after 
 * key device resources (PLL, memory) are initialised.
 *
 */
void main (void) 
{
    /* Disable interrupts */
    archDisableInt();
   	
    /* Peripheral initialization */
    McuInit();
    
    /* Initializes  */
    MCDRV_Init_M1();
    
    /* Initializes the FreeMASTER Communication */
    FMSTR_Init();

    /* Pass actual demo id and board info to FM */
    g_sAppIdFM = g_sAppId;     
	
	/* Disable demo mode after reset */
    bDemoMode = FALSE;
    ui32SpeedStimulatorCnt = 0;
	
	/* Turn off application */
    M1_SetAppSwitch(0);

    /* Enable interrupts */
    archEnableInt();

    while(1)
    {
		/* The FreeMASTER polling method */
		FMSTR_Poll();
		/* Feed the watchdog periodically */
		ioctl(COP, COP_CLEAR_COUNTER, NULL);
    }
}


/*!
*
* @brief   ADC End of scan ISR
*           - call main state machine
*           - FreeMaster Recorder call
*           - clear ISR flag        
*
* @param   None
*
* @return  None
*
*/
#pragma interrupt saveall
void ADC_EOS_isr(void)
{
	/* StateMachine call */
    SM_StateMachineFast(&g_sM1Ctrl); 
        
    /* Initializes the FreeMASTER Communication */
    FMSTR_Recorder();
    
    /* Clear status register PWM submodule 0 compare flag bit */
    ioctl(ADC, ADC_CLEAR_STATUS_EOSI, ADC_CONVERTER_0 | ADC_CONVERTER_1);
    
}
#pragma interrupt off

/*!
*
* @brief   PIT ISR
*           - call slow loop state machine
*           - call Demo mode and control LED       
*
* @param   None
*
* @return  None
*
*/
#pragma interrupt saveall
void PIT_ISR(void)
{  	
	static int16_t ui16i = 0;
	
	/* M1 Slow StateMachine call */
    SM_StateMachineSlow(&g_sM1Ctrl);
    
    /* If in STOP state turn on red */
	if (M1_GetAppState() == 2)
	{
		/* RED LED - ON, GREEN LED OFF */
		ioctl(GPIO_LED_R2, GPIO_CLEAR_PIN, LED_R2);
		ioctl(GPIO_LED_G2, GPIO_SET_PIN, LED_G2);
	}

	/* If in FAULT state red blinking*/
	else if (M1_GetAppState() == 0)
	{
		if (ui16i-- < 0)
		{
			/* toggle red LED */
			ioctl(GPIO_LED_R2, GPIO_TOGGLE_PIN, LED_R2);
			ui16i = 125;
		}
		/* LED GREEN OFF */
		ioctl(GPIO_LED_G2, GPIO_SET_PIN, LED_G2);
	}

	/* If in RUN or INIT state turn on green */
	else
	{
		/* RED LED - OFF, GREEN LED ON */
		ioctl(GPIO_LED_R2, GPIO_SET_PIN, LED_R2);
		ioctl(GPIO_LED_G2, GPIO_CLEAR_PIN, LED_G2);
	}

	/* Demo speed stimulator */
	DemoSpeedStimulator();

    /* Clear status register PWM submodule 0 compare flag bit */
	ioctl(PIT_0, PIT_CLEAR_ROLLOVER_INT, NULL);
	 	
}
#pragma interrupt off

/*!
*
* @brief   Peripheral Init function calling       
*
* @param   None
*
* @return  None
*
*/
void McuInit()
{
    /* Initialize peripheral modules */
    ioctl(SYS, SYS_INIT, NULL);
    ioctl(COP, COP_INIT, NULL);
    ioctl(GPIO, GPIO_INIT_ALL, NULL);
    ioctl(SCI_0,SCI_INIT,NULL);
    ioctl(INTC, INTC_INIT, NULL);
    ioctl(XBAR_A,XBAR_A_INIT,NULL);
    ioctl(EFPWMA,EFPWM_INIT,NULL);
    ioctl(ADC,ADC_INIT,NULL);
    ioctl(PIT_0,PIT_INIT,NULL);
    ioctl(HSCMP_C,HSCMP_INIT,NULL);      

    /* Clear PWM fault flag */
    ioctl(EFPWMA,EFPWM_CLEAR_FAULT_FLAGS,EFPWM_FAULT_0 | EFPWM_FAULT_1 | EFPWM_FAULT_2 | EFPWM_FAULT_3);
}


/*!
* @brief   Port interrupt handler
*
* @param   void
*
* @return  none
*/
#pragma interrupt saveall
void GPIO_F_ISR(void)
{
	/* clear interrupt flags */
	ioctl(GPIO_BTN_3, GPIO_CLEAR_INT_PENDING, BTN_3);

	/* Proceed only if pressing longer than timeout */
	if (ui32ButtonFilter > 200)
	{
		ui32ButtonFilter = 0;
		if (bDemoMode)
		{
			M1_SetSpeed(0);
			M1_SetAppSwitch(FALSE);
			bDemoMode = FALSE;
		}
		else
		{
			M1_SetAppSwitch(TRUE);
			bDemoMode = TRUE;
			ui32SpeedStimulatorCnt = 0;
		}
	}
   
}
#pragma interrupt off

/*!
* @brief   DemoSpeedStimulator
*           - When demo mode is enabled it changes the required speed according
*             to predefined profile
*
* @param   void
*
* @return  none
*/
void DemoSpeedStimulator(void)
{
    /* Increment push button pressing counter  */
    if (ui32ButtonFilter < 1000)
        ui32ButtonFilter++;

    if (bDemoMode)
    {
        ui32SpeedStimulatorCnt++;
        switch (ui32SpeedStimulatorCnt)
        {
            case 100:
                M1_SetSpeed(FRAC16(1000.0 / M1_N_MAX));
                break;
            case 3000:
                M1_SetSpeed(FRAC16(2000.0 / M1_N_MAX));
                break;
            case 6000:
                M1_SetSpeed(FRAC16(4000.0 / M1_N_MAX));
                break;
            case 9000:
                M1_SetSpeed(FRAC16(900.0 / M1_N_MAX));
                break;
            case 12000:
                M1_SetSpeed(FRAC16(4000.0 / M1_N_MAX));
                break;
            case 15000:
                M1_SetSpeed(FRAC16(2000.0 / M1_N_MAX));
                break;
            case 18000:
                M1_SetSpeed(FRAC16(800.0 / M1_N_MAX));
                ui32SpeedStimulatorCnt = 0;
                break;
            default:
                break;
        }
    }
}
