/*******************************************************************************
*
* Copyright 2004-2016, Freescale Semiconductor, Inc.
* Copyright 2016-2019 NXP
* All rights reserved.
*
********************************************************************************
*
* File Name: main.c
*
* Description: Main application file generated automatically from the 
*              DSP56800E_Quick_Start stationery
*
* Target: MC56F84789 device
*
*******************************************************************************/

/* required DSP56F800E_Quick_Start header */
#include "qs.h"

/* low-level driver headers for each module used */
#include "occs.h"
#include "sys.h"
#include "adc12.h"
#include "cop.h"
#include "crc.h"
#include "dac.h"
#include "dma.h"
#include "fcan.h"
#include "ftfe.h"
#include "gpio.h"
#include "hscmp.h"
#include "iic.h"
#include "intc.h"
#include "intctarget.h"
#include "mcm.h"
#include "pmc.h"
#include "pwm.h"
#include "pit.h"
#include "qtimer.h"
#include "sci.h"
#include "scihl.h"
#include "spi.h"
#include "xbar.h"
#include "freemaster.h"

#include "m1_sm_snsless.h"
#include "mcdrv_hvp56f83783.h"

/*******************************************************************************
 * Variables
 ******************************************************************************/
/* Application and board ID  */
app_ver_t   g_sAppId = {
    "hvp-56f83783",     /* board id */
    "pmsm",             /* motor type */
    MCRSP_VER,          /* sw version */
};
/* Structure used in FM to get required ID's */
app_ver_t   g_sAppIdFM;

/*******************************************************************************
 * Prototypes
 ******************************************************************************/
void McuInit(void);


/*
 * The main function is invoked from the startup code after 
 * key device resources (PLL, memory) are initialised.
 *
 */

void main (void) 
{
    /* Disable interrupts */
    archDisableInt();
   	
    /* Peripheral initialization */
    McuInit();
    
    /* Turn on the HVP inrush relay for 1s */
    InitRelay();
    
    /* Initializes  */
    MCDRV_Init_M1();
    
    /* Initializes the FreeMASTER Communication */
    FMSTR_Init();

    /* Pass actual demo id and board info to FM */
    g_sAppIdFM = g_sAppId;     

    /* Enable interrupts */
    archEnableInt();

    while(1)
    {
		/* The FreeMASTER polling method */
		FMSTR_Poll();
		/* Feed the watchdog periodically */
		ioctl(COP, COP_CLEAR_COUNTER, NULL);

    }
}


/*!
*
* @brief   ADC End of scan ISR
*           - call main state machine
*           - FreeMaster Recorder call
*           - clear ISR flag        
*
* @param   None
*
* @return  None
*
*/
#pragma interrupt saveall
void ADC_EOS_isr(void)
{
	//ioctl(GPIO_F, GPIO_SET_PIN, BIT_2);  
	
	/* StateMachine call */
    SM_StateMachineFast(&g_sM1Ctrl); 
        
    /* Initializes the FreeMASTER Communication */
    FMSTR_Recorder();
    
    /* Clear status register PWM submodule 0 compare flag bit */
    ioctl(ADC, ADC_CLEAR_STATUS_EOSI, ADC_CONVERTER_0 | ADC_CONVERTER_1);
    
	//ioctl(GPIO_F, GPIO_CLEAR_PIN, BIT_2);     
}
#pragma interrupt off

#pragma interrupt saveall
void PIT_ISR(void)
{
	ioctl(GPIO_F, GPIO_SET_PIN, BIT_2);  	
	
	/* M1 Slow StateMachine call */
    SM_StateMachineSlow(&g_sM1Ctrl);

    /* Clear status register PWM submodule 0 compare flag bit */
	ioctl(PIT_0, PIT_CLEAR_ROLLOVER_INT, NULL);
	
	ioctl(GPIO_F, GPIO_CLEAR_PIN, BIT_2);  	
}
#pragma interrupt off

/*!
*
* @brief   Peripheral Init function calling       
*
* @param   None
*
* @return  None
*
*/
void McuInit()
{
    /* Initialize peripheral modules */
    ioctl(SYS, SYS_INIT, NULL);
    ioctl(COP, COP_INIT, NULL);
    ioctl(GPIO, GPIO_INIT_ALL, NULL);
    ioctl(SCI_0,SCI_INIT,NULL);
    ioctl(INTC, INTC_INIT, NULL);
    ioctl(XBAR_A,XBAR_A_INIT,NULL);
    ioctl(EFPWMA,EFPWM_INIT,NULL);
    ioctl(ADC,ADC_INIT,NULL);
    ioctl(PIT_0,PIT_INIT,NULL);
    ioctl(HSCMP_C,HSCMP_INIT,NULL);        

    /* Clear PWM fault flag */
    ioctl(EFPWMA,EFPWM_CLEAR_FAULT_FLAGS,EFPWM_FAULT_0 | EFPWM_FAULT_1 | EFPWM_FAULT_2 | EFPWM_FAULT_3);
}
