/*
 * Copyright 2016, Freescale Semiconductor, Inc.
 * Copyright 2016-2019 NXP
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#include "mcdrv_pwm3ph_pwma.h"

/*******************************************************************************
 * Definitions
 ******************************************************************************/

/*******************************************************************************
 * Variables
 ******************************************************************************/

static bool_t s_statusPass;

/*******************************************************************************
 * Code
 ******************************************************************************/

/*!
 * @brief Function updates FTM value register
 *
 * @param this   Pointer to the current object
 *
 * @return boot_t true on success
 */
bool_t MCDRV_eFlexPwm3PhSet(mcdrv_pwma_pwm3ph_t *this)
{
    frac16_t f16DutyCycle, f16DutyCycleTemp, f16ModuloTemp;
    GMCLIB_3COOR_T_F16 sUABCtemp;

    s_statusPass = TRUE;

    /* pointer to duty cycle structure */
    sUABCtemp = *this->psUABC;

    /* get modulo value from module 0 VAL1 register  */
    f16ModuloTemp = this->pui32PwmBaseAddress->Sub0.smval1 + 1;

    /* phase A */
    f16DutyCycle = MLIB_Mul_F16(f16ModuloTemp, sUABCtemp.f16A);
    f16DutyCycleTemp = MLIB_Neg_F16(f16DutyCycle);
    this->pui32PwmBaseAddress->Sub0.smval2 = f16DutyCycleTemp;
    this->pui32PwmBaseAddress->Sub0.smval3 = f16DutyCycle;

    /* phase B */
    f16DutyCycle = MLIB_Mul_F16(f16ModuloTemp, sUABCtemp.f16B);
    f16DutyCycleTemp = MLIB_Neg_F16(f16DutyCycle);
    this->pui32PwmBaseAddress->Sub1.smval2 = f16DutyCycleTemp;
    this->pui32PwmBaseAddress->Sub1.smval3 = f16DutyCycle;

    /* phase C */
    f16DutyCycle = MLIB_Mul_F16(f16ModuloTemp, sUABCtemp.f16C);
    f16DutyCycleTemp = MLIB_Neg_F16(f16DutyCycle);
    this->pui32PwmBaseAddress->Sub2.smval2 = f16DutyCycleTemp;
    this->pui32PwmBaseAddress->Sub2.smval3 = f16DutyCycle;

    /* set LDOK bits */
    this->pui32PwmBaseAddress->mctrl |= EFPWM_MCTRL_LDOK_MASK;

    return (s_statusPass);
}

/*!
 * @brief Function enables PWM outputs
 *
 * @param this   Pointer to the current object
 *
 * @return boot_t true on success
 */
bool_t MCDRV_eFlexPwm3PhOutEn(mcdrv_pwma_pwm3ph_t *this)
{
	uint16_t ui16MaskTemp;
	
	s_statusPass = TRUE;
    
    ui16MaskTemp = (1U << (this->ui16PhASubNum))|(1U << (this->ui16PhBSubNum))|(1U << (this->ui16PhCSubNum));
    /* PWM outputs of sub-modules */
    /* PWM_A output, shifted 8 times left (0xF00) */
    this->pui32PwmBaseAddress->outen =
        (this->pui32PwmBaseAddress->outen | ((uint16_t)((ui16MaskTemp << 8U) & EFPWM_OUTEN_PWMA_EN_MASK)));

    /* PWM_B output, shifted 4 times left (0x0F0) */
    this->pui32PwmBaseAddress->outen =
        (this->pui32PwmBaseAddress->outen | ((uint16_t)((ui16MaskTemp << 4U) & EFPWM_OUTEN_PWMB_EN_MASK)));

    return (s_statusPass);
}

/*!
 * @brief Function disables PWM outputs
 *
 * @param this   Pointer to the current object
 *
 * @return boot_t true on success
 */
bool_t MCDRV_eFlexPwm3PhOutDis(mcdrv_pwma_pwm3ph_t *this)
{
    uint16_t ui16MaskTemp;
    
    s_statusPass = TRUE;

    ui16MaskTemp = ((1U << (this->ui16PhASubNum))|(1U << (this->ui16PhBSubNum))|(1U << (this->ui16PhCSubNum))); 
    
    /* PWM outputs of used PWM sub-modules disabled */
    /* PWM_A output, shifted 8 times left (0xF00) */
    this->pui32PwmBaseAddress->outen = 
        (this->pui32PwmBaseAddress->outen & ~((uint16_t)((ui16MaskTemp << 8U) & EFPWM_OUTEN_PWMA_EN_MASK)));

    /* PWM_B output, shifted 4 times left (0x0F0) */
    this->pui32PwmBaseAddress->outen =
        (this->pui32PwmBaseAddress->outen & ~((uint16_t)((ui16MaskTemp << 4U) & EFPWM_OUTEN_PWMB_EN_MASK)));

    return (s_statusPass);
}

/*!
 * @brief Function return actual value of over current flag
 *
 * @param this   Pointer to the current object
 *
 * @return boot_t true on success
 */
bool_t MCDRV_eFlexPwm3PhFltGet(mcdrv_pwma_pwm3ph_t *this)
{
    /* read over-current flags */
    s_statusPass = (((this->pui32PwmBaseAddress->fsts & EFPWM_FSTS_FFLAG_MASK) >> 0) &
    		(1 << this->ui16FaultFixNum | 1 << this->ui16FaultAdjNum));

    /* clear faults flag */
    this->pui32PwmBaseAddress->fsts = ((this->pui32PwmBaseAddress->fsts & ~(EFPWM_FSTS_FFLAG_MASK)) |
                                       (1 << this->ui16FaultFixNum | 1 << this->ui16FaultAdjNum));

    return ((s_statusPass > 0));
}

