/*******************************************************************************
*
* File Name: appconfig.h
*
* Description: file for static configuration of the application
*              (initial values, interrupt vectors)
*
*****************************************************************************/

#ifndef __APPCONFIG_H
#define __APPCONFIG_H

/*.*************************************************************************
*
*  File generated by Graphical Configuration Tool Fri, 17/Jan/2020, 14:44:27
*
****************************************************************************.*/

#define MC56F83783
#define EXTCLK 8000000L
#define APPCFG_DFLTS_OMITTED 1
#define APPCFG_GCT_VERSION 0x0207000bL

/*.
    OCCS Configuration
--------------------------------------------
    Enable internal 200 kHz oscillator: No 
    Power Down crystal oscillator: Yes
    Core frequency: 100 MHz 
    VCO frequency: 400 MHz 
    Loss of lock interrupt 0: Disable 
    Loss of lock interrupt 1: Disable 
    Loss of reference clock Interrupt: Disable
.*/
#define OCCS_CTRL_INIT                    0x0081U
#define OCCS_DIVBY_INIT                   0x2031U

/*.
    COP Configuration
--------------------------------------------
    COP clock source: 8MHz clock from 48MHz/6 
    COP operation: Disable
    COP timeout: 8.38848 sec 
    COP Runs in Stop Mode: No 
    COP Runs in Wait Mode: No 
    COP Write Protect: No 
    Enable Loss of Clock COP: No 
    Enable COP Warning Interrupt: No 
    COP Warning Interrupt Timeout: 32.64 ms 
    COP Window Timeout: 8.38848 sec
.*/
#define COP_COPCTL_INIT                   0x0300U

/*.
    SYS Configuration
--------------------------------------------
    SIM: Power Saving Modes: Stop enabled 
    Wait enabled 
         OnCE clock to processor core: Enabled when core TAP enabled 
    DMA Enable in RUN and WAIT modes: DMA enabled in all power modes 
    Enable External Reset Input Filter : No , SIM - Clock on GPIO: Enable CLKO_0: No 
    SIM - Clock on GPIO: Enable CLKO_1: No 
    SIM - Peripheral Clock Enable: GPIO G: Yes, GPIO F: Yes, GPIO E: Yes, GPIO D: No , GPIO C: Yes, GPIO B: Yes, GPIO A: Yes, TMR A0: No 
                                   TMR A1: No , TMR A2: No , TMR A3: No , TMR B0: No , TMR B1: No , TMR B2: No , TMR B3: No , DAC_A: No 
                                   DAC_B: No 
                                   SCI_0: Yes, SCI_1: Yes, SCI_2: No , QSPI_0: No , QSPI_1: No , IIC_0: No , IIC_1: No , FLEXCAN: No 
                                   CMP A: No , CMP B: No , CMP C: Yes, CMP D: No , CYC ADC: Yes, CRC: No , PIT_0: Yes, PIT_1: No , PWMA_SM0: Yes, PWMA_SM1: Yes, PWMA_SM2: Yes, PWMA_SM3: No 
                                   PWMB_SM0: No , PWMB_SM1: No , PWMB_SM2: No , PWMB_SM3: No , ROM: Yes, SIM - Modules Enabled in Stop: GPIO G: No 
    SIM - Modules Enabled in Stop: GPIO F: No , GPIO E: No , GPIO D: No , GPIO C: No , GPIO B: No , GPIO A: No 
                                   TMR A0: No , TMR A1: No , TMR A2: No , TMR A3: No , TMR B0: No , TMR B1: No , TMR B2: No , TMR B3: No , DAC_A: No 
                                   DAC_B: No 
                                   SCI_0: No , SCI_1: No , SCI_2: No , QSPI_0: No , QSPI_1: No , IIC_0: No , IIC_1: No , FLEXCAN: No 
                                   CMP A: No , CMP B: No , CMP C: No , CMP D: No , CYC ADC: No , CRC: No , PIT_0: No , PIT_1: No , PWMA_SM0: No , PWMA_SM1: No , PWMA_SM2: No , PWMA_SM3: No 
                                   PWMB_SM0: No , PWMB_SM1: No , PWMB_SM2: No , PWMBSM3: No 
                                   ROM: No , USB: No , Protection of IPS and GPSxx  : Registers not protected 
    Protection of PCE, SD and PCR: Registers not protected 
    Protection of GPIO Port D: Registers not protected 
    Protection of PWRMODE: Registers not protected 
    GPIO Peripheral select registers (GPSn): ANA0/CMPA3 
                                             CMPC_O 
                                             ANB1/CMPB_IN0 
                                             CMPD_O 
                                             EXTAL 
                                             TXD0 
                                             RXD0 
                                             TA1 
                                             DACO 
                                             TA2 
                                             SS0_B 
                                             MISO0 
                                             SCLK0 
                                             MOSI0 
                                             CANTX 
                                             CANRX 
                                             TA3 
                                             SDA0 
                                             SCL0 
                                             RXD2 
                                             TXD2 
                                             XB_OUT11 
                                             PWMA_0B 
                                             PWMA_0A 
                                             PWMA_1B 
                                             PWMA_1A 
                                             PWMA_2B 
                                             PWMA_2A 
                                             PWMA_3B 
                                             PWMA_3A 
                                             PWMB_2B 
                                             PWMB_2A 
                                             XB_IN6 
                                             CLKO_1 
                                             SCL1 
                                             SDA1 
                                             TXD1 
                                             RXD1 
                                             TB2 
                                             TB3 
                                             RXD0 
                                             RXD2 
                                             TXD2 
                                             TXD0 
                                             MISO1 
                                             MOSI1 
                                             SCLK1 
                                             RXD0 
                                             PWM1B 
                                             PWM1A 
                                             PWM0B 
                                             PWM0A 
                                             PWM3B 
                                             PWM3A 
                                             PWMA_FAULT4 
                                             PWMA_FAULT5 
                                             PWMB_0X 
                                             PWMB_1X 
                                             PWMB_2X 
                                             TB3 
    Internal Peripheral Select Register 0 (IPS0): GPIO C3 
                                                  GPIO C4 
                                                  GPIO C6/G8 
                                                  GPIO C13/G9 
                                                  GPIO C2 
                                                  GPIO F8 
                                                  GPIO F6/F0/G6 
                                                  GPIO F7/G11 
                                                  XB_OUT29 
                                                  XB_OUT30 
                                                  FAULT2 input pin (GPIO G4) 
                                                  FAULT3 input pin (GPIO G5) 
                                                  FAULT0 input pin (GPIO F14) 
                                                  FAULT1 input pin (GPIO F13) 
                                                  FAULT2 input pin (GPIO F12) 
    Miscellaneous Register 0 (SIM_MISC0): CLKIN0 (GPIOC0 alt1) 
                                          PIT0 master, PIT1 slave 
                                          Normal Order 
                                          Enable 
    SIM - Interrupts: Low voltage 2.2V: Disable
                      Low voltage 2.7V: Disable
                      High voltage 2.2V: Disable
                      High voltage 2.7V: Disable
    Enable Voltage Reference Buffer: No 
    Use Factory Trim Value: Yes
    Power Control: Large Regulator Standby mode: Normal 
                   Small Regulator 2.7 V Supply Standby mode: Normal 
                   Small Regulator 2.7 V Supply Powerdown mode: Normal 
                   Small Regulator 1.2 V Supply Standby mode: Normal 
    Xbar Input from ADC and TMRA/B (SIM_ADC_TMR_SEL): TMRB0 
                                                      TMRB1 
                                                      TMRB2 
                                                      TMRB3 
                                                      TMRA0 
                                                      TMRA1 
                                                      TMRA2 
                                                      TMRA3 
    Xbar Input from PWMA and PWMB (SIM_PWM_SEL): PWMA0 Mux Trig0 
                                                 PWMA0 Mux Trig1 
                                                 PWMA1 Mux Trig0 
                                                 PWMA1 Mux Trig1 
                                                 PWMA2 Mux Trig0 
                                                 PWMA2 Mux Trig1 
                                                 PWMA3 Mux Trig0 
                                                 PWMA3 Mux Trig1 
                                                 PWMB0 Mux Trig0 
                                                 PWMB0 Mux Trig1 
                                                 PWMB1 Mux Trig0 
                                                 PWMB1 Mux Trig1 
                                                 PWMB2 Mux Trig0 
                                                 PWMB2 Mux Trig0 
                                                 PWMB3 Mux Trig0 
                                                 PWMB3 Mux Trig1 
    Change boot flag bits (SIM_BOOT_MODE_OVERRIDE): FOPT[6,7] not masked
.*/
#define SIM_GPSCL_INIT                    0x0080U
#define SIM_PCE0_INIT                     0x0077U
#define SIM_PCE1_INIT                     0x1800U
#define SIM_PCE2_INIT                     0x0488U
#define SIM_PCE3_INIT                     0x03E0U
#define SIM_IPS0_INIT                     0x0003U
#define PMC_USE_FACTORY_TRIM              0x0001U

/*.
    INTC Configuration
--------------------------------------------
.*/
#define INTC_ICTL_INIT                    0x0000U
#define INT_VECTOR_ADDR_30                ADC_EOS_isr
#define INT_PRIORITY_LEVEL_30             INTC_LEVEL2
#define INT_VECTOR_ADDR_95                PIT_ISR
#define INT_PRIORITY_LEVEL_95             INTC_LEVEL1

/*.
    PIT_0 Configuration
--------------------------------------------
    Counter Enable: Enable 
    Clock Prescaler: / 512 
    Modulo Value: 195
    Interrupt Enable: Enable 
    Clock source: IPBus clock
.*/
#define PIT_0_CTRL_INIT                   0x004BU
#define PIT_0_MOD_INIT                    0x00C3U

/*.
    GPIO_A Configuration
--------------------------------------------
    Pin  0: Function: ANA0/CMPA_IN3 , PullUp: Disable , 
    Pin  1: Function: ANA1/CMPA_IN0 , PullUp: Disable , 
    Pin  2: Function: ANA2/VREFHA/CMPA_IN1 , PullUp: Disable , 
    Pin  3: Function: ANA3/VREFLA/CMPA_IN2 , PullUp: Disable , 
    Pin  4: Function: GPIO , Direction: Input , PullUp: Disable , Interrupt: Disable, Int.Polarity: Active high , 
    Pin  5: Function: GPIO , Direction: Input , PullUp: Disable , Interrupt: Disable, Int.Polarity: Active high , 
    Pin  6: Function: GPIO , Direction: Input , PullUp: Disable , Interrupt: Disable, Int.Polarity: Active high , 
    Pin  7: Function: GPIO , Direction: Input , PullUp: Disable , Interrupt: Disable, Int.Polarity: Active high ,
.*/
#define GPIO_A_PER_INIT                   0x000FU

/*.
    GPIO_B Configuration
--------------------------------------------
    Pin  0: Function: ANB0/CMPB_IN3 , PullUp: Disable , 
    Pin  1: Function: ANB1/CMPB_IN0 , PullUp: Disable , 
    Pin  2: Function: ANB2/VREFHB/CMPC_IN3 , PullUp: Disable , 
    Pin  3: Function: ANB3/VREFLB/CMPC_IN0 , PullUp: Disable , 
    Pin  4: Function: GPIO , Direction: Input , PullUp: Disable , Interrupt: Disable, Int.Polarity: Active high , 
    Pin  5: Function: GPIO , Direction: Input , PullUp: Disable , Interrupt: Disable, Int.Polarity: Active high , 
    Pin  6: Function: GPIO , Direction: Input , PullUp: Disable , Interrupt: Disable, Int.Polarity: Active high , 
    Pin  7: Function: ANB7/CMPB_IN2 , PullUp: Disable ,
.*/
#define GPIO_B_PER_INIT                   0x008FU

/*.
    GPIO_C Configuration
--------------------------------------------
    Pin  0: Function: GPIO , Direction: Output , Init.Value: Low - 0 , Interrupt: Disable, Int.Polarity: Active high , Output-Mode: Push-pull , 
    Pin  1: Function: GPIO , Direction: Output , Init.Value: Low - 0 , Interrupt: Disable, Int.Polarity: Active high , Output-Mode: Push-pull , 
    Pin  2: Function: TXD0 , PullUp: Disable , 
    Pin  3: Function: RXD0 , PullUp: Disable , 
    Pin  4: Function: TA1 , PullUp: Disable , 
    Pin  5: Function: GPIO , Direction: Input , PullUp: Disable , Interrupt: Disable, Int.Polarity: Active high , 
    Pin  6: Function: GPIO , Direction: Input , PullUp: Disable , Interrupt: Disable, Int.Polarity: Active high , 
    Pin  7: Function: GPIO , Direction: Output , Init.Value: Low - 0 , Interrupt: Disable, Int.Polarity: Active high , Output-Mode: Push-pull , 
    Pin  8: Function: GPIO , Direction: Input , PullUp: Disable , Interrupt: Disable, Int.Polarity: Active high , 
    Pin  9: Function: SCLK , PullUp: Disable , 
    Pin 10: Function: GPIO , Direction: Input , PullUp: Disable , Interrupt: Disable, Int.Polarity: Active high , 
    Pin 11: Function: GPIO , Direction: Input , PullUp: Disable , Interrupt: Disable, Int.Polarity: Active high , 
    Pin 12: Function: GPIO , Direction: Input , PullUp: Disable , Interrupt: Disable, Int.Polarity: Active high , 
    Pin 13: Function: GPIO , Direction: Input , PullUp: Disable , Interrupt: Disable, Int.Polarity: Active high , 
    Pin 14: Function: GPIO , Direction: Output , Init.Value: Low - 0 , Interrupt: Disable, Int.Polarity: Active high , Output-Mode: Push-pull , 
    Pin 15: Function: GPIO , Direction: Input , PullUp: Disable , Interrupt: Disable, Int.Polarity: Active high ,
.*/
#define GPIO_C_DDR_INIT                   0x4083U
#define GPIO_C_PER_INIT                   0x021CU

/*.
    GPIO_E Configuration
--------------------------------------------
    Pin  0: Function: PWMA_0B , PullUp: Disable , 
    Pin  1: Function: PWMA_0A , PullUp: Disable , 
    Pin  2: Function: PWMA_1B , PullUp: Disable , 
    Pin  3: Function: PWMA_1A , PullUp: Disable , 
    Pin  4: Function: PWMA_2B , PullUp: Disable , 
    Pin  5: Function: PWMA_2A , PullUp: Disable , 
    Pin  6: Function: GPIO , Direction: Input , PullUp: Disable , Interrupt: Disable, Int.Polarity: Active high , 
    Pin  7: Function: GPIO , Direction: Output , Init.Value: Low - 0 , Interrupt: Disable, Int.Polarity: Active high , Output-Mode: Push-pull ,
.*/
#define GPIO_E_DDR_INIT                   0x0080U
#define GPIO_E_PER_INIT                   0x003FU

/*.
    GPIO_F Configuration
--------------------------------------------
    Pin  0: Function: XB_IN6 , PullUp: Disable , 
    Pin  1: Function: GPIO , Direction: Input , PullUp: Disable , Interrupt: Disable, Int.Polarity: Active high , 
    Pin  2: Function: GPIO , Direction: Output , Init.Value: Low - 0 , Interrupt: Disable, Int.Polarity: Active high , Output-Mode: Push-pull , 
    Pin  3: Function: GPIO , Direction: Output , Init.Value: Low - 0 , Interrupt: Disable, Int.Polarity: Active high , Output-Mode: Push-pull , 
    Pin  4: Function: TXD1 , PullUp: Disable , 
    Pin  5: Function: RXD1 , PullUp: Disable , 
    Pin  6: Function: GPIO , Direction: Output , Init.Value: Low - 0 , Interrupt: Disable, Int.Polarity: Active high , Output-Mode: Push-pull , 
    Pin  7: Function: GPIO , Direction: Output , Init.Value: Low - 0 , Interrupt: Disable, Int.Polarity: Active high , Output-Mode: Push-pull , 
    Pin  8: Function: GPIO , Direction: Input , PullUp: Disable , Interrupt: Disable, Int.Polarity: Active high ,
.*/
#define GPIO_F_DDR_INIT                   0x00CCU
#define GPIO_F_PER_INIT                   0x0031U

/*.
    XBAR_A Configuration
--------------------------------------------
    0. DMARequest0.: Logic0 
    1. DMARequest1.: Logic0 
    2. DMARequest2.: Logic0 
    3. DMARequest3.: Logic0 
    4. PackagePinGPIO_C14/GPIO_E0/GPIO_G2.: Logic0 
    5. PackagePinGPIO_C15/GPIO_E1/GPIO_G3.: Logic0 
    6. PackagePinGPIO_C7/GPIO_E2/GPIO_F2/GPIO_G0.: Logic0 
    7. PackagePinGPIO_E3/GPIO_F3/GPIO_G1.: Logic0 
    8. PackagePinGPIO_C9/GPIO_D6/GPIO_E4/GPIO_E8/GPIO_F4/GPIO_G6.: Logic0 
    9. PackagePinGPIO_D5/GPIO_C10/GPIO_E5/GPIO_E9/GPIO_F5/GPIO_G7.: Logic0 
    10. PackagePinGPIO_A11/GPIO_E6/GPIO_F10/GPIO_G4/GPIO_G8.: Logic0 
    11. PackagePinGPIO_D7/GPIO_F9/GPIO_G9/GPIO_G5/GPIO_E7.: Logic0 
    12. ADCA(CyclicADC)Trigger.: PWMA0_MUX_TRIG0/PWMB0_OUT_TRIG0 
    13. ADCB(CyclicADC)Trigger.: Logic0 
    14. 12-bitDACBSYNC_IN.: Logic0 
    15. 12-bitDACASYNC_IN.: Logic0 
    16. ComparatorAWindow/Sample.: Logic0 
    17. ComparatorBWindow/Sample.: Logic0 
    18. ComparatorCWindow/Sample.: Logic0 
    19. ComparatorDWindow/Sample.: Logic0 
    20. PWMA0andPWMB0PWMControlSignalOnEXTAinput.: Logic0 
    21. PWMA1andPWMB1PWMControlSignalOnEXTAinput.: Logic0 
    22. PWMA2andPWMB2PWMControlSignalOnEXTAinput.: Logic0 
    23. PWMA3andPWMB3PWMControlSignalOnEXTAinput.: Logic0 
    24. PWMA0ExternalSynchronizationsignal.: Logic0 
    25. PWMA1ExternalSynchronizationsignal.: Logic0 
    26. PWMA2ExternalSynchronizationsignal.: Logic0 
    27. PWMA3ExternalSynchronizationsignal.: Logic0 
    28. PWMAandPWMBExternalClocksignal.: Logic0 
    29. PWMAandPWMBmoduleFAULT0.: GPIO_C13/GPIO_F0 
    30. PWMAandPWMBmoduleFAULT1.: CMPC_OUT 
    31. PWMAandPWMBmoduleFAULT2.: Logic0 
    32. PWMAandPWMBmoduleFAULT3.: Logic0 
    33. PWMAExternalOutputForcesignal.: Logic0 
    34. QuadTimerB0Input.: Logic0 
    35. QuadTimerB1Input.: Logic0 
    36. QuadTimerB2Input.: Logic0 
    37. QuadTimerB3Input.: Logic0 
    38. QuadTimerA0Input.: Logic0 
    39. QuadTimerA1Input.: Logic0 
    40. QuadTimerA2Input.: Logic0 
    41. QuadTimerA3Input.: Logic0 
    42. PWMB0ExternalSynchronizationsignal.: Logic0 
    43. PWMB1ExternalSynchronizationsignal.: Logic0 
    44. PWMB2ExternalSynchronizationsignal.: Logic0 
    45. PWMB3ExternalSynchronizationsignal.: Logic0 
    46. PWMBExternalOutputForcesignal.: Logic0 
    47. EVTG0_AInput.: Logic0 
    48. EVTG0_BInput.: Logic0 
    49. EVTG0_CInput.: Logic0 
    50. EVTG0_DInput.: Logic0 
    51. EVTG1_AInput.: Logic0 
    52. EVTG1_BInput.: Logic0 
    53. EVTG1_CInput.: Logic0 
    54. EVTG1_DInput.: Logic0 
    55. EVTG2_AInput.: Logic0 
    56. EVTG2_BInput.: Logic0 
    57. EVTG2_CInput.: Logic0 
    58. EVTG2_DInput.: Logic0 
    59. EVTG3_AInput.: Logic0 
    60. EVTG3_BInput.: Logic0 
    61. EVTG3_CInput.: Logic0 
    62. EVTG3_DInput.: Logic0 
    63. ExternalWatchdogMonitor.: Logic0 
    Edge Detection: Never 
    Enable DMA: No 
    Enable Interrupt Out0: No 
    Edge Detection: Never 
    Enable DMA: No 
    Enable Interrupt Out1: No 
    Edge Detection: Never 
    Enable DMA: No 
    Enable Interrupt Out2: No 
    Edge Detection: Never 
    Enable DMA: No 
    Enable Interrupt Out3: No
.*/
#define XBAR_A_SEL6_INIT                  0x0014U
#define XBAR_A_SEL14_INIT                 0x0600U
#define XBAR_A_SEL15_INIT                 0x000EU

/*.
    PWM_A_Common Configuration
--------------------------------------------
    Monitor PLL State: Not locked. No PLL check 
    Fault0 Level: Low 
    Fault1 Level: Low 
    Fault2 Level: Low 
    Fault3 Level: Low 
    Fault0 Clearing: Manual 
    Fault1 Clearing: Manual 
    Fault2 Clearing: Manual 
    Fault3 Clearing: Manual 
    Fault0 Safety Mode: Normal 
    Fault1 Safety Mode: Normal 
    Fault2 Safety Mode: Normal 
    Fault3 Safety Mode: Normal 
    Fault Enable Mode: Full only 
    Full only: Full only 
               Full only 
               Full only 
    PWM&FAULT path: Direct Fault 
                    Direct Fault 
                    Direct Fault 
                    Direct Fault 
    Fault Glitch Stretching: Disabled 
    Fault Filter Period: 0
    Fault Filter Count: 3 
    Fault 0 Pin: Disable
    Fault 1 Pin: Disable
    Fault 2 Pin: Disable
    Fault 3 Pin: Disable
    Submodule 0: Disable Pins PWMA by Fault: Fault 0: Yes
                 Disable Pins PWMA by Fault: Fault 1: Yes
                 Disable Pins PWMA by Fault: Fault 2: No 
                 Disable Pins PWMA by Fault: Fault 3: No 
                 Disable Pins PWMB by Fault: Fault 0: Yes
                 Disable Pins PWMB by Fault: Fault 1: Yes
                 Disable Pins PWMB by Fault: Fault 2: No 
                 Disable Pins PWMB by Fault: Fault 3: No 
                 Disable Pins PWMX by Fault: Fault 0: Yes
                 Disable Pins PWMX by Fault: Fault 1: Yes
                 Disable Pins PWMX by Fault: Fault 2: No 
                 Disable Pins PWMX by Fault: Fault 3: No 
                 Disable Pins PWMX by Fault: PWMA Fault State: Logic 0 
                 Disable Pins PWMX by Fault: PWMB Fault State: Logic 0 
                 Disable Pins PWMX by Fault: PWMX Fault State: Logic 0 
    Submodule 1: Disable Pins PWMA by Fault: Fault 0: Yes
                 Disable Pins PWMA by Fault: Fault 1: Yes
                 Disable Pins PWMA by Fault: Fault 2: No 
                 Disable Pins PWMA by Fault: Fault 3: No 
                 Disable Pins PWMB by Fault: Fault 0: Yes
                 Disable Pins PWMB by Fault: Fault 1: Yes
                 Disable Pins PWMB by Fault: Fault 2: No 
                 Disable Pins PWMB by Fault: Fault 3: No 
                 Disable Pins PWMX by Fault: Fault 0: Yes
                 Disable Pins PWMX by Fault: Fault 1: Yes
                 Disable Pins PWMX by Fault: Fault 2: No 
                 Disable Pins PWMX by Fault: Fault 3: No 
                 Disable Pins PWMX by Fault: PWMA Fault State: Logic 0 
                 Disable Pins PWMX by Fault: PWMB Fault State: Logic 0 
                 Disable Pins PWMX by Fault: PWMX Fault State: Logic 0 
    Submodule 2: Disable Pins PWMA by Fault: Fault 0: Yes
                 Disable Pins PWMA by Fault: Fault 1: Yes
                 Disable Pins PWMA by Fault: Fault 2: No 
                 Disable Pins PWMA by Fault: Fault 3: No 
                 Disable Pins PWMB by Fault: Fault 0: Yes
                 Disable Pins PWMB by Fault: Fault 1: Yes
                 Disable Pins PWMB by Fault: Fault 2: No 
                 Disable Pins PWMB by Fault: Fault 3: No 
                 Disable Pins PWMX by Fault: Fault 0: Yes
                 Disable Pins PWMX by Fault: Fault 1: Yes
                 Disable Pins PWMX by Fault: Fault 2: No 
                 Disable Pins PWMX by Fault: Fault 3: No 
                 Disable Pins PWMX by Fault: PWMA Fault State: Logic 0 
                 Disable Pins PWMX by Fault: PWMB Fault State: Logic 0 
                 Disable Pins PWMX by Fault: PWMX Fault State: Logic 0 
    Submodule 3: Disable Pins PWMA by Fault: Fault 0: Yes
                 Disable Pins PWMA by Fault: Fault 1: Yes
                 Disable Pins PWMA by Fault: Fault 2: No 
                 Disable Pins PWMA by Fault: Fault 3: No 
                 Disable Pins PWMB by Fault: Fault 0: Yes
                 Disable Pins PWMB by Fault: Fault 1: Yes
                 Disable Pins PWMB by Fault: Fault 2: No 
                 Disable Pins PWMB by Fault: Fault 3: No 
                 Disable Pins PWMX by Fault: Fault 0: Yes
                 Disable Pins PWMX by Fault: Fault 1: Yes
                 Disable Pins PWMX by Fault: Fault 2: No 
                 Disable Pins PWMX by Fault: Fault 3: No 
                 Disable Pins PWMX by Fault: PWMA Fault State: Logic 0 
                 Disable Pins PWMX by Fault: PWMB Fault State: Logic 0 
                 Disable Pins PWMX by Fault: PWMX Fault State: Logic 0
.*/
#define PWM_A_MCTRL_INIT                  0x0707U
#define PWM_A_MCTRL2_INIT                 0x0000U
#define PWM_A_OUTEN_INIT                  0x0777U
#define PWM_A_FSTS_INIT                   0x00F0U

/*.
    PWM_A_FaultCh1 Configuration
--------------------------------------------
    Fault0 Level: Low 
    Fault1 Level: Low 
    Fault2 Level: Low 
    Fault3 Level: Low 
    Fault0 Clearing: Manual 
    Fault1 Clearing: Manual 
    Fault2 Clearing: Manual 
    Fault3 Clearing: Manual 
    Fault0 Safety Mode: Normal 
    Fault1 Safety Mode: Normal 
    Fault2 Safety Mode: Normal 
    Fault3 Safety Mode: Normal 
    Fault Enable Mode: None 
    None: None 
          None 
          None 
    PWM&FAULT path: Direct Fault 
                    Direct Fault 
                    Direct Fault 
                    Direct Fault 
    Fault Glitch Stretching: Disabled 
    Fault Filter Period: 0
    Fault Filter Count: 3 
    Fault 4 Pin: Disable
    Fault 5 Pin: Disable
    Fault 6 Pin: Disable
    Fault 7 Pin: Disable
    Submodule 0: Disable Pins PWMA by Fault: Fault 0: Yes
                 Disable Pins PWMA by Fault: Fault 1: Yes
                 Disable Pins PWMA by Fault: Fault 2: Yes
                 Disable Pins PWMA by Fault: Fault 3: Yes
                 Disable Pins PWMB by Fault: Fault 0: Yes
                 Disable Pins PWMB by Fault: Fault 1: Yes
                 Disable Pins PWMB by Fault: Fault 2: Yes
                 Disable Pins PWMB by Fault: Fault 3: Yes
                 Disable Pins PWMX by Fault: Fault 0: Yes
                 Disable Pins PWMX by Fault: Fault 1: Yes
                 Disable Pins PWMX by Fault: Fault 2: Yes
                 Disable Pins PWMX by Fault: Fault 3: Yes
                 Disable Pins PWMX by Fault: PWMA Fault State: Logic 0 
                 Disable Pins PWMX by Fault: PWMB Fault State: Logic 0 
                 Disable Pins PWMX by Fault: PWMX Fault State: Logic 0 
    Submodule 1: Disable Pins PWMA by Fault: Fault 0: Yes
                 Disable Pins PWMA by Fault: Fault 1: Yes
                 Disable Pins PWMA by Fault: Fault 2: Yes
                 Disable Pins PWMA by Fault: Fault 3: Yes
                 Disable Pins PWMB by Fault: Fault 0: Yes
                 Disable Pins PWMB by Fault: Fault 1: Yes
                 Disable Pins PWMB by Fault: Fault 2: Yes
                 Disable Pins PWMB by Fault: Fault 3: Yes
                 Disable Pins PWMX by Fault: Fault 0: Yes
                 Disable Pins PWMX by Fault: Fault 1: Yes
                 Disable Pins PWMX by Fault: Fault 2: Yes
                 Disable Pins PWMX by Fault: Fault 3: Yes
                 Disable Pins PWMX by Fault: PWMA Fault State: Logic 0 
                 Disable Pins PWMX by Fault: PWMB Fault State: Logic 0 
                 Disable Pins PWMX by Fault: PWMX Fault State: Logic 0 
    Submodule 2: Disable Pins PWMA by Fault: Fault 0: Yes
                 Disable Pins PWMA by Fault: Fault 1: Yes
                 Disable Pins PWMA by Fault: Fault 2: Yes
                 Disable Pins PWMA by Fault: Fault 3: Yes
                 Disable Pins PWMB by Fault: Fault 0: Yes
                 Disable Pins PWMB by Fault: Fault 1: Yes
                 Disable Pins PWMB by Fault: Fault 2: Yes
                 Disable Pins PWMB by Fault: Fault 3: Yes
                 Disable Pins PWMX by Fault: Fault 0: Yes
                 Disable Pins PWMX by Fault: Fault 1: Yes
                 Disable Pins PWMX by Fault: Fault 2: Yes
                 Disable Pins PWMX by Fault: Fault 3: Yes
                 Disable Pins PWMX by Fault: PWMA Fault State: Logic 0 
                 Disable Pins PWMX by Fault: PWMB Fault State: Logic 0 
                 Disable Pins PWMX by Fault: PWMX Fault State: Logic 0 
    Submodule 3: Disable Pins PWMA by Fault: Fault 4: Yes
                 Disable Pins PWMA by Fault: Fault 5: Yes
                 Disable Pins PWMA by Fault: Fault 6: Yes
                 Disable Pins PWMA by Fault: Fault 7: Yes
                 Disable Pins PWMB by Fault: Fault 4: Yes
                 Disable Pins PWMB by Fault: Fault 5: Yes
                 Disable Pins PWMB by Fault: Fault 6: Yes
                 Disable Pins PWMB by Fault: Fault 7: Yes
                 Disable Pins PWMX by Fault: Fault 4: Yes
                 Disable Pins PWMX by Fault: Fault 5: Yes
                 Disable Pins PWMX by Fault: Fault 6: Yes
                 Disable Pins PWMX by Fault: Fault 7: Yes
                 Disable Pins PWMX by Fault: PWMA Fault State: Logic 0 
                 Disable Pins PWMX by Fault: PWMB Fault State: Logic 0 
                 Disable Pins PWMX by Fault: PWMX Fault State: Logic 0
.*/

/*.
    PWM_A_0 Configuration
--------------------------------------------
    Debug Mode Operation: Stop 
    Wait Mode Operation: Stop 
    Load Mode: End cycle 
    Load OK: Yes
    PWM Clock Enable: Yes
    Clock Source: IPBus Clock 
    Prescaler: fclk/1 
    INIT register: -5000
    VAL1 register: 4999
    Fraction (FRACVAL1): 0
    Sync. source: Local sync (PWMX) 
    Reload source: This module 
    Reload Frequency: Every opportunity 
    Half Cycle Reload: Disable
    Full Cycle Reload: Enable 
    PWMA Mask: Normal 
    PWMB Mask: Normal 
    PWMX Mask: Normal 
    PWMA Output Polarity: Active High 
    PWMB Output Polarity: Active High 
    PWMX Output Polarity: Active High 
    PWMA Output enable: Enabled 
    PWMB Output enable: Enabled 
    PWMX Output enable: Enabled 
    PWMA and PWMB Pair Operation: Complementary 
    Initialize value registers: Enable 
    PWM Value 2: -2500
    PWM Value 3: 2500
    PWM Value 4: -4980
    PWM Value 5: -4500
    PWM Value X: 0
    PWM compare mode: Eqal to 
    Trigger output generated every final PWM: Disable
    Value 0: Disable
    Value1: Disable
    Value 2: Disable
    Value3: Disable
    Value 4: Enable 
    Value5: Disable
    Double Switching: PWM23 
    Deadtime count 1: 150
    Software Controlled Output: Logic 0 
                                Logic 0 
    Force Initialization Enable: No 
    Source of FORCE OUTPUT signal: Local force CTRL2[FORCE] 
    Dead Time Source 23: PWM23 
    Dead Time Source 45: PWM45 
    PWM45 Initial Value: Logic 0 
                         Logic 0 
    PWMX Initial Value: Logic 0 
    Reload: Disable
    Reload Error: Disable
    Value 0 Compare: Disable
    Value 1 Compare: Disable
    Value 2 Compare: Disable
    Value 3 Compare: Disable
    Value 4 Compare: Disable
    Value 5 Compare: Disable
    Capture A0: Disable
    Capture A1: Disable
    Capture B0: Disable
    Capture B1: Disable
    Capture X0: Disable
    Capture X1: Disable
    Capture A Input select: Raw PWMA input 
    Capture B Input select: Raw PWMA input 
    Capture X Input select: Raw PWMA input 
    One Shot mode enable: Disable
                          Disable
                          Disable
    Edge Counter Enable: Disable
                         Disable
                         Disable
    Edge Compare A Value: 0
    Edge Compare B Value: 0
    Edge Compare X Value: 0
    Capture A0 Edge Select: Disabled 
    Capture A1 Edge Select: Disabled 
    Capture B0 Edge Select: Disabled 
    Capture B1 Edge Select: Disabled 
    Capture X0 Edge Select: Disabled 
    Capture X1 Edge Select: Disabled 
    PWMX Double Switching: Disable
    Capture A0: Disable
    Capture A1: Disable
    Capture B0: Disable
    Capture B1: Disable
    Capture X0: Disable
    Capture X1: Disable
    Source of capture DMA: DMA disabled 
    Enable DMA Write Requests For alue Registers: No 
    Output Trigger 0 Source: PWM_OUT_TRIG0 
    Output Trigger 1 Source: PWM_OUT_TRIG1
.*/
#define PWM_A_0_CTRL_INIT                 0x0400U
#define PWM_A_0_CTRL2_INIT                0x0000U
#define PWM_A_0_USE_PWMVAL                1
#define PWM_A_0_INIT_INIT                 0xEC78U
#define PWM_A_0_VAL1_INIT                 0x1387U
#define PWM_A_0_VAL0_INIT                 0x0000U
#define PWM_A_0_VAL2_INIT                 0xF63CU
#define PWM_A_0_VAL3_INIT                 0x09C4U
#define PWM_A_0_VAL4_INIT                 0xEC8CU
#define PWM_A_0_VAL5_INIT                 0xEE6CU
#define PWM_A_0_FRACVAL2_INIT             0x0000U
#define PWM_A_0_FRACVAL3_INIT             0x0000U
#define PWM_A_0_FRACVAL4_INIT             0x0000U
#define PWM_A_0_FRACVAL5_INIT             0x0000U
#define PWM_A_0_TCTRL_INIT                0x0010U
#define PWM_A_0_DTCNT0_INIT               0x0096U
#define PWM_A_0_DTCNT1_INIT               0x0096U
#define PWM_A_0_DISMAP0_INIT              0xF333U

/*.
    PWM_A_1 Configuration
--------------------------------------------
    Debug Mode Operation: Stop 
    Wait Mode Operation: Stop 
    Load Mode: End cycle 
    Load OK: Yes
    PWM Clock Enable: Yes
    Clock Source: PWM_0 clock 
    Prescaler: fclk/1 
    INIT register: -5000
    VAL1 register: 4999
    Fraction (FRACVAL1): 0
    Sync. source: Master sync (PWM_0) 
    Reload source: PWM_0 module 
    Reload Frequency: Every opportunity 
    Half Cycle Reload: Disable
    Full Cycle Reload: Enable 
    PWMA Mask: Normal 
    PWMB Mask: Normal 
    PWMX Mask: Normal 
    PWMA Output Polarity: Active High 
    PWMB Output Polarity: Active High 
    PWMX Output Polarity: Active High 
    PWMA Output enable: Enabled 
    PWMB Output enable: Enabled 
    PWMX Output enable: Enabled 
    PWMA and PWMB Pair Operation: Complementary 
    Initialize value registers: Enable 
    PWM Value 2: -2500
    PWM Value 3: 2500
    PWM Value 4: 0
    PWM Value 5: 0
    PWM Value X: 0
    PWM compare mode: Eqal to 
    Trigger output generated every final PWM: Disable
    Value 0: Disable
    Value1: Disable
    Value 2: Disable
    Value3: Disable
    Value 4: Disable
    Value5: Disable
    Double Switching: PWM23 
    Deadtime count 1: 150
    Software Controlled Output: Logic 0 
                                Logic 0 
    Force Initialization Enable: No 
    Source of FORCE OUTPUT signal: Local force CTRL2[FORCE] 
    Dead Time Source 23: PWM23 
    Dead Time Source 45: PWM45 
    PWM45 Initial Value: Logic 0 
                         Logic 0 
    PWMX Initial Value: Logic 0 
    Reload: Disable
    Reload Error: Disable
    Value 0 Compare: Disable
    Value 1 Compare: Disable
    Value 2 Compare: Disable
    Value 3 Compare: Disable
    Value 4 Compare: Disable
    Value 5 Compare: Disable
    Capture A0: Disable
    Capture A1: Disable
    Capture B0: Disable
    Capture B1: Disable
    Capture X0: Disable
    Capture X1: Disable
    Capture A Input select: Raw PWMA input 
    Capture B Input select: Raw PWMA input 
    Capture X Input select: Raw PWMA input 
    One Shot mode enable: Disable
                          Disable
                          Disable
    Edge Counter Enable: Disable
                         Disable
                         Disable
    Edge Compare A Value: 0
    Edge Compare B Value: 0
    Edge Compare X Value: 0
    Capture A0 Edge Select: Disabled 
    Capture A1 Edge Select: Disabled 
    Capture B0 Edge Select: Disabled 
    Capture B1 Edge Select: Disabled 
    Capture X0 Edge Select: Disabled 
    Capture X1 Edge Select: Disabled 
    PWMX Double Switching: Disable
    Capture A0: Disable
    Capture A1: Disable
    Capture B0: Disable
    Capture B1: Disable
    Capture X0: Disable
    Capture X1: Disable
    Source of capture DMA: DMA disabled 
    Enable DMA Write Requests For alue Registers: No 
    Output Trigger 0 Source: PWM_OUT_TRIG0 
    Output Trigger 1 Source: PWM_OUT_TRIG1
.*/
#define PWM_A_1_CTRL_INIT                 0x0400U
#define PWM_A_1_CTRL2_INIT                0x0206U
#define PWM_A_1_USE_PWMVAL                1
#define PWM_A_1_INIT_INIT                 0xEC78U
#define PWM_A_1_VAL1_INIT                 0x1387U
#define PWM_A_1_VAL0_INIT                 0x0000U
#define PWM_A_1_VAL2_INIT                 0xF63CU
#define PWM_A_1_VAL3_INIT                 0x09C4U
#define PWM_A_1_VAL4_INIT                 0x0000U
#define PWM_A_1_VAL5_INIT                 0x0000U
#define PWM_A_1_FRACVAL2_INIT             0x0000U
#define PWM_A_1_FRACVAL3_INIT             0x0000U
#define PWM_A_1_FRACVAL4_INIT             0x0000U
#define PWM_A_1_FRACVAL5_INIT             0x0000U
#define PWM_A_1_DTCNT0_INIT               0x0096U
#define PWM_A_1_DTCNT1_INIT               0x0096U
#define PWM_A_1_DISMAP0_INIT              0xF333U

/*.
    PWM_A_2 Configuration
--------------------------------------------
    Debug Mode Operation: Stop 
    Wait Mode Operation: Stop 
    Load Mode: End cycle 
    Load OK: Yes
    PWM Clock Enable: Yes
    Clock Source: PWM_0 clock 
    Prescaler: fclk/1 
    INIT register: -5000
    VAL1 register: 4999
    Fraction (FRACVAL1): 0
    Sync. source: Master sync (PWM_0) 
    Reload source: PWM_0 module 
    Reload Frequency: Every opportunity 
    Half Cycle Reload: Disable
    Full Cycle Reload: Enable 
    PWMA Mask: Normal 
    PWMB Mask: Normal 
    PWMX Mask: Normal 
    PWMA Output Polarity: Active High 
    PWMB Output Polarity: Active High 
    PWMX Output Polarity: Active High 
    PWMA Output enable: Enabled 
    PWMB Output enable: Enabled 
    PWMX Output enable: Enabled 
    PWMA and PWMB Pair Operation: Complementary 
    Initialize value registers: Enable 
    PWM Value 2: -2500
    PWM Value 3: 2500
    PWM Value 4: 0
    PWM Value 5: 0
    PWM Value X: 0
    PWM compare mode: Eqal to 
    Trigger output generated every final PWM: Disable
    Value 0: Disable
    Value1: Disable
    Value 2: Disable
    Value3: Disable
    Value 4: Disable
    Value5: Disable
    Double Switching: PWM23 
    Deadtime count 1: 150
    Software Controlled Output: Logic 0 
                                Logic 0 
    Force Initialization Enable: No 
    Source of FORCE OUTPUT signal: Local force CTRL2[FORCE] 
    Dead Time Source 23: PWM23 
    Dead Time Source 45: PWM45 
    PWM45 Initial Value: Logic 0 
                         Logic 0 
    PWMX Initial Value: Logic 0 
    Reload: Disable
    Reload Error: Disable
    Value 0 Compare: Disable
    Value 1 Compare: Disable
    Value 2 Compare: Disable
    Value 3 Compare: Disable
    Value 4 Compare: Disable
    Value 5 Compare: Disable
    Capture A0: Disable
    Capture A1: Disable
    Capture B0: Disable
    Capture B1: Disable
    Capture X0: Disable
    Capture X1: Disable
    Capture A Input select: Raw PWMA input 
    Capture B Input select: Raw PWMA input 
    Capture X Input select: Raw PWMA input 
    One Shot mode enable: Disable
                          Disable
                          Disable
    Edge Counter Enable: Disable
                         Disable
                         Disable
    Edge Compare A Value: 0
    Edge Compare B Value: 0
    Edge Compare X Value: 0
    Capture A0 Edge Select: Disabled 
    Capture A1 Edge Select: Disabled 
    Capture B0 Edge Select: Disabled 
    Capture B1 Edge Select: Disabled 
    Capture X0 Edge Select: Disabled 
    Capture X1 Edge Select: Disabled 
    PWMX Double Switching: Disable
    Capture A0: Disable
    Capture A1: Disable
    Capture B0: Disable
    Capture B1: Disable
    Capture X0: Disable
    Capture X1: Disable
    Source of capture DMA: DMA disabled 
    Enable DMA Write Requests For alue Registers: No 
    Output Trigger 0 Source: PWM_OUT_TRIG0 
    Output Trigger 1 Source: PWM_OUT_TRIG1
.*/
#define PWM_A_2_CTRL_INIT                 0x0400U
#define PWM_A_2_CTRL2_INIT                0x0206U
#define PWM_A_2_USE_PWMVAL                1
#define PWM_A_2_INIT_INIT                 0xEC78U
#define PWM_A_2_VAL1_INIT                 0x1387U
#define PWM_A_2_VAL0_INIT                 0x0000U
#define PWM_A_2_VAL2_INIT                 0xF63CU
#define PWM_A_2_VAL3_INIT                 0x09C4U
#define PWM_A_2_VAL4_INIT                 0x0000U
#define PWM_A_2_VAL5_INIT                 0x0000U
#define PWM_A_2_FRACVAL2_INIT             0x0000U
#define PWM_A_2_FRACVAL3_INIT             0x0000U
#define PWM_A_2_FRACVAL4_INIT             0x0000U
#define PWM_A_2_FRACVAL5_INIT             0x0000U
#define PWM_A_2_DTCNT0_INIT               0x0096U
#define PWM_A_2_DTCNT1_INIT               0x0096U
#define PWM_A_2_DISMAP0_INIT              0xF333U

/*.
    PWM_A_3 Configuration
--------------------------------------------
    Debug Mode Operation: Stop 
    Wait Mode Operation: Stop 
    Load Mode: End cycle 
    Load OK: No 
    PWM Clock Enable: No 
    Clock Source: IPBus Clock 
    Prescaler: fclk/1 
    INIT register: 0
    VAL1 register: 0
    Fraction (FRACVAL1): 0
    Sync. source: Local sync (PWMX) 
    Reload source: This module 
    Reload Frequency: Every opportunity 
    Half Cycle Reload: Disable
    Full Cycle Reload: Enable 
    PWMA Mask: Normal 
    PWMB Mask: Normal 
    PWMX Mask: Normal 
    PWMA Output Polarity: Active High 
    PWMB Output Polarity: Active High 
    PWMX Output Polarity: Active High 
    PWMA Output enable: Disabled 
    PWMB Output enable: Disabled 
    PWMX Output enable: Disabled 
    PWMA and PWMB Pair Operation: Complementary 
    Initialize value registers: Disable
    PWM compare mode: Eqal to 
    Trigger output generated every final PWM: Disable
    Value 0: Disable
    Value1: Disable
    Value 2: Disable
    Value3: Disable
    Value 4: Disable
    Value5: Disable
    Double Switching: PWM23 
    Deadtime count 1: 2047
    Software Controlled Output: Logic 0 
                                Logic 0 
    Force Initialization Enable: No 
    Source of FORCE OUTPUT signal: Local force CTRL2[FORCE] 
    Dead Time Source 23: PWM23 
    Dead Time Source 45: PWM45 
    PWM45 Initial Value: Logic 0 
                         Logic 0 
    PWMX Initial Value: Logic 0 
    Reload: Disable
    Reload Error: Disable
    Value 0 Compare: Disable
    Value 1 Compare: Disable
    Value 2 Compare: Disable
    Value 3 Compare: Disable
    Value 4 Compare: Disable
    Value 5 Compare: Disable
    Capture A0: Disable
    Capture A1: Disable
    Capture B0: Disable
    Capture B1: Disable
    Capture X0: Disable
    Capture X1: Disable
    Capture A Input select: Raw PWMA input 
    Capture B Input select: Raw PWMA input 
    Capture X Input select: Raw PWMA input 
    One Shot mode enable: Disable
                          Disable
                          Disable
    Edge Counter Enable: Disable
                         Disable
                         Disable
    Edge Compare A Value: 0
    Edge Compare B Value: 0
    Edge Compare X Value: 0
    Capture A0 Edge Select: Disabled 
    Capture A1 Edge Select: Disabled 
    Capture B0 Edge Select: Disabled 
    Capture B1 Edge Select: Disabled 
    Capture X0 Edge Select: Disabled 
    Capture X1 Edge Select: Disabled 
    PWMX Double Switching: Disable
    Capture A0: Disable
    Capture A1: Disable
    Capture B0: Disable
    Capture B1: Disable
    Capture X0: Disable
    Capture X1: Disable
    Source of capture DMA: DMA disabled 
    Enable DMA Write Requests For alue Registers: No 
    Output Trigger 0 Source: PWM_OUT_TRIG0 
    Output Trigger 1 Source: PWM_OUT_TRIG1
.*/
#define PWM_A_3_CTRL_INIT                 0x0400U
#define PWM_A_3_CTRL2_INIT                0x0000U
#define PWM_A_3_INIT_INIT                 0x0000U
#define PWM_A_3_VAL1_INIT                 0x0000U
#define PWM_A_3_VAL0_INIT                 0x0000U
#define PWM_A_3_VAL2_INIT                 0x0000U
#define PWM_A_3_VAL3_INIT                 0x0000U
#define PWM_A_3_VAL4_INIT                 0x0000U
#define PWM_A_3_VAL5_INIT                 0x0000U
#define PWM_A_3_FRACVAL2_INIT             0x0000U
#define PWM_A_3_FRACVAL3_INIT             0x0000U
#define PWM_A_3_FRACVAL4_INIT             0x0000U
#define PWM_A_3_FRACVAL5_INIT             0x0000U
#define PWM_A_3_DISMAP0_INIT              0xF333U

/*.
    ADC Configuration
--------------------------------------------
    Clock frequency: 20 MHz 
    Trigger source: SYNC0 input 
    Channel Configuration: ANA0-ANA1: Single ended , 
                           ANA2-ANA3: Single ended , 
                           ANB0-ANB1: Single ended , 
                           ANB2-ANB3: Single ended , 
                           ANA4-ANA5: Single ended , 
                           ANA6-ANA7: Single ended , 
                           ANB4-ANB5: Single ended , 
                           ANB6-ANB7: Single ended , 
    Channel to Sample Mapping: SMP0: ANA1 , SMP1: ANA3 , 
                               SMP8: ANB2 , SMP9: ANB0 , 
    Scan Mode: Triggered parallel 
    ANB simulataneous to ANA: Yes
    Enabled samples: / SMP0 SMP1 / / SMP8 SMP9 / / 
    Zero crossing mode: SMP0: Disabled , SMP1: Disabled , SMP2: Disabled , SMP3: Disabled 
                        SMP4: Disabled , SMP5: Disabled , SMP6: Disabled , SMP7: Disabled 
                        SMP8: Disabled , SMP9: Disabled , SMP10: Disabled , SMP11: Disabled 
                        SMP12: Disabled , SMP13: Disabled , SMP14: Disabled , SMP15: Disabled 
                        SMP16: Disabled , SMP17: Disabled , SMP18: Disabled , SMP19: Disabled 
    Auto Power Down Mode: Disable
    Power down converter A (ANA0-ANA7): No 
    Power down converter B (ANB0-ANB7): No 
    Power down voltage reference: Yes
    Power up delay: 26, Power Control: 1.3 us 
    Converter1 VREFLO source: Internal VSSA
    Converter1 VREFH  source: Internal VDDA
    Converter0 VREFLO source: Internal VSSA
    Converter0 VREFH  source: Internal VDDA
    Interrupts: ANA Conversion complete: Enabled 
                High limit error: Disabled
                Low limit error: Disabled
                Zero crossing: Disabled
    ANA channel Gain Configuration: Gain ANA0: 1x , Gain ANA1: 1x 
                                    Gain ANA2: 1x , Gain ANA3: 1x 
                                    Gain ANA4: 1x , Gain ANA5: 1x 
                                    Gain ANA6: 1x , Gain ANA7: 1x 
                                    Gain ANA temp.: 1x , Gain ANA Ain.: 1x 
    ANB channel Gain Configuration: Gain ANB0: 1x , Gain ANB1: 1x 
                                    Gain ANB2: 1x , Gain ANB3: 1x 
                                    Gain ANB4: 1x , Gain ANB5: 1x 
                                    Gain ANB6: 1x , Gain ANB7: 1x 
                                    Gain ANB temp.: 1x , Gain ANB Ain.: 1x 
    ANA Enable: No 
    ANB Enable: No 
    DMA Trigger Source: End Scan 
    ADCA6 input source: Normal (ADCA6 pin) 
    ADCA7 input source: Normal (ADCA7 pin) 
    ADCB6 input source: Normal (ADCB6 pin) 
    ADCB7 input source: Normal (ADCB7 pin)
.*/
#define ADC_ADCR1_INIT                    0x1805U
#define ADC_ADLST1_INIT                   0x3231U
#define ADC_ADLST2_INIT                   0x7654U
#define ADC_ADLST3_INIT                   0xBA8AU
#define ADC_ADLST4_INIT                   0xFEDCU
#define ADC_ADSDIS_INIT                   0xFCFCU
#define ADC_ADCPOWER_INIT                 0x1DA4U

/*.
    HSCMP_C Configuration
--------------------------------------------
    Enable Analog Comparator: Yes
    Output Polarity: Normal. Output High when Positive Input higher than Negative Input
    Positive Comparator Input Source: IN7 (6-bit DAC) 
    Negative Comparator Input Source: IN0 
    Falling Edge Interrupt: Disable
    Rising Edge Interrupt: Disable
    Select hysteresis Level: 1 
    Input Filter: Input Signal Sampling [timer clocks] : 0
                  Consecutive Samples Required to Agree: Disabled 
                  Input Signal Latency: ??? 
    Enable VREF_DAC: Enable 
    DAC Control: V1in 
    Output Level: 231
    Enable DMA: Disable
    Force COUT to 0: Disable
.*/
#define HSCMP_C_CR1_INIT                  0x0011U
#define HSCMP_C_DACCR_INIT                0x00E7U
#define HSCMP_C_MUXCR_INIT                0x00B8U

/*.
    SCI_0 Configuration
--------------------------------------------
    Baudrate: 19201 bps 
    Enable Receiver: Enable 
    Enable Transmitter: Enable 
    Data word length: 8 bits 
    Parity: None 
    Polarity: True polarity 
    Loop mode: Disable
    Function in Wait Mode: SCI module enabled in Wait Mode 
    Interrupts: RX Full: Disable
                RX Error: Disable
                TX Empty: Disable
                TX Empty: Disable
    Enable RX and TX FIFO Queues: Disable
    RX Active Edge: Disable
    Enable TX DMA: Disable
    Enable RX DMA: Disable
    Hold off entry to stop mode: No 
    Rx Idle: Disable
.*/
#define SCI_0_SCIBR_INIT                  0x0A2CU
#define SCI_0_SCICR_INIT                  0x000CU
#define SCI_0_SCICR2_INIT                 0x0000U
#define SCI_0_RX_BUFFER_OKLIMIT           0x000FU
#define SCI_0_RX_BUFFER_LOWLIMIT          0x000AU
#define SCI_0_SCICR3_INIT                 0x0000U

/*.
    FMSTR Configuration
--------------------------------------------
.*/
#define FMSTR_COMM_INTERFACE              1
#define FMSTR_LONG_INTR                   0
#define FMSTR_SHORT_INTR                  0
#define FMSTR_POLL_DRIVEN                 1
#define FMSTR_USE_SCOPE                   1
#define FMSTR_USE_RECORDER                1
#define FMSTR_REC_BUFF_SIZE               2000
#define FMSTR_REC_TIMEBASE                0x8064U


/*.         End of autogenerated code
********************************************************************** ..*/

#endif
